/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class SparseCross<T>
extends PrimitiveOp {
    private Output<Long> outputIndices;
    private Output<T> outputValues;
    private Output<Long> outputShape;

    public static <T, U> SparseCross<T> create(Scope scope, Iterable<Operand<Long>> indices, Iterable<Operand<?>> values, Iterable<Operand<Long>> shapes, Iterable<Operand<?>> denseInputs, Boolean hashedOutput, Long numBuckets, Long hashKey, Class<T> outType, Class<U> internalType) {
        OperationBuilder opBuilder = scope.graph().opBuilder("SparseCross", scope.makeOpName("SparseCross"));
        opBuilder.addInputList(Operands.asOutputs(indices));
        opBuilder.addInputList(Operands.asOutputs(values));
        opBuilder.addInputList(Operands.asOutputs(shapes));
        opBuilder.addInputList(Operands.asOutputs(denseInputs));
        opBuilder.setAttr("hashed_output", hashedOutput);
        opBuilder.setAttr("num_buckets", numBuckets);
        opBuilder.setAttr("hash_key", hashKey);
        opBuilder.setAttr("out_type", DataType.fromClass(outType));
        opBuilder.setAttr("internal_type", DataType.fromClass(internalType));
        return new SparseCross<T>(opBuilder.build());
    }

    public Output<Long> outputIndices() {
        return this.outputIndices;
    }

    public Output<T> outputValues() {
        return this.outputValues;
    }

    public Output<Long> outputShape() {
        return this.outputShape;
    }

    private SparseCross(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.outputIndices = operation.output(outputIdx++);
        this.outputValues = operation.output(outputIdx++);
        this.outputShape = operation.output(outputIdx++);
    }
}

