/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class PaddedBatchDataset
extends PrimitiveOp
implements Operand<Object> {
    private Output<?> handle;

    public static PaddedBatchDataset create(Scope scope, Operand<?> inputDataset, Operand<Long> batchSize, Iterable<Operand<Long>> paddedShapes, Iterable<Operand<?>> paddingValues, List<Shape> outputShapes) {
        OperationBuilder opBuilder = scope.graph().opBuilder("PaddedBatchDataset", scope.makeOpName("PaddedBatchDataset"));
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(batchSize.asOutput());
        opBuilder.addInputList(Operands.asOutputs(paddedShapes));
        opBuilder.addInputList(Operands.asOutputs(paddingValues));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        return new PaddedBatchDataset(opBuilder.build());
    }

    public Output<?> handle() {
        return this.handle;
    }

    @Override
    public Output<Object> asOutput() {
        return this.handle;
    }

    private PaddedBatchDataset(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }
}

