/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.Output;
import org.tensorflow.Tensor;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Constant<T>
extends PrimitiveOp
implements Operand<T> {
    private final Output<T> output;

    public static Constant<Integer> create(Scope scope, int data) {
        return Constant.create(scope, data, Integer.class);
    }

    public static Constant<Integer> create(Scope scope, int[] data) {
        return Constant.create(scope, (Object)data, Integer.class);
    }

    public static Constant<Integer> create(Scope scope, int[][] data) {
        return Constant.create(scope, data, Integer.class);
    }

    public static Constant<Integer> create(Scope scope, int[][][] data) {
        return Constant.create(scope, data, Integer.class);
    }

    public static Constant<Integer> create(Scope scope, int[][][][] data) {
        return Constant.create(scope, data, Integer.class);
    }

    public static Constant<Integer> create(Scope scope, int[][][][][] data) {
        return Constant.create(scope, data, Integer.class);
    }

    public static Constant<Integer> create(Scope scope, int[][][][][][] data) {
        return Constant.create(scope, data, Integer.class);
    }

    public static Constant<Integer> create(Scope scope, long[] shape, IntBuffer data) {
        try (Tensor<Integer> value = Tensor.create(shape, data);){
            Constant<Integer> constant = Constant.createWithTensor(scope, value);
            return constant;
        }
    }

    public static Constant<Float> create(Scope scope, float data) {
        return Constant.create(scope, Float.valueOf(data), Float.class);
    }

    public static Constant<Float> create(Scope scope, float[] data) {
        return Constant.create(scope, data, Float.class);
    }

    public static Constant<Float> create(Scope scope, float[][] data) {
        return Constant.create(scope, data, Float.class);
    }

    public static Constant<Float> create(Scope scope, float[][][] data) {
        return Constant.create(scope, data, Float.class);
    }

    public static Constant<Float> create(Scope scope, float[][][][] data) {
        return Constant.create(scope, data, Float.class);
    }

    public static Constant<Float> create(Scope scope, float[][][][][] data) {
        return Constant.create(scope, data, Float.class);
    }

    public static Constant<Float> create(Scope scope, float[][][][][][] data) {
        return Constant.create(scope, data, Float.class);
    }

    public static Constant<Float> create(Scope scope, long[] shape, FloatBuffer data) {
        try (Tensor<Float> value = Tensor.create(shape, data);){
            Constant<Float> constant = Constant.createWithTensor(scope, value);
            return constant;
        }
    }

    public static Constant<Double> create(Scope scope, double data) {
        return Constant.create(scope, data, Double.class);
    }

    public static Constant<Double> create(Scope scope, double[] data) {
        return Constant.create(scope, data, Double.class);
    }

    public static Constant<Double> create(Scope scope, double[][] data) {
        return Constant.create(scope, data, Double.class);
    }

    public static Constant<Double> create(Scope scope, double[][][] data) {
        return Constant.create(scope, data, Double.class);
    }

    public static Constant<Double> create(Scope scope, double[][][][] data) {
        return Constant.create(scope, data, Double.class);
    }

    public static Constant<Double> create(Scope scope, double[][][][][] data) {
        return Constant.create(scope, data, Double.class);
    }

    public static Constant<Double> create(Scope scope, double[][][][][][] data) {
        return Constant.create(scope, data, Double.class);
    }

    public static Constant<Double> create(Scope scope, long[] shape, DoubleBuffer data) {
        try (Tensor<Double> value = Tensor.create(shape, data);){
            Constant<Double> constant = Constant.createWithTensor(scope, value);
            return constant;
        }
    }

    public static Constant<Long> create(Scope scope, long data) {
        return Constant.create(scope, data, Long.class);
    }

    public static Constant<Long> create(Scope scope, long[] data) {
        return Constant.create(scope, (Object)data, Long.class);
    }

    public static Constant<Long> create(Scope scope, long[][] data) {
        return Constant.create(scope, data, Long.class);
    }

    public static Constant<Long> create(Scope scope, long[][][] data) {
        return Constant.create(scope, data, Long.class);
    }

    public static Constant<Long> create(Scope scope, long[][][][] data) {
        return Constant.create(scope, data, Long.class);
    }

    public static Constant<Long> create(Scope scope, long[][][][][] data) {
        return Constant.create(scope, data, Long.class);
    }

    public static Constant<Long> create(Scope scope, long[][][][][][] data) {
        return Constant.create(scope, data, Long.class);
    }

    public static Constant<Long> create(Scope scope, long[] shape, LongBuffer data) {
        try (Tensor<Long> value = Tensor.create(shape, data);){
            Constant<Long> constant = Constant.createWithTensor(scope, value);
            return constant;
        }
    }

    public static Constant<Boolean> create(Scope scope, boolean data) {
        return Constant.create(scope, data, Boolean.class);
    }

    public static Constant<Boolean> create(Scope scope, boolean[] data) {
        return Constant.create(scope, data, Boolean.class);
    }

    public static Constant<Boolean> create(Scope scope, boolean[][] data) {
        return Constant.create(scope, data, Boolean.class);
    }

    public static Constant<Boolean> create(Scope scope, boolean[][][] data) {
        return Constant.create(scope, data, Boolean.class);
    }

    public static Constant<Boolean> create(Scope scope, boolean[][][][] data) {
        return Constant.create(scope, data, Boolean.class);
    }

    public static Constant<Boolean> create(Scope scope, boolean[][][][][] data) {
        return Constant.create(scope, data, Boolean.class);
    }

    public static Constant<Boolean> create(Scope scope, boolean[][][][][][] data) {
        return Constant.create(scope, data, Boolean.class);
    }

    public static Constant<String> create(Scope scope, String data) {
        return Constant.create(scope, data, StandardCharsets.UTF_8);
    }

    public static Constant<String> create(Scope scope, String data, Charset charset) {
        try (Tensor<String> value = Tensor.create((Object)data.getBytes(charset), String.class);){
            Constant<String> constant = Constant.createWithTensor(scope, Tensor.create((Object)data.getBytes(charset), String.class));
            return constant;
        }
    }

    public static Constant<String> create(Scope scope, byte[] data) {
        return Constant.create(scope, (Object)data, String.class);
    }

    public static Constant<String> create(Scope scope, byte[][] data) {
        return Constant.create(scope, data, String.class);
    }

    public static Constant<String> create(Scope scope, byte[][][] data) {
        return Constant.create(scope, data, String.class);
    }

    public static Constant<String> create(Scope scope, byte[][][][] data) {
        return Constant.create(scope, data, String.class);
    }

    public static Constant<String> create(Scope scope, byte[][][][][] data) {
        return Constant.create(scope, data, String.class);
    }

    public static Constant<String> create(Scope scope, byte[][][][][][] data) {
        return Constant.create(scope, data, String.class);
    }

    public static <T> Constant<T> create(Scope scope, Class<T> type, long[] shape, ByteBuffer data) {
        try (Tensor<T> value = Tensor.create(type, shape, data);){
            Constant<T> constant = Constant.createWithTensor(scope, value);
            return constant;
        }
    }

    public static <T> Constant<T> create(Scope scope, Object object, Class<T> type) {
        try (Tensor<T> value = Tensor.create(object, type);){
            Constant<T> constant = Constant.createWithTensor(scope, value);
            return constant;
        }
    }

    private static <T> Constant<T> createWithTensor(Scope scope, Tensor<T> value) {
        return new Constant<T>(scope.graph().opBuilder("Const", scope.makeOpName("Const")).setAttr("value", value).setAttr("dtype", value.dataType()).build());
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private Constant(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }
}

