/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Converts each string in the input Tensor to the specified numeric type.
 * <p>
 * (Note that int32 overflow results in an error while float overflow
 * results in a rounded value.)
 * 
 * @param <T> data type for {@code output()} output
 */
@Operator
public final class StringToNumber<T extends Number> extends PrimitiveOp implements Operand<T> {
  
  /**
   * Factory method to create a class to wrap a new StringToNumber operation to the graph.
   * 
   * @param scope current graph scope
   * @param stringTensor 
   * @param outType The numeric type to interpret each string in `string_tensor` as.
   * @return a new instance of StringToNumber
   */
  public static <T extends Number> StringToNumber<T> create(Scope scope, Operand<String> stringTensor, Class<T> outType) {
    OperationBuilder opBuilder = scope.graph().opBuilder("StringToNumber", scope.makeOpName("StringToNumber"));
    opBuilder.addInput(stringTensor.asOutput());
    opBuilder.setAttr("out_type", DataType.fromClass(outType));
    return new StringToNumber<T>(opBuilder.build());
  }
  
  /**
   * A Tensor of the same shape as the input `string_tensor`.
   */
  public Output<T> output() {
    return output;
  }
  
  @Override
  public Output<T> asOutput() {
    return output;
  }
  
  private Output<T> output;
  
  private StringToNumber(Operation operation) {
    super(operation);
    int outputIdx = 0;
    output = operation.output(outputIdx++);
  }
}
