/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Use QuantizeAndDequantizeV2 instead.
 * 
 * @param <T> data type for {@code output()} output
 */
@Operator
public final class QuantizeAndDequantize<T extends Number> extends PrimitiveOp implements Operand<T> {
  
  /**
   * Optional attributes for {@link org.tensorflow.op.core.QuantizeAndDequantize}
   */
  public static class Options {
    
    /**
     * @param signedInput 
     */
    public Options signedInput(Boolean signedInput) {
      this.signedInput = signedInput;
      return this;
    }
    
    /**
     * @param numBits 
     */
    public Options numBits(Long numBits) {
      this.numBits = numBits;
      return this;
    }
    
    /**
     * @param rangeGiven 
     */
    public Options rangeGiven(Boolean rangeGiven) {
      this.rangeGiven = rangeGiven;
      return this;
    }
    
    /**
     * @param inputMin 
     */
    public Options inputMin(Float inputMin) {
      this.inputMin = inputMin;
      return this;
    }
    
    /**
     * @param inputMax 
     */
    public Options inputMax(Float inputMax) {
      this.inputMax = inputMax;
      return this;
    }
    
    private Boolean signedInput;
    private Long numBits;
    private Boolean rangeGiven;
    private Float inputMin;
    private Float inputMax;
    
    private Options() {
    }
  }
  
  /**
   * Factory method to create a class to wrap a new QuantizeAndDequantize operation to the graph.
   * 
   * @param scope current graph scope
   * @param input 
   * @param options carries optional attributes values
   * @return a new instance of QuantizeAndDequantize
   */
  public static <T extends Number> QuantizeAndDequantize<T> create(Scope scope, Operand<T> input, Options... options) {
    OperationBuilder opBuilder = scope.graph().opBuilder("QuantizeAndDequantize", scope.makeOpName("QuantizeAndDequantize"));
    opBuilder.addInput(input.asOutput());
    if (options != null) {
      for (Options opts : options) {
        if (opts.signedInput != null) {
          opBuilder.setAttr("signed_input", opts.signedInput);
        }
        if (opts.numBits != null) {
          opBuilder.setAttr("num_bits", opts.numBits);
        }
        if (opts.rangeGiven != null) {
          opBuilder.setAttr("range_given", opts.rangeGiven);
        }
        if (opts.inputMin != null) {
          opBuilder.setAttr("input_min", opts.inputMin);
        }
        if (opts.inputMax != null) {
          opBuilder.setAttr("input_max", opts.inputMax);
        }
      }
    }
    return new QuantizeAndDequantize<T>(opBuilder.build());
  }
  
  /**
   * @param signedInput 
   */
  public static Options signedInput(Boolean signedInput) {
    return new Options().signedInput(signedInput);
  }
  
  /**
   * @param numBits 
   */
  public static Options numBits(Long numBits) {
    return new Options().numBits(numBits);
  }
  
  /**
   * @param rangeGiven 
   */
  public static Options rangeGiven(Boolean rangeGiven) {
    return new Options().rangeGiven(rangeGiven);
  }
  
  /**
   * @param inputMin 
   */
  public static Options inputMin(Float inputMin) {
    return new Options().inputMin(inputMin);
  }
  
  /**
   * @param inputMax 
   */
  public static Options inputMax(Float inputMax) {
    return new Options().inputMax(inputMax);
  }
  
  /**
   */
  public Output<T> output() {
    return output;
  }
  
  @Override
  public Output<T> asOutput() {
    return output;
  }
  
  private Output<T> output;
  
  private QuantizeAndDequantize(Operation operation) {
    super(operation);
    int outputIdx = 0;
    output = operation.output(outputIdx++);
  }
}
