/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Returns the truth value of x AND y element-wise.
 * <p>
 * <i>NOTE</i>: `LogicalAnd` supports broadcasting. More about broadcasting
 * [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
 */
@Operator
public final class LogicalAnd extends PrimitiveOp implements Operand<Boolean> {
  
  /**
   * Factory method to create a class to wrap a new LogicalAnd operation to the graph.
   * 
   * @param scope current graph scope
   * @param x 
   * @param y 
   * @return a new instance of LogicalAnd
   */
  public static LogicalAnd create(Scope scope, Operand<Boolean> x, Operand<Boolean> y) {
    OperationBuilder opBuilder = scope.graph().opBuilder("LogicalAnd", scope.makeOpName("LogicalAnd"));
    opBuilder.addInput(x.asOutput());
    opBuilder.addInput(y.asOutput());
    return new LogicalAnd(opBuilder.build());
  }
  
  /**
   */
  public Output<Boolean> z() {
    return z;
  }
  
  @Override
  public Output<Boolean> asOutput() {
    return z;
  }
  
  private Output<Boolean> z;
  
  private LogicalAnd(Operation operation) {
    super(operation);
    int outputIdx = 0;
    z = operation.output(outputIdx++);
  }
}
