/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;
import org.tensorflow.types.UInt8;

/**
 * Decode the first frame of a GIF-encoded image to a uint8 tensor.
 * <p>
 * GIF with frame or transparency compression are not supported
 * convert animated GIF from compressed to uncompressed by:
 * <p>
 *     convert $src.gif -coalesce $dst.gif
 * <p>
 * This op also supports decoding JPEGs and PNGs, though it is cleaner to use
 * `tf.image.decode_image`.
 */
@Operator
public final class DecodeGif extends PrimitiveOp implements Operand<UInt8> {
  
  /**
   * Factory method to create a class to wrap a new DecodeGif operation to the graph.
   * 
   * @param scope current graph scope
   * @param contents 0-D.  The GIF-encoded image.
   * @return a new instance of DecodeGif
   */
  public static DecodeGif create(Scope scope, Operand<String> contents) {
    OperationBuilder opBuilder = scope.graph().opBuilder("DecodeGif", scope.makeOpName("DecodeGif"));
    opBuilder.addInput(contents.asOutput());
    return new DecodeGif(opBuilder.build());
  }
  
  /**
   * 4-D with shape `[num_frames, height, width, 3]`. RGB order
   */
  public Output<UInt8> image() {
    return image;
  }
  
  @Override
  public Output<UInt8> asOutput() {
    return image;
  }
  
  private Output<UInt8> image;
  
  private DecodeGif(Operation operation) {
    super(operation);
    int outputIdx = 0;
    image = operation.output(outputIdx++);
  }
}
