/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=KeyboardButtonRequestUserBuilderImpl.class)
public class KeyboardButtonRequestUser
implements Validable,
BotApiObject {
    private static final String REQUESTID_FIELD = "request_id";
    private static final String USERISBOT_FIELD = "user_is_bot";
    private static final String USERISPREMIUM_FIELD = "user_is_premium";
    @JsonProperty(value="request_id")
    @NonNull
    private String requestId;
    @JsonProperty(value="user_is_bot")
    private Boolean userIsBot;
    @JsonProperty(value="user_is_premium")
    private Boolean userIsPremium;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.requestId.isEmpty()) {
            throw new TelegramApiValidationException("Text parameter can't be empty", this);
        }
    }

    protected KeyboardButtonRequestUser(KeyboardButtonRequestUserBuilder<?, ?> b) {
        this.requestId = b.requestId;
        if (this.requestId == null) {
            throw new NullPointerException("requestId is marked non-null but is null");
        }
        this.userIsBot = b.userIsBot;
        this.userIsPremium = b.userIsPremium;
    }

    public static KeyboardButtonRequestUserBuilder<?, ?> builder() {
        return new KeyboardButtonRequestUserBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyboardButtonRequestUser)) {
            return false;
        }
        KeyboardButtonRequestUser other = (KeyboardButtonRequestUser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$userIsBot = this.getUserIsBot();
        Boolean other$userIsBot = other.getUserIsBot();
        if (this$userIsBot == null ? other$userIsBot != null : !((Object)this$userIsBot).equals(other$userIsBot)) {
            return false;
        }
        Boolean this$userIsPremium = this.getUserIsPremium();
        Boolean other$userIsPremium = other.getUserIsPremium();
        if (this$userIsPremium == null ? other$userIsPremium != null : !((Object)this$userIsPremium).equals(other$userIsPremium)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        return !(this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeyboardButtonRequestUser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $userIsBot = this.getUserIsBot();
        result = result * 59 + ($userIsBot == null ? 43 : ((Object)$userIsBot).hashCode());
        Boolean $userIsPremium = this.getUserIsPremium();
        result = result * 59 + ($userIsPremium == null ? 43 : ((Object)$userIsPremium).hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        return result;
    }

    @NonNull
    public String getRequestId() {
        return this.requestId;
    }

    public Boolean getUserIsBot() {
        return this.userIsBot;
    }

    public Boolean getUserIsPremium() {
        return this.userIsPremium;
    }

    @JsonProperty(value="request_id")
    public void setRequestId(@NonNull String requestId) {
        if (requestId == null) {
            throw new NullPointerException("requestId is marked non-null but is null");
        }
        this.requestId = requestId;
    }

    @JsonProperty(value="user_is_bot")
    public void setUserIsBot(Boolean userIsBot) {
        this.userIsBot = userIsBot;
    }

    @JsonProperty(value="user_is_premium")
    public void setUserIsPremium(Boolean userIsPremium) {
        this.userIsPremium = userIsPremium;
    }

    public String toString() {
        return "KeyboardButtonRequestUser(requestId=" + this.getRequestId() + ", userIsBot=" + this.getUserIsBot() + ", userIsPremium=" + this.getUserIsPremium() + ")";
    }

    public KeyboardButtonRequestUser(@NonNull String requestId) {
        if (requestId == null) {
            throw new NullPointerException("requestId is marked non-null but is null");
        }
        this.requestId = requestId;
    }

    public KeyboardButtonRequestUser(@NonNull String requestId, Boolean userIsBot, Boolean userIsPremium) {
        if (requestId == null) {
            throw new NullPointerException("requestId is marked non-null but is null");
        }
        this.requestId = requestId;
        this.userIsBot = userIsBot;
        this.userIsPremium = userIsPremium;
    }

    public static abstract class KeyboardButtonRequestUserBuilder<C extends KeyboardButtonRequestUser, B extends KeyboardButtonRequestUserBuilder<C, B>> {
        private String requestId;
        private Boolean userIsBot;
        private Boolean userIsPremium;

        @JsonProperty(value="request_id")
        public B requestId(@NonNull String requestId) {
            if (requestId == null) {
                throw new NullPointerException("requestId is marked non-null but is null");
            }
            this.requestId = requestId;
            return this.self();
        }

        @JsonProperty(value="user_is_bot")
        public B userIsBot(Boolean userIsBot) {
            this.userIsBot = userIsBot;
            return this.self();
        }

        @JsonProperty(value="user_is_premium")
        public B userIsPremium(Boolean userIsPremium) {
            this.userIsPremium = userIsPremium;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "KeyboardButtonRequestUser.KeyboardButtonRequestUserBuilder(requestId=" + this.requestId + ", userIsBot=" + this.userIsBot + ", userIsPremium=" + this.userIsPremium + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class KeyboardButtonRequestUserBuilderImpl
    extends KeyboardButtonRequestUserBuilder<KeyboardButtonRequestUser, KeyboardButtonRequestUserBuilderImpl> {
        private KeyboardButtonRequestUserBuilderImpl() {
        }

        @Override
        protected KeyboardButtonRequestUserBuilderImpl self() {
            return this;
        }

        @Override
        public KeyboardButtonRequestUser build() {
            return new KeyboardButtonRequestUser(this);
        }
    }
}

