/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import org.telegram.telegrambots.meta.api.objects.ResponseParameters;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ApiResponse<T>
implements Serializable {
    private static final String OK_FIELD = "ok";
    private static final String ERROR_CODE_FIELD = "error_code";
    private static final String DESCRIPTION_CODE_FIELD = "description";
    private static final String PARAMETERS_FIELD = "parameters";
    private static final String RESULT_FIELD = "result";
    @JsonProperty(value="ok")
    private Boolean ok;
    @JsonProperty(value="error_code")
    private Integer errorCode;
    @JsonProperty(value="description")
    private String errorDescription;
    @JsonProperty(value="parameters")
    private ResponseParameters parameters;
    @JsonProperty(value="result")
    private T result;

    public String toString() {
        if (this.ok.booleanValue()) {
            return "ApiResponse{ok=" + this.ok + ", result=" + this.result + "}";
        }
        return "ApiResponse{ok=" + this.ok + ", errorCode=" + this.errorCode + ", errorDescription='" + this.errorDescription + "', parameters='" + this.parameters + "'}";
    }

    public static <T> ApiResponseBuilder<T> builder() {
        return new ApiResponseBuilder();
    }

    public Boolean getOk() {
        return this.ok;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public ResponseParameters getParameters() {
        return this.parameters;
    }

    public T getResult() {
        return this.result;
    }

    public ApiResponse() {
    }

    public ApiResponse(Boolean ok, Integer errorCode, String errorDescription, ResponseParameters parameters, T result) {
        this.ok = ok;
        this.errorCode = errorCode;
        this.errorDescription = errorDescription;
        this.parameters = parameters;
        this.result = result;
    }

    public static class ApiResponseBuilder<T> {
        private Boolean ok;
        private Integer errorCode;
        private String errorDescription;
        private ResponseParameters parameters;
        private T result;

        ApiResponseBuilder() {
        }

        @JsonProperty(value="ok")
        public ApiResponseBuilder<T> ok(Boolean ok) {
            this.ok = ok;
            return this;
        }

        @JsonProperty(value="error_code")
        public ApiResponseBuilder<T> errorCode(Integer errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @JsonProperty(value="description")
        public ApiResponseBuilder<T> errorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
            return this;
        }

        @JsonProperty(value="parameters")
        public ApiResponseBuilder<T> parameters(ResponseParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        @JsonProperty(value="result")
        public ApiResponseBuilder<T> result(T result) {
            this.result = result;
            return this;
        }

        public ApiResponse<T> build() {
            return new ApiResponse<T>(this.ok, this.errorCode, this.errorDescription, this.parameters, this.result);
        }

        public String toString() {
            return "ApiResponse.ApiResponseBuilder(ok=" + this.ok + ", errorCode=" + this.errorCode + ", errorDescription=" + this.errorDescription + ", parameters=" + this.parameters + ", result=" + this.result + ")";
        }
    }
}

