/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.messageorigin.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.telegram.telegrambots.meta.api.objects.messageorigin.MessageOrigin;
import org.telegram.telegrambots.meta.api.objects.messageorigin.MessageOriginChannel;
import org.telegram.telegrambots.meta.api.objects.messageorigin.MessageOriginChat;
import org.telegram.telegrambots.meta.api.objects.messageorigin.MessageOriginHiddenUser;
import org.telegram.telegrambots.meta.api.objects.messageorigin.MessageOriginUser;

public class MessageOriginDeserializer
extends StdDeserializer<MessageOrigin> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public MessageOriginDeserializer() {
        this(null);
    }

    private MessageOriginDeserializer(Class<?> vc) {
        super(vc);
    }

    public MessageOrigin deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        if (node.has("type")) {
            String type = node.get("type").asText();
            if ("user".equals(type)) {
                return (MessageOrigin)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<MessageOriginUser>(){});
            }
            if ("hidden_user".equals(type)) {
                return (MessageOrigin)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<MessageOriginHiddenUser>(){});
            }
            if ("chat".equals(type)) {
                return (MessageOrigin)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<MessageOriginChat>(){});
            }
            if ("channel".equals(type)) {
                return (MessageOrigin)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<MessageOriginChannel>(){});
            }
        }
        return null;
    }
}

