/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.reactions;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.api.objects.reactions.ReactionType;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SetMessageReaction
extends BotApiMethodBoolean {
    public static final String PATH = "setMessageReaction";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String MESSAGE_ID_FIELD = "message_id";
    private static final String REACTION_FIELD = "reaction";
    private static final String IS_BIG_FIELD = "is_big";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="message_id")
    @NonNull
    private Integer messageId;
    @JsonProperty(value="reaction")
    private List<ReactionType> reactionTypes;
    @JsonProperty(value="is_big")
    private Boolean isBig;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.reactionTypes != null) {
            for (ReactionType reactionType : this.reactionTypes) {
                reactionType.validate();
            }
        }
    }

    public static SetMessageReactionBuilder builder() {
        return new SetMessageReactionBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetMessageReaction)) {
            return false;
        }
        SetMessageReaction other = (SetMessageReaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageId = this.getMessageId();
        Integer other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !((Object)this$messageId).equals(other$messageId)) {
            return false;
        }
        Boolean this$isBig = this.getIsBig();
        Boolean other$isBig = other.getIsBig();
        if (this$isBig == null ? other$isBig != null : !((Object)this$isBig).equals(other$isBig)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        List<ReactionType> this$reactionTypes = this.getReactionTypes();
        List<ReactionType> other$reactionTypes = other.getReactionTypes();
        return !(this$reactionTypes == null ? other$reactionTypes != null : !((Object)this$reactionTypes).equals(other$reactionTypes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetMessageReaction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : ((Object)$messageId).hashCode());
        Boolean $isBig = this.getIsBig();
        result = result * 59 + ($isBig == null ? 43 : ((Object)$isBig).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        List<ReactionType> $reactionTypes = this.getReactionTypes();
        result = result * 59 + ($reactionTypes == null ? 43 : ((Object)$reactionTypes).hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    public Integer getMessageId() {
        return this.messageId;
    }

    public List<ReactionType> getReactionTypes() {
        return this.reactionTypes;
    }

    public Boolean getIsBig() {
        return this.isBig;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="message_id")
    public void setMessageId(@NonNull Integer messageId) {
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.messageId = messageId;
    }

    @JsonProperty(value="reaction")
    public void setReactionTypes(List<ReactionType> reactionTypes) {
        this.reactionTypes = reactionTypes;
    }

    @JsonProperty(value="is_big")
    public void setIsBig(Boolean isBig) {
        this.isBig = isBig;
    }

    public String toString() {
        return "SetMessageReaction(chatId=" + this.getChatId() + ", messageId=" + this.getMessageId() + ", reactionTypes=" + this.getReactionTypes() + ", isBig=" + this.getIsBig() + ")";
    }

    public SetMessageReaction(@NonNull String chatId, @NonNull Integer messageId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageId = messageId;
    }

    public SetMessageReaction() {
    }

    public SetMessageReaction(@NonNull String chatId, @NonNull Integer messageId, List<ReactionType> reactionTypes, Boolean isBig) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageId = messageId;
        this.reactionTypes = reactionTypes;
        this.isBig = isBig;
    }

    public static class SetMessageReactionBuilder {
        private String chatId;
        private Integer messageId;
        private List<ReactionType> reactionTypes;
        private Boolean isBig;

        public SetMessageReactionBuilder chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        SetMessageReactionBuilder() {
        }

        @JsonProperty(value="chat_id")
        public SetMessageReactionBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="message_id")
        public SetMessageReactionBuilder messageId(@NonNull Integer messageId) {
            if (messageId == null) {
                throw new NullPointerException("messageId is marked non-null but is null");
            }
            this.messageId = messageId;
            return this;
        }

        @JsonProperty(value="reaction")
        public SetMessageReactionBuilder reactionTypes(List<ReactionType> reactionTypes) {
            this.reactionTypes = reactionTypes;
            return this;
        }

        @JsonProperty(value="is_big")
        public SetMessageReactionBuilder isBig(Boolean isBig) {
            this.isBig = isBig;
            return this;
        }

        public SetMessageReaction build() {
            return new SetMessageReaction(this.chatId, this.messageId, this.reactionTypes, this.isBig);
        }

        public String toString() {
            return "SetMessageReaction.SetMessageReactionBuilder(chatId=" + this.chatId + ", messageId=" + this.messageId + ", reactionTypes=" + this.reactionTypes + ", isBig=" + this.isBig + ")";
        }
    }
}

