/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.chatmember.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.telegram.telegrambots.meta.api.objects.chatmember.ChatMember;
import org.telegram.telegrambots.meta.api.objects.chatmember.ChatMemberAdministrator;
import org.telegram.telegrambots.meta.api.objects.chatmember.ChatMemberBanned;
import org.telegram.telegrambots.meta.api.objects.chatmember.ChatMemberLeft;
import org.telegram.telegrambots.meta.api.objects.chatmember.ChatMemberMember;
import org.telegram.telegrambots.meta.api.objects.chatmember.ChatMemberOwner;
import org.telegram.telegrambots.meta.api.objects.chatmember.ChatMemberRestricted;

public class ChatMemberDeserializer
extends StdDeserializer<ChatMember> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public ChatMemberDeserializer() {
        this(null);
    }

    private ChatMemberDeserializer(Class<?> vc) {
        super(vc);
    }

    public ChatMember deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String type;
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        switch (type = node.has("status") ? node.get("status").asText() : "") {
            case "administrator": {
                return (ChatMember)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<ChatMemberAdministrator>(){});
            }
            case "kicked": {
                return (ChatMember)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<ChatMemberBanned>(){});
            }
            case "left": {
                return (ChatMember)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<ChatMemberLeft>(){});
            }
            case "member": {
                return (ChatMember)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<ChatMemberMember>(){});
            }
            case "creator": {
                return (ChatMember)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<ChatMemberOwner>(){});
            }
            case "restricted": {
                return (ChatMember)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<ChatMemberRestricted>(){});
            }
        }
        return null;
    }
}

