/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.ChatInviteLink;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class CreateChatInviteLink
extends BotApiMethod<ChatInviteLink> {
    public static final String PATH = "createChatInviteLink";
    private static final String CHATID_FIELD = "chat_id";
    private static final String EXPIREDATE_FIELD = "expire_date";
    private static final String MEMBERLIMIT_FIELD = "member_limit";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="expire_date")
    private Integer expireDate;
    @JsonProperty(value="member_limit")
    private Integer memberLimit;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public ChatInviteLink deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<ChatInviteLink>>(){});
            if (result.getOk().booleanValue()) {
                return (ChatInviteLink)result.getResult();
            }
            throw new TelegramApiRequestException("Error creating invite link", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.memberLimit != null && (this.memberLimit < 1 || this.memberLimit > 99999)) {
            throw new TelegramApiValidationException("MemberLimit must be between 1 and 99999", this);
        }
    }

    public static CreateChatInviteLinkBuilder builder() {
        return new CreateChatInviteLinkBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateChatInviteLink)) {
            return false;
        }
        CreateChatInviteLink other = (CreateChatInviteLink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$expireDate = this.getExpireDate();
        Integer other$expireDate = other.getExpireDate();
        if (this$expireDate == null ? other$expireDate != null : !((Object)this$expireDate).equals(other$expireDate)) {
            return false;
        }
        Integer this$memberLimit = this.getMemberLimit();
        Integer other$memberLimit = other.getMemberLimit();
        if (this$memberLimit == null ? other$memberLimit != null : !((Object)this$memberLimit).equals(other$memberLimit)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        return !(this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateChatInviteLink;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $expireDate = this.getExpireDate();
        result = result * 59 + ($expireDate == null ? 43 : ((Object)$expireDate).hashCode());
        Integer $memberLimit = this.getMemberLimit();
        result = result * 59 + ($memberLimit == null ? 43 : ((Object)$memberLimit).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    public Integer getExpireDate() {
        return this.expireDate;
    }

    public Integer getMemberLimit() {
        return this.memberLimit;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="expire_date")
    public void setExpireDate(Integer expireDate) {
        this.expireDate = expireDate;
    }

    @JsonProperty(value="member_limit")
    public void setMemberLimit(Integer memberLimit) {
        this.memberLimit = memberLimit;
    }

    public String toString() {
        return "CreateChatInviteLink(chatId=" + this.getChatId() + ", expireDate=" + this.getExpireDate() + ", memberLimit=" + this.getMemberLimit() + ")";
    }

    public CreateChatInviteLink() {
    }

    public CreateChatInviteLink(@NonNull String chatId, Integer expireDate, Integer memberLimit) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.expireDate = expireDate;
        this.memberLimit = memberLimit;
    }

    public CreateChatInviteLink(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    public static class CreateChatInviteLinkBuilder {
        private String chatId;
        private Integer expireDate;
        private Integer memberLimit;

        CreateChatInviteLinkBuilder() {
        }

        @JsonProperty(value="chat_id")
        public CreateChatInviteLinkBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="expire_date")
        public CreateChatInviteLinkBuilder expireDate(Integer expireDate) {
            this.expireDate = expireDate;
            return this;
        }

        @JsonProperty(value="member_limit")
        public CreateChatInviteLinkBuilder memberLimit(Integer memberLimit) {
            this.memberLimit = memberLimit;
            return this;
        }

        public CreateChatInviteLink build() {
            return new CreateChatInviteLink(this.chatId, this.expireDate, this.memberLimit);
        }

        public String toString() {
            return "CreateChatInviteLink.CreateChatInviteLinkBuilder(chatId=" + this.chatId + ", expireDate=" + this.expireDate + ", memberLimit=" + this.memberLimit + ")";
        }
    }
}

