/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.api.functions.updates;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.telegram.api.updates.difference.TLAbsDifference;
import org.telegram.tl.StreamingUtils;
import org.telegram.tl.TLContext;
import org.telegram.tl.TLMethod;
import org.telegram.tl.TLObject;

public class TLRequestUpdatesGetDifference
extends TLMethod<TLAbsDifference> {
    public static final int CLASS_ID = 630429265;
    private static final int FLAG_PTS_TOTAL_LIMIT = 1;
    private int flags;
    private int pts;
    private int ptsTotalLimit;
    private int date;
    private int qts;

    @Override
    public int getClassId() {
        return 630429265;
    }

    @Override
    public TLAbsDifference deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject res = StreamingUtils.readTLObject(stream, context);
        if (res == null) {
            throw new IOException("Unable to parse response");
        }
        if (res instanceof TLAbsDifference) {
            return (TLAbsDifference)res;
        }
        throw new IOException("Incorrect response type. Expected " + TLAbsDifference.class.getCanonicalName() + ", got: " + res.getClass().getCanonicalName());
    }

    public int getFlags() {
        return this.flags;
    }

    public int getPts() {
        return this.pts;
    }

    public void setPts(int pts) {
        this.pts = pts;
    }

    public int getPtsTotalLimit() {
        return this.ptsTotalLimit;
    }

    public void setPtsTotalLimit(int ptsTotalLimit) {
        this.ptsTotalLimit = ptsTotalLimit > 0 ? ptsTotalLimit : 0;
        this.setPtsTotalLimit(ptsTotalLimit > 0);
    }

    public int getDate() {
        return this.date;
    }

    public void setDate(int date) {
        this.date = date;
    }

    public int getQts() {
        return this.qts;
    }

    public void setQts(int qts) {
        this.qts = qts;
    }

    private void setPtsTotalLimit(boolean enabled) {
        this.flags = enabled ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamingUtils.writeInt(this.flags, stream);
        StreamingUtils.writeInt(this.pts, stream);
        if ((this.flags & 1) != 0) {
            StreamingUtils.writeInt(this.ptsTotalLimit, stream);
        }
        StreamingUtils.writeInt(this.date, stream);
        StreamingUtils.writeInt(this.qts, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamingUtils.readInt(stream);
        this.pts = StreamingUtils.readInt(stream);
        if ((this.flags & 1) != 0) {
            this.ptsTotalLimit = StreamingUtils.readInt(stream);
        }
        this.date = StreamingUtils.readInt(stream);
        this.qts = StreamingUtils.readInt(stream);
    }

    @Override
    public String toString() {
        return "updates.getDifference#25939651";
    }
}

