/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.language.SortSpecification;
import org.teiid.logging.LogManager;
import org.teiid.query.processor.relational.ListNestedSortComparator;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.util.CommandContext;

public class SortUtility {
    private TupleSource source;
    private Mode mode;
    private BufferManager bufferManager;
    private String groupName;
    private List<? extends Expression> schema;
    private int schemaSize;
    private int batchSize;
    private ListNestedSortComparator comparator;
    private int targetRowCount;
    private boolean doneReading;
    private int phase = 1;
    private List<TupleBuffer> activeTupleBuffers = new ArrayList<TupleBuffer>();
    private static final int INITIAL_SORT = 1;
    private static final int MERGE = 2;
    private static final int DONE = 3;
    private TupleBuffer workingBuffer;
    private long[] attempts = new long[2];
    private boolean nonBlocking;
    private static boolean STABLE_SORT = (Boolean)PropertiesUtils.getHierarchicalProperty((String)"org.teiid.requireStableSort", (Object)false, Boolean.class);
    private boolean stableSort = STABLE_SORT;
    private Future<Void> future;

    public SortUtility(TupleSource sourceID, List<OrderByItem> items, Mode mode, BufferManager bufferMgr, String groupName, List<? extends Expression> schema) {
        List<? extends Expression> sortElements = null;
        List<Boolean> sortTypes = null;
        ArrayList<SortSpecification.NullOrdering> nullOrderings = null;
        int distinctIndex = -1;
        if (items == null) {
            sortElements = schema;
            sortTypes = Collections.nCopies(sortElements.size(), true);
        } else {
            sortElements = new ArrayList<Expression>(items.size());
            sortTypes = new ArrayList<Boolean>(items.size());
            nullOrderings = new ArrayList<SortSpecification.NullOrdering>(items.size());
            for (OrderByItem orderByItem : items) {
                sortElements.add(orderByItem.getSymbol());
                sortTypes.add(orderByItem.isAscending());
                nullOrderings.add(orderByItem.getNullOrdering());
            }
            if (items.size() < schema.size() && mode == Mode.DUP_REMOVE_SORT) {
                ArrayList<? extends Expression> toAdd = new ArrayList<Expression>(schema);
                toAdd.removeAll(sortElements);
                sortElements.addAll(toAdd);
                sortTypes.addAll(Collections.nCopies(sortElements.size() - sortTypes.size(), true));
                nullOrderings.addAll(Collections.nCopies(sortElements.size() - nullOrderings.size(), null));
                distinctIndex = items.size() - 1;
            }
        }
        int[] cols = new int[sortElements.size()];
        ListIterator<? extends Expression> iter = sortElements.listIterator();
        while (iter.hasNext()) {
            Expression elem = iter.next();
            cols[iter.previousIndex()] = schema.indexOf(elem);
            Assertion.assertTrue((cols[iter.previousIndex()] != -1 ? 1 : 0) != 0);
        }
        this.init(sourceID, mode, bufferMgr, groupName, schema, sortTypes, nullOrderings, cols);
        if (distinctIndex != -1) {
            this.comparator.setDistinctIndex(distinctIndex);
        }
    }

    public SortUtility(TupleSource sourceID, Mode mode, BufferManager bufferMgr, String groupName, List<? extends Expression> schema, List<Boolean> sortTypes, List<SortSpecification.NullOrdering> nullOrderings, int[] cols) {
        this.init(sourceID, mode, bufferMgr, groupName, schema, sortTypes, nullOrderings, cols);
    }

    private void init(TupleSource sourceID, Mode mode, BufferManager bufferMgr, String groupName, List<? extends Expression> schema, List<Boolean> sortTypes, List<SortSpecification.NullOrdering> nullOrderings, int[] cols) {
        this.source = sourceID;
        this.mode = mode;
        this.bufferManager = bufferMgr;
        this.groupName = groupName;
        this.schema = schema;
        this.schemaSize = this.bufferManager.getSchemaSize(this.schema);
        this.batchSize = this.bufferManager.getProcessorBatchSize(this.schema);
        this.targetRowCount = Math.max(this.bufferManager.getMaxProcessingSize() / this.schemaSize, 2) * this.batchSize;
        this.comparator = new ListNestedSortComparator(cols, sortTypes).defaultNullOrder(bufferMgr.getOptions().getDefaultNullOrder());
        int distinctIndex = cols.length - 1;
        this.comparator.setDistinctIndex(distinctIndex);
        this.comparator.setNullOrdering(nullOrderings);
    }

    public SortUtility(TupleSource ts, List<? extends Expression> expressions, List<Boolean> types, Mode mode, BufferManager bufferManager, String connectionID, List schema) {
        this(ts, new OrderBy(expressions, types).getOrderByItems(), mode, bufferManager, connectionID, schema);
    }

    public TupleBuffer sort() throws TeiidComponentException, TeiidProcessingException {
        return this.sort(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TupleBuffer sort(int rowLimit) throws TeiidComponentException, TeiidProcessingException {
        boolean success = false;
        try {
            this.waitForWork();
            SortUtility sortUtility = this;
            synchronized (sortUtility) {
                try {
                    if (this.phase == 1) {
                        this.initialSort(false, false, rowLimit);
                    }
                    if (this.phase == 2) {
                        this.mergePhase(rowLimit);
                    }
                    success = true;
                    TupleBuffer tupleBuffer = this.activeTupleBuffers.get(0);
                    return tupleBuffer;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (BlockedException e) {
                        success = true;
                        throw e;
                    }
                }
            }
        }
        finally {
            if (!success) {
                this.remove();
            }
        }
    }

    public List<TupleBuffer> onePassSort(boolean lowLatency) throws TeiidComponentException, TeiidProcessingException {
        boolean success = false;
        try {
            if (this.phase == 1) {
                this.initialSort(true, lowLatency, -1);
                if (!this.isDoneReading()) {
                    this.phase = 1;
                }
            }
            for (TupleBuffer tb : this.activeTupleBuffers) {
                tb.close();
                tb.setForwardOnly(false);
            }
            success = true;
            List<TupleBuffer> list = this.activeTupleBuffers;
            return list;
        }
        catch (BlockedException e) {
            success = true;
            throw e;
        }
        finally {
            if (!success) {
                this.remove();
            }
        }
    }

    private TupleBuffer createTupleBuffer() throws TeiidComponentException {
        TupleBuffer tb = this.bufferManager.createTupleBuffer(this.schema, this.groupName, BufferManager.TupleSourceType.PROCESSOR);
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)"Created intermediate sort buffer", (Object)tb);
        }
        tb.setForwardOnly(true);
        return tb;
    }

    protected void initialSort(boolean onePass, boolean lowLatency, int rowLimit) throws TeiidComponentException, TeiidProcessingException {
        CommandContext cc;
        CommandContext cc2;
        long end = Long.MAX_VALUE;
        if (!this.nonBlocking && (cc2 = CommandContext.getThreadLocalContext()) != null && cc2.getWorkItem() != null) {
            end = System.nanoTime() + (cc2.getTimeSliceEnd() - System.currentTimeMillis()) * 1000000L;
        }
        if (this.source == null) {
            this.doneReading = true;
        }
        block2: while (!this.doneReading) {
            if (this.workingBuffer == null) {
                this.workingBuffer = this.createTupleBuffer();
            }
            while (!this.doneReading) {
                try {
                    List<?> tuple = this.source.nextTuple();
                    if (tuple == null) {
                        this.doneReading = true;
                        continue block2;
                    }
                    this.workingBuffer.addTuple(tuple);
                    if (!onePass || !lowLatency || this.workingBuffer.getRowCount() <= (long)(2 * this.targetRowCount)) {
                        if (end == Long.MAX_VALUE || this.workingBuffer.getRowCount() % 32L != 1L || System.nanoTime() <= end) continue;
                        CommandContext.getThreadLocalContext().getWorkItem().moreWork();
                        throw BlockedException.block("Blocking on large sort");
                    }
                    break block2;
                }
                catch (BlockedException e) {
                    if (!onePass) {
                        throw e;
                    }
                    if (this.workingBuffer.getRowCount() >= (long)this.targetRowCount) break block2;
                    throw e;
                }
            }
        }
        long rowCount = this.workingBuffer.getRowCount();
        if (!this.nonBlocking && !onePass && (cc = CommandContext.getThreadLocalContext()) != null && cc.isParallel() && (rowCount > 0x200000L && rowCount > (long)(this.targetRowCount << 3) || rowCount > (long)(this.targetRowCount << 5))) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)"conditions met to perform async sort");
            this.workAsync(rowLimit, cc);
        }
        this.sortWorking(rowLimit);
    }

    private void waitForWork() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.future == null) {
            return;
        }
        if (!this.future.isDone()) {
            throw BlockedException.block("Waiting on sort operation");
        }
        try {
            this.future.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof BlockedException) {
                return;
            }
            if (e.getCause() instanceof TeiidComponentException) {
                throw (TeiidComponentException)e.getCause();
            }
            if (e.getCause() instanceof TeiidProcessingException) {
                throw (TeiidProcessingException)e.getCause();
            }
            if (e.getCause() instanceof TeiidRuntimeException) {
                throw (TeiidRuntimeException)e.getCause();
            }
            throw new TeiidRuntimeException((Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new TeiidRuntimeException((Throwable)e);
        }
        finally {
            this.future = null;
        }
    }

    private void workAsync(final int rowLimit, CommandContext cc) throws BlockedException {
        this.future = cc.submit(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                SortUtility sortUtility = SortUtility.this;
                synchronized (sortUtility) {
                    if (SortUtility.this.phase == 1) {
                        SortUtility.this.sortWorking(rowLimit);
                    }
                    if (SortUtility.this.phase == 2) {
                        SortUtility.this.doMerge(rowLimit);
                    }
                }
                return null;
            }
        });
        throw BlockedException.block("Waiting on sort operation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortWorking(int rowLimit) throws TeiidComponentException, TeiidProcessingException {
        block20: {
            int totalReservedBuffers = 0;
            try {
                int maxRows = this.batchSize;
                AbstractCollection workingTuples = null;
                boolean done = false;
                this.workingBuffer.close();
                this.schemaSize = Math.max(1, this.workingBuffer.getRowSizeEstimate() * this.batchSize);
                long rowCount = this.workingBuffer.getRowCount();
                long memorySpaceNeeded = rowCount * (long)this.workingBuffer.getRowSizeEstimate();
                totalReservedBuffers = this.bufferManager.reserveBuffers(Math.min(this.bufferManager.getMaxProcessingSize(), (int)Math.min(memorySpaceNeeded, Integer.MAX_VALUE)), BufferManager.BufferReserveMode.FORCE);
                if ((long)totalReservedBuffers != memorySpaceNeeded) {
                    int processingSublists = Math.max(2, this.bufferManager.getMaxProcessingSize() / this.schemaSize);
                    int desiredSpace = (int)Math.min(Integer.MAX_VALUE, (this.workingBuffer.getRowCount() / (long)processingSublists + this.workingBuffer.getRowCount() % (long)processingSublists) * (long)this.workingBuffer.getRowSizeEstimate());
                    if (desiredSpace > totalReservedBuffers) {
                        totalReservedBuffers += this.bufferManager.reserveBuffers(desiredSpace - totalReservedBuffers, BufferManager.BufferReserveMode.NO_WAIT);
                    } else if (memorySpaceNeeded <= Integer.MAX_VALUE) {
                        totalReservedBuffers += this.bufferManager.reserveBuffers((int)memorySpaceNeeded - totalReservedBuffers, BufferManager.BufferReserveMode.NO_WAIT);
                    }
                    if (totalReservedBuffers > this.schemaSize) {
                        int additional = totalReservedBuffers % this.schemaSize;
                        totalReservedBuffers -= additional;
                        this.bufferManager.releaseBuffers(additional);
                    }
                }
                TupleBuffer.TupleBufferTupleSource ts = this.workingBuffer.createIndexedTupleSource(this.source != null);
                ts.setReverse(!this.stableSort && this.workingBuffer.getRowCount() > (long)this.batchSize);
                maxRows = Math.max(1, totalReservedBuffers / this.schemaSize) * this.batchSize;
                boolean checkLimit = rowLimit > -1 && rowCount <= (long)maxRows;
                workingTuples = this.mode == Mode.SORT ? new AccessibleArrayList() : new TreeSet(this.comparator);
                while (!done) {
                    while (!done && workingTuples.size() < maxRows) {
                        List<?> tuple = ts.nextTuple();
                        if (tuple == null) {
                            done = true;
                            if (!workingTuples.isEmpty()) break;
                            break block20;
                        }
                        workingTuples.add(tuple);
                    }
                    TupleBuffer sublist = this.createTupleBuffer();
                    this.activeTupleBuffers.add(sublist);
                    if (this.mode == Mode.SORT) {
                        if (workingTuples.size() > 262144) {
                            Arrays.parallelSort(((AccessibleArrayList)workingTuples).elementData, 0, workingTuples.size(), this.comparator);
                        } else {
                            Collections.sort((List)((Object)workingTuples), this.comparator);
                        }
                    }
                    for (List list : workingTuples) {
                        sublist.addTuple(list);
                        if (!checkLimit || sublist.getRowCount() != (long)rowLimit) continue;
                        sublist.saveBatch();
                        break block20;
                    }
                    workingTuples.clear();
                    sublist.saveBatch();
                }
            }
            catch (BlockedException e) {
                Assertion.failed((String)"should not block during memory sublist sorting");
            }
            finally {
                this.bufferManager.releaseBuffers(totalReservedBuffers);
                if (this.workingBuffer != null) {
                    if (this.source != null) {
                        this.workingBuffer.remove();
                    }
                    this.workingBuffer = null;
                }
            }
        }
        if (this.activeTupleBuffers.isEmpty()) {
            this.activeTupleBuffers.add(this.createTupleBuffer());
        }
        this.phase = 2;
    }

    public void setWorkingBuffer(TupleBuffer workingBuffer) {
        this.workingBuffer = workingBuffer;
    }

    protected void mergePhase(int rowLimit) throws TeiidComponentException, TeiidProcessingException {
        if (this.activeTupleBuffers.size() > 1) {
            this.doMerge(rowLimit);
        }
        Assertion.assertTrue((boolean)this.doneReading);
        this.activeTupleBuffers.get(0).close();
        this.activeTupleBuffers.get(0).setForwardOnly(false);
        this.phase = 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMerge(int rowLimit) throws TeiidComponentException, TeiidProcessingException {
        int total;
        int reserved;
        int toForce;
        long desiredSpace;
        block19: {
            desiredSpace = (long)this.activeTupleBuffers.size() * (long)this.schemaSize;
            toForce = (int)Math.min(desiredSpace, (long)Math.max(2 * this.schemaSize, this.bufferManager.getMaxProcessingSize()));
            reserved = 0;
            if (desiredSpace > (long)toForce) {
                try {
                    int subLists = Math.max(2, this.bufferManager.getMaxProcessingSize() / this.schemaSize);
                    int twoPass = subLists * subLists;
                    if (twoPass < this.activeTupleBuffers.size()) {
                        int needed;
                        for (needed = (int)Math.ceil(Math.pow(this.activeTupleBuffers.size(), 0.5)); this.activeTupleBuffers.size() / needed + this.activeTupleBuffers.size() % needed > needed; ++needed) {
                        }
                        if ((reserved += this.bufferManager.reserveBuffersBlocking(needed * this.schemaSize - toForce, this.attempts, false)) == 0 && twoPass * subLists < this.activeTupleBuffers.size()) {
                            for (needed = (int)Math.ceil(Math.pow(this.activeTupleBuffers.size(), 0.3333333333333333)); this.activeTupleBuffers.size() / (needed * needed) + this.activeTupleBuffers.size() % needed > needed; ++needed) {
                            }
                            reserved += this.bufferManager.reserveBuffersBlocking(needed * this.schemaSize - toForce, this.attempts, true);
                            LogManager.logWarning((String)"org.teiid.PROCESSOR", (Object)"performing three pass sort");
                        }
                    } else if (desiredSpace < Integer.MAX_VALUE) {
                        reserved += this.bufferManager.reserveBuffersBlocking((int)desiredSpace - toForce, this.attempts, false);
                    }
                }
                catch (BlockedException be) {
                    if (this.nonBlocking) break block19;
                    throw be;
                }
            }
        }
        if ((total = reserved + toForce) > this.schemaSize) {
            toForce -= total % this.schemaSize;
        }
        reserved += this.bufferManager.reserveBuffers(toForce, BufferManager.BufferReserveMode.FORCE);
        try {
            while (this.activeTupleBuffers.size() > 1) {
                boolean checkLimit;
                ArrayList<SortedSublist> sublists = new ArrayList<SortedSublist>(this.activeTupleBuffers.size());
                TupleBuffer merged = this.createTupleBuffer();
                desiredSpace = (long)this.activeTupleBuffers.size() * (long)this.schemaSize;
                if (desiredSpace < (long)reserved) {
                    this.bufferManager.releaseBuffers(reserved - (int)desiredSpace);
                    reserved = (int)desiredSpace;
                }
                int maxSortIndex = Math.max(2, reserved / this.schemaSize);
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)6)) {
                    LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Merging", maxSortIndex, "sublists out of", this.activeTupleBuffers.size()});
                }
                int i = 0;
                while (i < maxSortIndex) {
                    TupleBuffer activeID = this.activeTupleBuffers.get(i);
                    SortedSublist sortedSublist = new SortedSublist();
                    sortedSublist.its = activeID.createIndexedTupleSource();
                    sortedSublist.its.setNoBlocking(true);
                    sortedSublist.index = i++;
                    this.incrementWorkingTuple(sublists, sortedSublist);
                }
                boolean bl = checkLimit = maxSortIndex == this.activeTupleBuffers.size() && rowLimit > -1;
                while (sublists.size() > 0) {
                    SortedSublist sortedSublist = (SortedSublist)sublists.remove(sublists.size() - 1);
                    merged.addTuple(sortedSublist.tuple);
                    this.incrementWorkingTuple(sublists, sortedSublist);
                    if (!checkLimit || merged.getRowCount() != (long)rowLimit) continue;
                    break;
                }
                for (int i2 = 0; i2 < maxSortIndex; ++i2) {
                    TupleBuffer id = this.activeTupleBuffers.remove(0);
                    id.remove();
                }
                merged.saveBatch();
                this.activeTupleBuffers.add(merged);
            }
        }
        finally {
            this.bufferManager.releaseBuffers(reserved);
        }
    }

    private void incrementWorkingTuple(ArrayList<SortedSublist> subLists, SortedSublist sortedSublist) throws TeiidComponentException, TeiidProcessingException {
        int index;
        do {
            sortedSublist.tuple = null;
            sortedSublist.tuple = sortedSublist.its.nextTuple();
            if (sortedSublist.tuple == null) {
                return;
            }
            index = Collections.binarySearch(subLists, sortedSublist);
            if (index >= 0) continue;
            subLists.add(-index - 1, sortedSublist);
            return;
        } while (this.mode != Mode.SORT);
        subLists.add(index, sortedSublist);
    }

    public boolean isDistinct() {
        return this.comparator.isDistinct();
    }

    public synchronized void remove() {
        if (this.workingBuffer != null && this.source != null) {
            this.workingBuffer.remove();
            this.workingBuffer = null;
        }
        if (!this.activeTupleBuffers.isEmpty()) {
            for (int i = 0; i < this.activeTupleBuffers.size(); ++i) {
                TupleBuffer tb = this.activeTupleBuffers.get(i);
                if (i == 0 && this.phase == 3) continue;
                tb.remove();
            }
            this.activeTupleBuffers.clear();
        }
    }

    public void setNonBlocking(boolean b) {
        this.nonBlocking = b;
    }

    public void setStableSort(boolean stableSort) {
        this.stableSort = stableSort;
    }

    void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isDoneReading() {
        return this.doneReading;
    }

    private class SortedSublist
    implements Comparable<SortedSublist> {
        List<?> tuple;
        int index;
        TupleBuffer.TupleBufferTupleSource its;

        private SortedSublist() {
        }

        @Override
        public int compareTo(SortedSublist o) {
            return -SortUtility.this.comparator.compare(this.tuple, o.tuple);
        }

        public String toString() {
            return this.index + " " + this.tuple;
        }
    }

    public static enum Mode {
        SORT,
        DUP_REMOVE,
        DUP_REMOVE_SORT;

    }

    private static class AccessibleArrayList<T>
    extends AbstractList<T> {
        Object[] elementData = new Object[32];
        int size;

        private AccessibleArrayList() {
        }

        @Override
        public T get(int index) {
            return (T)this.elementData[index];
        }

        @Override
        public T set(int index, T element) {
            Object result = this.elementData[index];
            this.elementData[index] = element;
            return (T)result;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean add(T e) {
            if (this.size == this.elementData.length) {
                this.elementData = Arrays.copyOf(this.elementData, this.elementData.length * 2);
            }
            this.elementData[this.size++] = e;
            return true;
        }

        @Override
        public void clear() {
            Arrays.parallelSetAll(this.elementData, i -> null);
            this.size = 0;
        }
    }
}

