/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.Arrays;
import java.util.List;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.dqp.internal.process.PreparedStatementRequest;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.processor.relational.PlanExecutionNode;
import org.teiid.query.sql.symbol.Reference;

public class InsertPlanExecutionNode
extends PlanExecutionNode {
    private List<Reference> references;
    private int batchRow = 1;
    private int insertCount = 0;
    private TupleBatch currentBatch;
    private QueryMetadataInterface metadata;

    public InsertPlanExecutionNode(int nodeID, QueryMetadataInterface metadata) {
        super(nodeID);
        this.metadata = metadata;
    }

    public void setReferences(List<Reference> references) {
        this.references = references;
    }

    protected void addBatchRow(List row) {
        this.insertCount += ((Integer)row.get(0)).intValue();
    }

    @Override
    protected TupleBatch pullBatch() {
        if (this.isLastBatch()) {
            super.addBatchRow(Arrays.asList(this.insertCount));
        }
        return super.pullBatch();
    }

    @Override
    protected boolean hasNextCommand() {
        return !this.currentBatch.getTerminationFlag() || (long)this.batchRow <= this.currentBatch.getEndRow();
    }

    @Override
    protected boolean openPlanImmediately() {
        return false;
    }

    @Override
    protected boolean prepareNextCommand() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.currentBatch == null) {
            this.currentBatch = this.getChildren()[0].nextBatch();
        }
        if (!this.hasNextCommand()) {
            return false;
        }
        PreparedStatementRequest.resolveParameterValues(this.references, this.currentBatch.getTuple(this.batchRow), this.getProcessorPlan().getContext(), this.metadata);
        ++this.batchRow;
        return true;
    }

    @Override
    public Object clone() {
        InsertPlanExecutionNode clonedNode = new InsertPlanExecutionNode(super.getID(), this.metadata);
        this.copyTo(clonedNode);
        return clonedNode;
    }

    protected void copyTo(InsertPlanExecutionNode target) {
        target.references = this.references;
        super.copyTo(target);
    }

    @Override
    public void closeDirect() {
        super.closeDirect();
        this.currentBatch = null;
    }

    @Override
    public void reset() {
        super.reset();
        this.currentBatch = null;
        this.batchRow = 1;
        this.insertCount = 0;
    }

    @Override
    public Boolean requiresTransaction(boolean transactionalReads) {
        Boolean requires = super.requiresTransaction(transactionalReads);
        if (requires == null || requires.booleanValue()) {
            return true;
        }
        return false;
    }
}

