/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.Collections;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.EvaluatableVisitor;
import org.teiid.query.util.CommandContext;

public class RulePushLargeIn
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        for (PlanNode critNode : NodeEditor.findAllNodes(plan, 16, 1)) {
            SetCriteria setCriteria;
            Criteria crit;
            if (critNode.hasBooleanProperty(NodeConstants.Info.IS_HAVING) || critNode.hasBooleanProperty(NodeConstants.Info.IS_PHANTOM) || !((crit = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA)) instanceof SetCriteria) || (setCriteria = (SetCriteria)crit).isNegated()) continue;
            if (!setCriteria.isAllConstants()) {
                boolean allowed = true;
                for (Expression ex : setCriteria.getValues()) {
                    if (EvaluatableVisitor.willBecomeConstant(ex)) continue;
                    allowed = false;
                    break;
                }
                if (!allowed) continue;
            }
            PlanNode childAccess = critNode.getFirstChild();
            block6: while (true) {
                switch (childAccess.getType()) {
                    case 1: {
                        break block6;
                    }
                    case 16: {
                        break;
                    }
                    default: {
                        break block6;
                    }
                }
                childAccess = childAccess.getFirstChild();
            }
            if (childAccess.getType() != 1) continue;
            critNode.setProperty(NodeConstants.Info.SELECT_CRITERIA, new SetCriteria(setCriteria.getExpression(), Collections.EMPTY_LIST));
            boolean canRaise = RuleRaiseAccess.canRaiseOverSelect(childAccess, metadata, capabilitiesFinder, critNode, analysisRecord);
            critNode.setProperty(NodeConstants.Info.SELECT_CRITERIA, crit);
            if (!canRaise) continue;
            critNode.getParent().replaceChild(critNode, critNode.getFirstChild());
            childAccess.addAsParent(critNode);
            RuleRaiseAccess.performRaise(plan, childAccess, critNode);
            childAccess.setProperty(NodeConstants.Info.IS_DEPENDENT_SET, true);
            childAccess.setProperty(NodeConstants.Info.EST_CARDINALITY, null);
        }
        return plan;
    }

    public String toString() {
        return "PushLargeIn";
    }
}

