/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.StringUtil;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.TransformationMetadata;

public class CompositeMetadataStore
extends MetadataStore {
    private static final long serialVersionUID = 6868525815774998010L;
    private volatile int oidId = 1;
    private volatile TreeMap<String, RecordHolder> oids;

    public CompositeMetadataStore(MetadataStore metadataStore) {
        this.merge(metadataStore);
    }

    public CompositeMetadataStore(List<MetadataStore> metadataStores) {
        for (MetadataStore metadataStore : metadataStores) {
            this.merge(metadataStore);
        }
    }

    public Table findGroup(String fullName) throws QueryMetadataException {
        int index = fullName.indexOf(TransformationMetadata.DELIMITER_STRING);
        if (index == -1) {
            throw new QueryMetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID30353, fullName + TransformationMetadata.NOT_EXISTS_MESSAGE);
        }
        String schemaName = fullName.substring(0, index);
        Schema schema = this.getSchema(schemaName);
        if (schema == null) {
            throw new QueryMetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID30352, fullName + TransformationMetadata.NOT_EXISTS_MESSAGE);
        }
        Table result = (Table)schema.getTables().get(fullName.substring(index + 1));
        if (result == null) {
            throw new QueryMetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID30354, fullName + TransformationMetadata.NOT_EXISTS_MESSAGE);
        }
        return result;
    }

    public Collection<Table> getGroupsForPartialName(String partialGroupName) {
        LinkedList<Table> result = new LinkedList<Table>();
        for (Schema schema : this.getSchemas().values()) {
            for (Table t : schema.getTables().values()) {
                String name = t.getName();
                if (!this.matchesPartialName(partialGroupName, name, schema)) continue;
                result.add(t);
            }
        }
        return result;
    }

    protected boolean matchesPartialName(String partialGroupName, String name, Schema schema) {
        if (!StringUtil.endsWithIgnoreCase((String)name, (String)partialGroupName)) {
            return false;
        }
        int schemaMatch = partialGroupName.length() - name.length();
        return !(schemaMatch > 0 ? schemaMatch != schema.getName().length() + 1 || !StringUtil.startsWithIgnoreCase((String)partialGroupName, (String)schema.getName()) || partialGroupName.charAt(schemaMatch + 1) != '.' : schemaMatch < 0 && name.charAt(-schemaMatch - 1) != '.');
    }

    public Collection<Procedure> getStoredProcedure(String name) {
        Procedure proc;
        String schemaName;
        Schema schema2;
        LinkedList<Procedure> result = new LinkedList<Procedure>();
        int index = name.indexOf(TransformationMetadata.DELIMITER_STRING);
        if (index > -1 && (schema2 = this.getSchema(schemaName = name.substring(0, index))) != null && (proc = (Procedure)schema2.getProcedures().get(name.substring(index + 1))) != null) {
            result.add(proc);
            return result;
        }
        for (Schema schema2 : this.getSchemas().values()) {
            for (Procedure p : schema2.getProcedures().values()) {
                if (!this.matchesPartialName(name, p.getName(), schema2)) continue;
                result.add(p);
            }
        }
        return result;
    }

    private void assignOids(Schema schema, TreeMap<String, RecordHolder> map) {
        this.addOid((AbstractMetadataRecord)schema, map);
        for (Table table : schema.getTables().values()) {
            this.addOid((AbstractMetadataRecord)table, map);
            this.addOids(table.getColumns(), map);
            this.addOids(table.getAllKeys(), map);
        }
        for (Procedure proc : schema.getProcedures().values()) {
            this.addOid((AbstractMetadataRecord)proc, map);
            this.addOids(proc.getParameters(), map);
            if (proc.getResultSet() == null) continue;
            this.addOids(proc.getResultSet().getColumns(), map);
        }
        for (FunctionMethod func : schema.getFunctions().values()) {
            this.addOid((AbstractMetadataRecord)func, map);
            this.addOids(func.getInputParameters(), map);
            this.addOid((AbstractMetadataRecord)func.getOutputParameter(), map);
        }
    }

    private void addOid(AbstractMetadataRecord record, TreeMap<String, RecordHolder> map) {
        RecordHolder old = map.put(record.getUUID(), new RecordHolder(record, this.oidId++));
        if (old != null) {
            throw new AssertionError((Object)("duplicate uid " + record));
        }
        if (record instanceof KeyRecord) {
            this.oidId += ((KeyRecord)record).getColumns().size();
        }
    }

    private void addOids(Collection<? extends AbstractMetadataRecord> records, TreeMap<String, RecordHolder> map) {
        if (records == null) {
            return;
        }
        for (AbstractMetadataRecord abstractMetadataRecord : records) {
            this.addOid(abstractMetadataRecord, map);
        }
    }

    public Integer getOid(String record) {
        RecordHolder holder = this.getOids().get(record);
        if (holder == null) {
            return null;
        }
        return holder.oid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeMap<String, RecordHolder> getOids() {
        if (this.oids == null) {
            CompositeMetadataStore compositeMetadataStore = this;
            synchronized (compositeMetadataStore) {
                if (this.oids == null) {
                    TreeMap<String, RecordHolder> map = new TreeMap<String, RecordHolder>(String.CASE_INSENSITIVE_ORDER);
                    this.addOids(this.getDatatypesExcludingAliases().values(), map);
                    for (Schema s : this.getSchemaList()) {
                        this.assignOids(s, map);
                    }
                    this.oids = map;
                }
            }
        }
        return this.oids;
    }

    public int getMaxOid() {
        this.getOids();
        return this.oidId;
    }

    public static class RecordHolder {
        AbstractMetadataRecord record;
        Integer oid;

        public RecordHolder(AbstractMetadataRecord record, Integer oid) {
            this.record = record;
            this.oid = oid;
        }

        public Integer getOid() {
            return this.oid;
        }

        public AbstractMetadataRecord getRecord() {
            return this.record;
        }
    }
}

