/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.io.IOException;
import java.lang.ref.WeakReference;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.impl.OutOfDiskException;
import org.teiid.common.buffer.impl.SessionKiller;
import org.teiid.core.BundleUtil;
import org.teiid.query.QueryPlugin;

class ConstrainedFileStore
extends FileStore {
    private static final int SESSION_KILLING_RETRIES = 3;
    private WeakReference<SessionMetadata> session;
    private final FileStore delegate;
    private long maxLength = Long.MAX_VALUE;
    private SessionKiller killer;

    ConstrainedFileStore(FileStore delegate, SessionKiller killer) {
        this.delegate = delegate;
        this.killer = killer;
    }

    @Override
    protected int readWrite(long fileOffset, byte[] b, int offSet, int length, boolean write) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLength(long length) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(long start, byte[] bytes, int offset, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void removeDirect() {
        this.updateBytesUsed(-this.delegate.getLength());
        this.delegate.remove();
    }

    @Override
    public int read(long fileOffset, byte[] b, int offSet, int length) throws IOException {
        return this.delegate.read(fileOffset, b, offSet, length);
    }

    @Override
    public void readFully(long fileOffset, byte[] b, int offSet, int length) throws IOException {
        this.delegate.readFully(fileOffset, b, offSet, length);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        if (this.maxLength < Long.MAX_VALUE && this.delegate.getLength() + (long)length > this.maxLength) {
            throw new IOException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31260, new Object[]{this.maxLength}));
        }
        OutOfDiskException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.delegate.write(bytes, offset, length);
                this.updateBytesUsed(length);
                return;
            }
            catch (OutOfDiskException e) {
                ex = e;
                if (!this.killer.killLargestConsumer()) break;
                continue;
            }
        }
        throw ex;
    }

    @Override
    public long getLength() {
        return this.delegate.getLength();
    }

    public void setMaxLength(long maxLength) {
        this.maxLength = maxLength;
    }

    private final void updateBytesUsed(long length) {
        SessionMetadata s;
        if (this.session != null && (s = (SessionMetadata)this.session.get()) != null) {
            s.addAndGetBytesUsed(length);
        }
    }

    public void setSession(SessionMetadata session) {
        this.session = new WeakReference<SessionMetadata>(session);
    }
}

