/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.PhantomReference;
import java.nio.charset.Charset;
import org.teiid.common.buffer.AutoCleanupUtil;
import org.teiid.common.buffer.FileStore;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;

public final class FileStoreInputStreamFactory
extends InputStreamFactory {
    private final FileStore lobBuffer;
    private FileStore.FileStoreOutputStream fsos;
    private String encoding;
    private PhantomReference<Object> cleanup;
    private Writer writer;
    private boolean temporary;

    public FileStoreInputStreamFactory(FileStore lobBuffer, String encoding) {
        this.encoding = encoding;
        this.lobBuffer = lobBuffer;
        this.cleanup = AutoCleanupUtil.setCleanupReference((Object)this, lobBuffer);
    }

    public InputStream getInputStream() {
        return this.getInputStream(0L, -1L);
    }

    public InputStream getInputStream(long start, long len) {
        if (this.fsos != null && !this.fsos.bytesWritten()) {
            if (start > Integer.MAX_VALUE) {
                throw new AssertionError((Object)("Invalid start " + start));
            }
            int s = (int)start;
            int intLen = this.fsos.getCount() - s;
            if (len >= 0L) {
                intLen = (int)Math.min(len, len);
            }
            return new ByteArrayInputStream(this.fsos.getBuffer(), s, intLen);
        }
        return this.lobBuffer.createInputStream(start, len);
    }

    public byte[] getMemoryBytes() {
        if (this.fsos != null && !this.fsos.bytesWritten() && this.fsos.getBuffer().length == this.fsos.getCount()) {
            return this.fsos.getBuffer();
        }
        throw new IllegalStateException("In persistent mode or not closed for writing");
    }

    public Reader getCharacterStream() throws IOException {
        return new InputStreamReader(this.getInputStream(), Charset.forName(this.encoding).newDecoder());
    }

    public long getLength() {
        if (this.fsos != null && !this.fsos.bytesWritten()) {
            return this.fsos.getCount();
        }
        return this.lobBuffer.getLength();
    }

    public Writer getWriter() {
        if (this.writer == null) {
            this.writer = new OutputStreamWriter((OutputStream)this.getOuputStream(), Charset.forName(this.encoding));
        }
        return this.writer;
    }

    public FileStore.FileStoreOutputStream getOuputStream() {
        return this.getOuputStream(DataTypeManager.MAX_LOB_MEMORY_BYTES);
    }

    public FileStore.FileStoreOutputStream getOuputStream(int maxMemorySize) {
        if (this.fsos == null) {
            this.fsos = this.lobBuffer.createOutputStream(maxMemorySize);
        }
        return this.fsos;
    }

    public void free() {
        this.fsos = null;
        this.lobBuffer.remove();
        AutoCleanupUtil.removeCleanupReference(this.cleanup);
        this.cleanup = null;
    }

    public InputStreamFactory.StorageMode getStorageMode() {
        if (this.fsos == null || this.fsos.bytesWritten()) {
            return InputStreamFactory.StorageMode.PERSISTENT;
        }
        return InputStreamFactory.StorageMode.MEMORY;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setTemporary(boolean b) {
        this.temporary = b;
    }
}

