/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.util;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtractAdapter;
import io.opentracing.tag.Tags;
import java.util.Map;
import org.teiid.jdbc.tracing.GlobalTracerInjector;
import org.teiid.json.simple.ContentHandler;
import org.teiid.json.simple.JSONParser;
import org.teiid.json.simple.ParseException;
import org.teiid.json.simple.SimpleContentHandler;
import org.teiid.logging.CommandLogMessage;
import org.teiid.logging.LogManager;
import org.teiid.query.util.Options;

public class TeiidTracingUtil {
    private Tracer tracer;
    private static TeiidTracingUtil INSTANCE = new TeiidTracingUtil();

    public static TeiidTracingUtil getInstance() {
        return INSTANCE;
    }

    void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public Span buildSpan(Options options, CommandLogMessage msg, String spanContextJson) {
        if (!this.isTracingEnabled(options, spanContextJson)) {
            return null;
        }
        Tracer.SpanBuilder spanBuilder = this.getTracer().buildSpan("USER COMMAND").withTag(Tags.SPAN_KIND.getKey(), "server");
        if (spanContextJson != null) {
            SpanContext parent = this.extractSpanContext(spanContextJson);
            if (parent != null) {
                spanBuilder.asChildOf(parent);
            } else if (options.isTracingWithActiveSpanOnly()) {
                return null;
            }
        }
        Span span = spanBuilder.start();
        Tags.COMPONENT.set(span, "java-teiid");
        Tags.DB_STATEMENT.set(span, msg.getSql());
        Tags.DB_TYPE.set(span, "teiid");
        Tags.DB_INSTANCE.set(span, msg.getVdbName());
        Tags.DB_USER.set(span, msg.getPrincipal());
        span.setTag("teiid-session", msg.getSessionID());
        span.setTag("teiid-request", msg.getRequestID());
        return span;
    }

    public boolean isTracingEnabled(Options options, String spanContextJson) {
        boolean withActiveSpanOnly = options == null ? true : options.isTracingWithActiveSpanOnly();
        return !withActiveSpanOnly || this.getTracer().activeSpan() != null || spanContextJson != null;
    }

    public Span buildSourceSpan(CommandLogMessage msg, String translatorType) {
        Tracer tr = this.getTracer();
        if (tr.activeSpan() == null) {
            return null;
        }
        Tracer.SpanBuilder spanBuilder = tr.buildSpan("SRC COMMAND").withTag(Tags.SPAN_KIND.getKey(), "client");
        Span span = spanBuilder.start();
        Tags.COMPONENT.set(span, "java-teiid-connector");
        Tags.DB_STATEMENT.set(span, msg.getSql());
        Tags.DB_TYPE.set(span, translatorType);
        Tags.DB_USER.set(span, msg.getPrincipal());
        span.setTag("teiid-source-request", (Number)msg.getSourceCommandID());
        return span;
    }

    public Scope activateSpan(Span span) {
        Tracer tr = this.getTracer();
        if (tr.activeSpan() == span) {
            return null;
        }
        return tr.scopeManager().activate(span, false);
    }

    private Tracer getTracer() {
        if (this.tracer != null) {
            return this.tracer;
        }
        return GlobalTracerInjector.getTracer();
    }

    protected SpanContext extractSpanContext(String spanContextJson) {
        try {
            JSONParser parser = new JSONParser();
            SimpleContentHandler sch = new SimpleContentHandler();
            parser.parse(spanContextJson, (ContentHandler)sch);
            Map result = (Map)sch.getResult();
            return this.getTracer().extract(Format.Builtin.TEXT_MAP, (Object)new TextMapExtractAdapter(result));
        }
        catch (ClassCastException | IllegalArgumentException | ParseException e) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)e, (Object)"Could not extract the span context");
            return null;
        }
    }
}

