/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.tempdata;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.Assertion;
import org.teiid.logging.LogManager;
import org.teiid.query.util.CommandContext;

final class AsyncTupleSource
implements TupleSource {
    private TupleSource result;
    private Future<TupleSource> future;
    private Callable<TupleSource> callable;

    public AsyncTupleSource(Callable<TupleSource> callable, CommandContext context) {
        this.callable = callable;
        this.future = context.submit(callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<?> nextTuple() throws TeiidComponentException, TeiidProcessingException {
        if (this.future != null) {
            if (!this.future.isDone()) {
                throw BlockedException.block("waiting for AsyncTupleSource results");
            }
            this.result = this.clearFuture();
        }
        Assertion.isNotNull((Object)this.result);
        Callable<TupleSource> callable = this.callable;
        synchronized (callable) {
            return this.result.nextTuple();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSource() {
        try {
            this.clearFuture();
        }
        catch (TeiidComponentException | TeiidProcessingException e) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)e, (Object)"Exeception durring close");
        }
        finally {
            AsyncTupleSource asyncTupleSource = this;
            synchronized (asyncTupleSource) {
                this.result.closeSource();
            }
        }
    }

    private TupleSource clearFuture() throws TeiidComponentException, TeiidProcessingException {
        if (this.future == null) {
            return null;
        }
        try {
            TupleSource tupleSource = this.future.get();
            return tupleSource;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof BlockedException) {
                throw new AssertionError("Blocking not expected", e);
            }
            if (e.getCause() instanceof TeiidComponentException) {
                throw (TeiidComponentException)e.getCause();
            }
            if (e.getCause() instanceof TeiidProcessingException) {
                throw (TeiidProcessingException)e.getCause();
            }
            if (e.getCause() instanceof TeiidRuntimeException) {
                throw (TeiidRuntimeException)e.getCause();
            }
            throw new TeiidRuntimeException((Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new TeiidRuntimeException((Throwable)e);
        }
        finally {
            this.future = null;
        }
    }
}

