/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;

public class ExplainCommand
extends Command {
    private Format format;
    private Boolean analyze;
    private Command command;

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int getType() {
        return 17;
    }

    @Override
    public ExplainCommand clone() {
        ExplainCommand clone = new ExplainCommand();
        clone.setFormat(this.format);
        clone.setAnalyze(this.analyze);
        if (this.command != null) {
            clone.setCommand((Command)this.command.clone());
        }
        return clone;
    }

    @Override
    public List<Expression> getProjectedSymbols() {
        Class type = DataTypeManager.DefaultDataClasses.CLOB;
        if (this.format == Format.XML) {
            type = DataTypeManager.DefaultDataClasses.XML;
        }
        ElementSymbol symbol = new ElementSymbol("QUERY PLAN");
        symbol.setMetadataID(new TempMetadataID("QUERY PLAN", type));
        symbol.setType(type);
        return Arrays.asList(symbol);
    }

    @Override
    public boolean areResultsCachable() {
        return false;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public boolean isNoExec() {
        return this.analyze == null || this.analyze == false;
    }

    public Boolean getAnalyze() {
        return this.analyze;
    }

    public void setAnalyze(Boolean analyze) {
        this.analyze = analyze;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.analyze, this.command, this.format});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExplainCommand other = (ExplainCommand)obj;
        return Objects.equals(this.analyze, other.analyze) && Objects.equals(this.command, other.command) && Objects.equals((Object)this.format, (Object)other.format);
    }

    @Override
    public Command getActualCommand() {
        return this.command;
    }

    @Override
    public boolean returnsResultSet() {
        return true;
    }

    public static enum Format {
        TEXT,
        XML,
        YAML;

    }
}

