/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.IndexedTupleSource;
import org.teiid.common.buffer.STree;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.Assertion;
import org.teiid.language.SortSpecification;
import org.teiid.language.WindowFrame;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.aggregate.AggregateFunction;
import org.teiid.query.function.aggregate.NthValue;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.GroupingNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.SortUtility;
import org.teiid.query.processor.relational.SubqueryAwareRelationalNode;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.WindowFrame;
import org.teiid.query.sql.symbol.WindowFunction;
import org.teiid.query.sql.symbol.WindowSpecification;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.EvaluatableVisitor;
import org.teiid.query.util.CommandContext;

public class WindowFunctionProjectNode
extends SubqueryAwareRelationalNode {
    private static final List<Integer> SINGLE_VALUE_ID = Arrays.asList(0);
    private LinkedHashMap<WindowSpecification, WindowSpecificationInfo> windows = new LinkedHashMap();
    private LinkedHashMap<Expression, Integer> expressionIndexes;
    private List<int[]> passThrough = new ArrayList<int[]>();
    private Map<Expression, Integer> elementMap;
    private Phase phase = Phase.COLLECT;
    private TupleBuffer tb;
    private TupleSource inputTs;
    private STree[] partitionMapping;
    private STree[] valueMapping;
    private IndexedTupleSource outputTs;

    public WindowFunctionProjectNode(int nodeId) {
        super(nodeId);
    }

    protected WindowFunctionProjectNode() {
    }

    @Override
    public void reset() {
        super.reset();
        this.tb = null;
        this.inputTs = null;
        this.phase = Phase.COLLECT;
        this.partitionMapping = null;
        this.valueMapping = null;
        this.outputTs = null;
    }

    @Override
    public void closeDirect() {
        if (this.tb != null) {
            this.tb.remove();
            this.tb = null;
        }
        this.removeMappings(this.partitionMapping);
        this.partitionMapping = null;
        this.removeMappings(this.valueMapping);
        this.valueMapping = null;
    }

    private void removeMappings(STree[] mappings) {
        if (mappings != null) {
            for (STree tree : mappings) {
                if (tree == null) continue;
                tree.remove();
            }
        }
    }

    @Override
    public Object clone() {
        WindowFunctionProjectNode clonedNode = new WindowFunctionProjectNode();
        this.copyTo(clonedNode);
        clonedNode.windows = this.windows;
        clonedNode.expressionIndexes = this.expressionIndexes;
        clonedNode.passThrough = this.passThrough;
        return clonedNode;
    }

    public void init() {
        this.expressionIndexes = new LinkedHashMap();
        List<? extends Expression> elements = this.getElements();
        for (int i = 0; i < elements.size(); ++i) {
            Expression ex = SymbolMap.getExpression(elements.get(i));
            if (ex instanceof WindowFunction) {
                WindowFunction wf = (WindowFunction)ex;
                WindowSpecification ws = wf.getWindowSpecification();
                if (wf.getFunction().isRowValueFunction()) {
                    Assertion.assertTrue((ws.getWindowFrame() == null ? 1 : 0) != 0);
                    ws = ws.clone();
                    WindowFrame frame = new WindowFrame(WindowFrame.FrameMode.ROWS);
                    frame.setStart(new WindowFrame.FrameBound(WindowFrame.BoundMode.PRECEDING));
                    ws.setWindowFrame(frame);
                }
                WindowSpecificationInfo wsi = this.getOrCreateWindowSpecInfo(ws);
                WindowFunctionInfo wfi = this.createWindowFunctionInfo(wf);
                wfi.outputIndex = i;
                wsi.functions.add(wfi);
                if (wf.getFunction().getAggregateFunction() != AggregateSymbol.Type.PERCENT_RANK && wf.getFunction().getAggregateFunction() != AggregateSymbol.Type.CUME_DIST && wf.getFunction().getAggregateFunction() != AggregateSymbol.Type.NTILE) continue;
                this.addPartitionCount(i, wf);
                continue;
            }
            int index = GroupingNode.getIndex(ex, this.expressionIndexes);
            this.passThrough.add(new int[]{i, index});
        }
    }

    private void addPartitionCount(int i, WindowFunction wf) {
        WindowFunction wf2 = new WindowFunction();
        wf2.setFunction(new AggregateSymbol(AggregateSymbol.Type.COUNT.name(), false, null));
        WindowSpecification clone = wf.getWindowSpecification().clone();
        clone.setOrderBy(null);
        wf2.setWindowSpecification(clone);
        WindowSpecificationInfo wsi2 = this.getOrCreateWindowSpecInfo(clone);
        WindowFunctionInfo wfi2 = this.createWindowFunctionInfo(wf2);
        wfi2.outputIndex = i;
        wfi2.primaryFunction = wf;
        wsi2.functions.add(wfi2);
    }

    private WindowFunctionInfo createWindowFunctionInfo(WindowFunction wf) {
        WindowFunctionInfo wfi = new WindowFunctionInfo();
        wfi.function = wf;
        for (Expression e : wf.getFunction().getArgs()) {
            GroupingNode.getIndex(e, this.expressionIndexes);
        }
        if (wf.getFunction().getOrderBy() != null) {
            for (OrderByItem item : wf.getFunction().getOrderBy().getOrderByItems()) {
                GroupingNode.getIndex(item.getSymbol(), this.expressionIndexes);
            }
        }
        if (wf.getFunction().getCondition() != null) {
            GroupingNode.getIndex(wf.getFunction().getCondition(), this.expressionIndexes);
        }
        return wfi;
    }

    private WindowSpecificationInfo getOrCreateWindowSpecInfo(WindowSpecification ws) {
        WindowSpecificationInfo wsi = this.windows.get(ws);
        if (wsi == null) {
            wsi = new WindowSpecificationInfo();
            this.windows.put(ws, wsi);
            if (ws.getPartition() != null) {
                for (Expression ex1 : ws.getPartition()) {
                    if (EvaluatableVisitor.willBecomeConstant(ex1)) {
                        wsi.emptyOrdering = true;
                        continue;
                    }
                    Integer index = GroupingNode.getIndex(ex1, this.expressionIndexes);
                    wsi.groupIndexes.add(index);
                    wsi.orderType.add(true);
                    wsi.nullOrderings.add(null);
                }
            }
            if (ws.getOrderBy() != null) {
                for (OrderByItem item : ws.getOrderBy().getOrderByItems()) {
                    if (EvaluatableVisitor.willBecomeConstant(SymbolMap.getExpression(item.getSymbol()))) {
                        wsi.emptyOrdering = true;
                        continue;
                    }
                    Expression ex1 = SymbolMap.getExpression(item.getSymbol());
                    Integer index = GroupingNode.getIndex(ex1, this.expressionIndexes);
                    wsi.sortIndexes.add(index);
                    wsi.orderType.add(item.isAscending());
                    wsi.nullOrderings.add(item.getNullOrdering());
                }
                wsi.windowFrame = ws.getWindowFrame();
            }
        }
        return wsi;
    }

    @Override
    protected TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.phase == Phase.COLLECT) {
            this.saveInput();
            this.phase = Phase.PROCESS;
            this.partitionMapping = new STree[this.windows.size()];
            this.valueMapping = new STree[this.windows.size()];
        }
        if (this.phase == Phase.PROCESS) {
            this.buildResults();
            this.phase = Phase.OUTPUT;
        }
        if (this.phase == Phase.OUTPUT) {
            if (this.outputTs == null) {
                this.outputTs = this.tb.createIndexedTupleSource(true);
            }
            while (this.outputTs.hasNext()) {
                List<?> tuple = this.outputTs.nextTuple();
                Integer rowId = (Integer)tuple.get(tuple.size() - 1);
                int size = this.getElements().size();
                ArrayList<Object> outputRow = new ArrayList<Object>(size);
                for (int i = 0; i < size; ++i) {
                    outputRow.add(null);
                }
                for (int[] entry : this.passThrough) {
                    outputRow.set(entry[0], tuple.get(entry[1]));
                }
                ArrayList<Map.Entry<WindowSpecification, WindowSpecificationInfo>> specs = new ArrayList<Map.Entry<WindowSpecification, WindowSpecificationInfo>>(this.windows.entrySet());
                for (int specIndex = 0; specIndex < specs.size(); ++specIndex) {
                    Map.Entry entry = (Map.Entry)specs.get(specIndex);
                    List idRow = Arrays.asList(rowId);
                    List<WindowFunctionInfo> functions = ((WindowSpecificationInfo)entry.getValue()).functions;
                    if (this.partitionMapping[specIndex] != null) {
                        idRow = this.partitionMapping[specIndex].find(idRow);
                        idRow = idRow.subList(1, 2);
                    } else {
                        idRow = SINGLE_VALUE_ID;
                    }
                    List valueRow = this.valueMapping[specIndex].find(idRow);
                    for (int i = 0; i < functions.size(); ++i) {
                        WindowFunctionInfo wfi = functions.get(i);
                        Object value = valueRow.get(i + 1);
                        AggregateSymbol.Type aggregateFunction = wfi.function.getFunction().getAggregateFunction();
                        if (aggregateFunction == AggregateSymbol.Type.LEAD || aggregateFunction == AggregateSymbol.Type.LAG) {
                            Object[] newArgs;
                            List<Integer> newIdRow;
                            List newValueRow;
                            ArrayImpl array = (ArrayImpl)value;
                            Object[] args = array.getValues();
                            int offset = 1;
                            Object defaultValue = null;
                            if (args.length > 2) {
                                offset = (Integer)args[1];
                                if (args.length > 3) {
                                    defaultValue = args[2];
                                }
                            }
                            value = (newValueRow = this.valueMapping[specIndex].find(newIdRow = Arrays.asList((Integer)idRow.get(0) + (aggregateFunction == AggregateSymbol.Type.LAG ? -offset : offset)))) == null ? defaultValue : (args[args.length - 1].equals((newArgs = ((ArrayImpl)newValueRow.get(i + 1)).getValues())[newArgs.length - 1]) ? newArgs[0] : defaultValue);
                        } else if (wfi.primaryFunction != null) {
                            switch (wfi.primaryFunction.getFunction().getAggregateFunction()) {
                                case NTILE: {
                                    ArrayImpl array = (ArrayImpl)outputRow.get(wfi.outputIndex);
                                    Object[] args = array.getValues();
                                    int rn = (Integer)args[0];
                                    int ntile = (Integer)args[1];
                                    int rc = (Integer)value;
                                    int rowsPerTile = rc / ntile;
                                    if (rn <= rc % ntile * (rowsPerTile + 1)) {
                                        value = (rn - 1) / (rowsPerTile + 1) + 1;
                                        break;
                                    }
                                    value = ntile - (rc - rn) / rowsPerTile;
                                    break;
                                }
                                case PERCENT_RANK: {
                                    int rn = (Integer)outputRow.get(wfi.outputIndex);
                                    int rc = (Integer)value;
                                    value = ((double)rn - 1.0) / (double)(rc - 1);
                                    break;
                                }
                                case CUME_DIST: {
                                    int np = (Integer)outputRow.get(wfi.outputIndex);
                                    int rc = (Integer)value;
                                    value = (double)np / (double)rc;
                                    break;
                                }
                            }
                        }
                        outputRow.set(wfi.outputIndex, value);
                    }
                }
                this.addBatchRow(outputRow);
                if (!this.isBatchFull()) continue;
                return this.pullBatch();
            }
            this.terminateBatches();
        }
        return this.pullBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildResults() throws TeiidComponentException, TeiidProcessingException, FunctionExecutionException, ExpressionEvaluationException {
        ArrayList<Map.Entry<WindowSpecification, WindowSpecificationInfo>> specs = new ArrayList<Map.Entry<WindowSpecification, WindowSpecificationInfo>>(this.windows.entrySet());
        for (int specIndex = 0; specIndex < specs.size(); ++specIndex) {
            Map.Entry entry = (Map.Entry)specs.get(specIndex);
            WindowSpecificationInfo info = (WindowSpecificationInfo)entry.getValue();
            TupleBuffer.TupleBufferTupleSource specificationTs = this.tb.createIndexedTupleSource();
            boolean multiGroup = false;
            int[] partitionIndexes = null;
            int[] orderIndexes = null;
            TupleBuffer sorted = null;
            if (!info.orderType.isEmpty() || info.emptyOrdering) {
                multiGroup = true;
                int[] sortKeys = new int[info.orderType.size()];
                int i = 0;
                if (!info.groupIndexes.isEmpty()) {
                    for (Integer sortIndex : info.groupIndexes) {
                        sortKeys[i++] = sortIndex;
                    }
                    partitionIndexes = Arrays.copyOf(sortKeys, info.groupIndexes.size());
                }
                if (!info.sortIndexes.isEmpty()) {
                    for (Integer sortIndex : info.sortIndexes) {
                        sortKeys[i++] = sortIndex;
                    }
                    orderIndexes = Arrays.copyOfRange(sortKeys, info.groupIndexes.size(), info.groupIndexes.size() + info.sortIndexes.size());
                }
                if (!info.functions.isEmpty()) {
                    ElementSymbol key = new ElementSymbol("rowId");
                    key.setType(DataTypeManager.DefaultDataClasses.INTEGER);
                    ElementSymbol value = new ElementSymbol("partitionId");
                    value.setType(DataTypeManager.DefaultDataClasses.INTEGER);
                    List<ElementSymbol> elements = Arrays.asList(key, value);
                    this.partitionMapping[specIndex] = this.getBufferManager().createSTree(elements, this.getConnectionID(), 1);
                }
                if (!info.orderType.isEmpty()) {
                    SortUtility su = new SortUtility(null, SortUtility.Mode.SORT, this.getBufferManager(), this.getConnectionID(), this.tb.getSchema(), info.orderType, info.nullOrderings, sortKeys);
                    su.setWorkingBuffer(this.tb);
                    su.setNonBlocking(true);
                    boolean success = false;
                    try {
                        sorted = su.sort();
                        success = true;
                    }
                    finally {
                        if (!success) {
                            su.remove();
                        }
                    }
                    specificationTs = sorted.createIndexedTupleSource(!info.processEachFrame());
                }
            }
            try {
                List<AggregateFunction> aggs = this.initializeAccumulators(info.functions, specIndex);
                if (info.processEachFrame()) {
                    this.processEachFrame(specIndex, info, specificationTs, partitionIndexes, orderIndexes, sorted, aggs);
                    return;
                }
                int groupId = 0;
                List<?> lastRow = null;
                while (specificationTs.hasNext()) {
                    List<?> tuple = specificationTs.nextTuple();
                    if (multiGroup) {
                        if (lastRow != null) {
                            boolean samePartition;
                            boolean bl = samePartition = GroupingNode.sameGroup(partitionIndexes, tuple, lastRow) == -1;
                            if (!samePartition || !info.isUnboundedFollowing() && (info.windowFrame != null && info.windowFrame.getMode() == WindowFrame.FrameMode.ROWS || GroupingNode.sameGroup(orderIndexes, tuple, lastRow) != -1)) {
                                this.saveValues(specIndex, aggs, groupId, samePartition);
                                ++groupId;
                            }
                        }
                        List<Object> partitionTuple = Arrays.asList(tuple.get(tuple.size() - 1), groupId);
                        this.partitionMapping[specIndex].insert(partitionTuple, STree.InsertMode.NEW, -1);
                    }
                    for (AggregateFunction function : aggs) {
                        function.addInput(tuple, this.getContext());
                    }
                    lastRow = tuple;
                }
                if (lastRow == null) continue;
                this.saveValues(specIndex, aggs, groupId, true);
                continue;
            }
            finally {
                if (sorted != null) {
                    sorted.remove();
                }
            }
        }
    }

    private void processEachFrame(int specIndex, WindowSpecificationInfo info, IndexedTupleSource specificationTs, int[] partitionIndexes, int[] orderIndexes, TupleBuffer sorted, List<AggregateFunction> aggs) throws TeiidComponentException, TeiidProcessingException {
        Integer frameStartOffset = info.getWindowStartOffset();
        Integer frameEndOffset = info.getWindowEndOffset();
        int groupId = 0;
        List<?> lastRow = null;
        Long startPartition = null;
        Long endPartition = null;
        while (specificationTs.hasNext()) {
            long i;
            long currentIndex = specificationTs.getCurrentIndex();
            List<?> tuple = specificationTs.nextTuple();
            boolean peer = false;
            if (lastRow != null) {
                if (endPartition != null && currentIndex > endPartition) {
                    startPartition = null;
                    endPartition = null;
                    lastRow = null;
                    ++groupId;
                } else if (info.windowFrame.getMode() == WindowFrame.FrameMode.ROWS || GroupingNode.sameGroup(orderIndexes, tuple, lastRow) != -1) {
                    ++groupId;
                } else {
                    peer = true;
                }
            }
            lastRow = tuple;
            List<Object> partitionTuple = Arrays.asList(tuple.get(tuple.size() - 1), groupId);
            this.partitionMapping[specIndex].insert(partitionTuple, STree.InsertMode.NEW, -1);
            if (peer) continue;
            if (startPartition == null) {
                startPartition = currentIndex;
                if (!info.groupIndexes.isEmpty()) {
                    long l = startPartition;
                    long r = sorted.getRowCount() + 1L;
                    while (l < r) {
                        long m = (l + r) / 2L;
                        if (m == startPartition) {
                            l = m + 1L;
                            break;
                        }
                        List<?> possibleEnd = sorted.getBatch(m).getTuple(m);
                        if (GroupingNode.sameGroup(partitionIndexes, tuple, possibleEnd) == -1) {
                            l = m + 1L;
                            continue;
                        }
                        r = m;
                    }
                    endPartition = l - 1L;
                } else {
                    endPartition = sorted.getRowCount();
                }
            }
            long start = startPartition;
            if (frameStartOffset != null) {
                start = Math.max(currentIndex + (long)frameStartOffset.intValue(), startPartition);
            }
            long end = endPartition;
            if (frameEndOffset != null) {
                end = currentIndex + (long)frameEndOffset.intValue();
                if (info.windowFrame.getMode() == WindowFrame.FrameMode.RANGE) {
                    List<?> possiblePeer;
                    Assertion.assertTrue((frameEndOffset == 0 ? 1 : 0) != 0);
                    for (i = end + 1L; i <= endPartition && GroupingNode.sameGroup(orderIndexes, tuple, possiblePeer = sorted.getBatch(i).getTuple(i)) == -1; ++i) {
                        List<Object> peerPartitionTuple = Arrays.asList(possiblePeer.get(possiblePeer.size() - 1), groupId);
                        this.partitionMapping[specIndex].insert(peerPartitionTuple, STree.InsertMode.NEW, -1);
                        specificationTs.nextTuple();
                        ++end;
                    }
                }
                end = Math.min(end, endPartition);
            }
            for (i = start; i <= end; ++i) {
                List<?> frameTuple = sorted.getBatch(i).getTuple(i);
                for (AggregateFunction function : aggs) {
                    if (function instanceof NthValue) {
                        ((NthValue)function).addInput(frameTuple, this.getContext(), start, end, sorted);
                        continue;
                    }
                    function.addInput(frameTuple, this.getContext());
                }
            }
            this.saveValues(specIndex, aggs, groupId, false);
        }
    }

    private void saveValues(int specIndex, List<AggregateFunction> aggs, Object id, boolean samePartition) throws FunctionExecutionException, ExpressionEvaluationException, TeiidComponentException, TeiidProcessingException {
        if (aggs.isEmpty()) {
            return;
        }
        ArrayList<Object> row = new ArrayList<Object>(aggs.size() + 1);
        row.add(id);
        for (AggregateFunction function : aggs) {
            row.add(function.getResult(this.getContext()));
            if (samePartition) continue;
            function.reset();
        }
        this.valueMapping[specIndex].insert(row, STree.InsertMode.ORDERED, -1);
    }

    private List<AggregateFunction> initializeAccumulators(List<WindowFunctionInfo> functions, int specIndex) {
        ArrayList<AggregateFunction> aggs = new ArrayList<AggregateFunction>(functions.size());
        if (functions.isEmpty()) {
            return aggs;
        }
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>(functions.size());
        ElementSymbol key = new ElementSymbol("key");
        key.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        elements.add(key);
        for (WindowFunctionInfo wfi : functions) {
            AggregateFunction aggregateFunction = GroupingNode.initAccumulator(wfi.function.getFunction(), this, this.expressionIndexes);
            aggs.add(aggregateFunction);
            Class<?> outputType = aggregateFunction.getOutputType(wfi.function.getFunction());
            ElementSymbol value = new ElementSymbol("val");
            value.setType(outputType);
            elements.add(value);
        }
        this.valueMapping[specIndex] = this.getBufferManager().createSTree(elements, this.getConnectionID(), 1);
        return aggs;
    }

    private void saveInput() throws TeiidComponentException, TeiidProcessingException {
        if (this.inputTs == null) {
            ArrayList<Expression> collectedExpressions = new ArrayList<Expression>(this.expressionIndexes.keySet());
            Evaluator eval = new Evaluator(this.elementMap, this.getDataManager(), this.getContext());
            RelationalNode sourceNode = this.getChildren()[0];
            this.inputTs = new GroupingNode.ProjectingTupleSource(sourceNode, eval, collectedExpressions, this.elementMap){
                int index;
                {
                    this.index = 0;
                }

                @Override
                public List<Object> nextTuple() throws TeiidComponentException, TeiidProcessingException {
                    List<Object> tuple = super.nextTuple();
                    if (tuple != null) {
                        tuple.add(this.index++);
                    }
                    return tuple;
                }
            };
            ArrayList<ElementSymbol> schema = new ArrayList<ElementSymbol>(collectedExpressions.size() + 1);
            int index = 0;
            for (Expression ex : collectedExpressions) {
                ElementSymbol es = new ElementSymbol(String.valueOf(index++));
                es.setType(ex.getType());
                schema.add(es);
            }
            ElementSymbol es = new ElementSymbol(String.valueOf(index++));
            es.setType(DataTypeManager.DefaultDataClasses.INTEGER);
            schema.add(es);
            this.tb = this.getBufferManager().createTupleBuffer(schema, this.getConnectionID(), BufferManager.TupleSourceType.PROCESSOR);
        }
        List<?> tuple = null;
        while ((tuple = this.inputTs.nextTuple()) != null) {
            this.tb.addTuple(tuple);
        }
        this.tb.close();
        this.inputTs.closeSource();
        this.inputTs = null;
    }

    @Override
    public void initialize(CommandContext context, BufferManager bufferManager, ProcessorDataManager dataMgr) {
        super.initialize(context, bufferManager, dataMgr);
        if (this.elementMap == null) {
            List<? extends Expression> sourceElements = this.getChildren()[0].getElements();
            this.elementMap = WindowFunctionProjectNode.createLookupMap(sourceElements);
        }
    }

    @Override
    public Collection<? extends LanguageObject> getObjects() {
        return this.getElements();
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        AnalysisRecord.addLanaguageObjects(props, "Window Functions", this.windows.keySet());
        return props;
    }

    private static class WindowSpecificationInfo {
        List<Integer> groupIndexes = new ArrayList<Integer>();
        List<Integer> sortIndexes = new ArrayList<Integer>();
        List<SortSpecification.NullOrdering> nullOrderings = new ArrayList<SortSpecification.NullOrdering>();
        List<Boolean> orderType = new ArrayList<Boolean>();
        List<WindowFunctionInfo> functions = new ArrayList<WindowFunctionInfo>();
        WindowFrame windowFrame;
        boolean emptyOrdering = false;

        private WindowSpecificationInfo() {
        }

        boolean isUnboundedFollowing() {
            return this.windowFrame != null && this.windowFrame.getEnd() != null && this.windowFrame.getEnd().getBound() == null && this.windowFrame.getEnd().getBoundMode() == WindowFrame.BoundMode.FOLLOWING;
        }

        Integer getWindowStartOffset() {
            if (this.windowFrame.getStart().getBoundMode() == WindowFrame.BoundMode.CURRENT_ROW) {
                return 0;
            }
            if (this.windowFrame.getStart().getBound() == null) {
                return null;
            }
            return (this.windowFrame.getStart().getBoundMode() == WindowFrame.BoundMode.PRECEDING ? -1 : 1) * this.windowFrame.getStart().getBound();
        }

        Integer getWindowEndOffset() {
            if (this.windowFrame.getEnd() == null || this.windowFrame.getEnd().getBoundMode() == WindowFrame.BoundMode.CURRENT_ROW) {
                return 0;
            }
            if (this.windowFrame.getEnd().getBound() == null) {
                return null;
            }
            return (this.windowFrame.getEnd().getBoundMode() == WindowFrame.BoundMode.PRECEDING ? -1 : 1) * this.windowFrame.getEnd().getBound();
        }

        boolean processEachFrame() {
            for (WindowFunctionInfo info : this.functions) {
                switch (info.function.getFunction().getAggregateFunction()) {
                    case XMLAGG: 
                    case STRING_AGG: 
                    case JSONARRAY_AGG: 
                    case TEXTAGG: 
                    case NTH_VALUE: {
                        if (this.windowFrame == null) {
                            this.windowFrame = new WindowFrame(WindowFrame.FrameMode.RANGE);
                            this.windowFrame.setStart(new WindowFrame.FrameBound(WindowFrame.BoundMode.PRECEDING));
                        }
                        return true;
                    }
                }
            }
            return this.windowFrame != null && (this.windowFrame.getStart().getBound() != null || this.windowFrame.getStart().getBoundMode() == WindowFrame.BoundMode.CURRENT_ROW || this.windowFrame.getEnd() != null && this.windowFrame.getEnd().getBound() != null);
        }
    }

    private static class WindowFunctionInfo {
        WindowFunction function;
        int outputIndex;
        public WindowFunction primaryFunction;

        private WindowFunctionInfo() {
        }
    }

    private static enum Phase {
        COLLECT,
        PROCESS,
        OUTPUT;

    }
}

