/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.core.BundleUtil;
import org.teiid.language.SQLConstants;
import org.teiid.metadata.DataWrapper;
import org.teiid.metadata.Database;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.MetadataException;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Parser;
import org.teiid.metadata.Server;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.DatabaseStore;
import org.teiid.query.metadata.DatabaseUtil;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.JavaCharStream;
import org.teiid.query.parser.ParseException;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.parser.SQLParser;
import org.teiid.query.parser.SQLParserUtil;
import org.teiid.query.parser.TeiidSQLParserTokenManager;
import org.teiid.query.parser.Token;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.proc.TriggerAction;
import org.teiid.query.sql.symbol.Expression;

public class QueryParser
implements Parser {
    private static ThreadLocal<QueryParser> QUERY_PARSER = new ThreadLocal<QueryParser>(){

        @Override
        protected QueryParser initialValue() {
            return new QueryParser();
        }
    };
    private static final String XQUERY_DECLARE = "declare";
    private static final String XML_OPEN_BRACKET = "<";
    private static final String NONE = "none";
    private SQLParser parser;
    private TeiidSQLParserTokenManager tm;

    public static QueryParser getQueryParser() {
        return QUERY_PARSER.get();
    }

    private SQLParser getSqlParser(String sql) {
        return this.getSqlParser(new StringReader(sql));
    }

    private SQLParser getSqlParser(Reader sql) {
        if (this.parser == null) {
            JavaCharStream jcs = new JavaCharStream(sql);
            this.tm = new TeiidSQLParserTokenManager(new JavaCharStream(sql));
            this.parser = new SQLParser(this.tm);
            this.parser.jj_input_stream = jcs;
        } else {
            this.parser.ReInit(sql);
            this.tm.reinit();
        }
        return this.parser;
    }

    public Command parseCommand(String sql) throws QueryParserException {
        return this.parseCommand(sql, new ParseInfo());
    }

    public Command parseProcedure(String sql, boolean update) throws QueryParserException {
        try {
            if (update) {
                TriggerAction triggerAction = this.getSqlParser(sql).forEachRowTriggerAction(new ParseInfo());
                return triggerAction;
            }
            CreateProcedureCommand result = this.getSqlParser(sql).procedureBodyCommand(new ParseInfo());
            result.setCacheHint(SQLParserUtil.getQueryCacheOption(sql));
            CreateProcedureCommand createProcedureCommand = result;
            return createProcedureCommand;
        }
        catch (ParseException pe) {
            throw this.convertParserException(pe);
        }
        finally {
            this.tm.reinit();
        }
    }

    public Command parseCommand(String sql, ParseInfo parseInfo) throws QueryParserException {
        if (sql == null || sql.length() == 0) {
            throw new QueryParserException((BundleUtil.Event)QueryPlugin.Event.TEIID30377, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30377, new Object[0]));
        }
        Command result = null;
        try {
            result = this.getSqlParser(sql).command(parseInfo);
            result.setCacheHint(SQLParserUtil.getQueryCacheOption(sql));
        }
        catch (ParseException pe) {
            if (sql.startsWith(XML_OPEN_BRACKET) || sql.startsWith(XQUERY_DECLARE)) {
                throw new QueryParserException(QueryPlugin.Event.TEIID30378, (Throwable)((Object)this.convertParserException(pe)), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30378, new Object[]{sql}));
            }
            throw this.convertParserException(pe);
        }
        finally {
            this.tm.reinit();
        }
        return result;
    }

    public CacheHint parseCacheHint(String sql) {
        if (sql == null || sql.length() == 0) {
            return null;
        }
        return SQLParserUtil.getQueryCacheOption(sql);
    }

    public Criteria parseCriteria(String sql) throws QueryParserException {
        if (sql == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("QueryParser.nullSqlCrit"));
        }
        ParseInfo dummyInfo = new ParseInfo();
        Criteria result = null;
        try {
            result = this.getSqlParser(sql).criteria(dummyInfo);
        }
        catch (ParseException pe) {
            throw this.convertParserException(pe);
        }
        finally {
            this.tm.reinit();
        }
        return result;
    }

    private QueryParserException convertParserException(ParseException pe) {
        if (pe.currentToken == null) {
            List<Token> preceeding = this.findPreceeding(this.parser.token, 1);
            pe.currentToken = !preceeding.isEmpty() ? preceeding.get(0) : this.parser.token;
        }
        QueryParserException qpe = new QueryParserException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31100, new Object[]{this.getMessage(pe, 10)}));
        qpe.setParseException(pe);
        return qpe;
    }

    public String getMessage(ParseException pe, int maxExpansions) {
        if (pe.expectedTokenSequences == null) {
            if (pe.currentToken == null) {
                return pe.getMessage();
            }
            StringBuilder sb = this.encountered(pe, pe.currentToken.next != null ? 1 : 0);
            if (pe.currentToken.kind == -1) {
                sb.append(QueryPlugin.Util.getString("QueryParser.lexicalError", new Object[]{pe.currentToken.image}));
            } else if (pe.currentToken.next != null && pe.currentToken.next.kind == -1) {
                sb.append(QueryPlugin.Util.getString("QueryParser.lexicalError", new Object[]{pe.currentToken.next.image}));
            }
            if (pe.getMessage() != null) {
                sb.append(pe.getMessage());
            }
            return sb.toString();
        }
        Token currentToken = pe.currentToken;
        if (currentToken.next.kind == -1) {
            StringBuilder retval = this.encountered(pe, 1);
            retval.append(QueryPlugin.Util.getString("QueryParser.lexicalError", new Object[]{currentToken.next.image}));
            return retval.toString();
        }
        int[][] expectedTokenSequences = pe.expectedTokenSequences;
        int[] ex = null;
        TreeSet<Integer> last = new TreeSet<Integer>();
        block0: for (int i = 0; i < expectedTokenSequences.length; ++i) {
            if (ex == null || expectedTokenSequences[i].length > ex.length) {
                ex = expectedTokenSequences[i];
                last.clear();
            } else {
                if (expectedTokenSequences[i].length < ex.length) continue;
                for (int j = 0; j < ex.length - 1; ++j) {
                    if (ex[j] != expectedTokenSequences[i][j]) continue block0;
                }
            }
            last.add(expectedTokenSequences[i][expectedTokenSequences[i].length - 1]);
        }
        if (ex == null) {
            return pe.getMessage();
        }
        StringBuilder retval = this.encountered(pe, ex.length);
        retval.append("Was expecting: ");
        boolean id = last.contains(417);
        int count = 0;
        for (Integer t : last) {
            String img = TeiidSQLParserTokenManager.tokenImage[t];
            if (id && img.startsWith("\"") && Character.isLetter(img.charAt(1)) && (!SQLConstants.isReservedWord((String)img.substring(1, img.length() - 1)) || img.equals("\"default\""))) continue;
            if (count > 0) {
                retval.append(" | ");
            }
            ++count;
            if (t == 417) {
                retval.append("id");
            } else {
                retval.append(img);
            }
            if (count != maxExpansions) continue;
            retval.append(" ...");
            break;
        }
        return retval.toString();
    }

    private StringBuilder encountered(ParseException pe, int offset) {
        StringBuilder retval = new StringBuilder("Encountered \"");
        Token currentToken = pe.currentToken;
        for (int i = 1; i < offset; ++i) {
            currentToken = currentToken.next;
        }
        List<Token> preceeding = this.findPreceeding(currentToken, 2);
        if (offset > 0 && !preceeding.isEmpty()) {
            this.addTokenSequence(preceeding.size() + 1, retval, null, preceeding.get(0), false);
        } else {
            this.addTokenSequence(1, retval, null, currentToken, offset == 0);
        }
        if (currentToken.next != null && offset > 0) {
            this.addTokenSequence(3, retval, currentToken, currentToken.next, true);
            currentToken = currentToken.next;
        }
        retval.append("\" at line ").append(currentToken.beginLine).append(", column ").append(currentToken.beginColumn);
        retval.append(".\n");
        return retval;
    }

    private List<Token> findPreceeding(Token currentToken, int count) {
        LinkedList<Token> preceeding = new LinkedList<Token>();
        Token tok = this.tm.head;
        boolean found = false;
        while (tok != null) {
            if (tok == currentToken) {
                found = true;
                break;
            }
            preceeding.add(tok);
            if (preceeding.size() > count) {
                preceeding.removeFirst();
            }
            tok = tok.next;
        }
        if (!found) {
            preceeding.clear();
        }
        return preceeding;
    }

    private Token addTokenSequence(int maxSize, StringBuilder retval, Token last, Token tok, boolean highlight) {
        for (int i = 0; i < maxSize && tok != null; ++i) {
            if (last != null && last.endColumn + 1 != tok.beginColumn && tok.kind != 0) {
                retval.append(" ");
            }
            last = tok;
            if (i == 0 && highlight) {
                retval.append("[*]");
            }
            if (tok.image != null && !tok.image.isEmpty()) {
                this.add_escapes(tok.image, retval);
                if (i == 0 && highlight) {
                    retval.append("[*]");
                }
            }
            while (tok.next == null && this.parser.getNextToken() != null) {
            }
            tok = tok.next;
        }
        return last;
    }

    protected void add_escapes(String str, StringBuilder retval) {
        block10: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\u0000': {
                    continue block10;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block10;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block10;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block10;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block10;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block10;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block10;
                }
                default: {
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block10;
                    }
                    retval.append(ch);
                    continue block10;
                }
            }
        }
    }

    public Expression parseExpression(String sql) throws QueryParserException {
        if (sql == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("QueryParser.nullSqlExpr"));
        }
        ParseInfo dummyInfo = new ParseInfo();
        Expression result = null;
        try {
            result = this.getSqlParser(sql).expression(dummyInfo);
        }
        catch (ParseException pe) {
            throw this.convertParserException(pe);
        }
        finally {
            this.tm.reinit();
        }
        return result;
    }

    public Expression parseSelectExpression(String sql) throws QueryParserException {
        if (sql == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("QueryParser.nullSqlExpr"));
        }
        ParseInfo dummyInfo = new ParseInfo();
        Expression result = null;
        try {
            result = this.getSqlParser(sql).selectExpression(dummyInfo);
        }
        catch (ParseException pe) {
            throw this.convertParserException(pe);
        }
        finally {
            this.tm.reinit();
        }
        return result;
    }

    public void parseDDL(MetadataFactory factory, String ddl) {
        this.parseDDL(factory, (Reader)new StringReader(ddl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseDDL(MetadataFactory factory, Reader ddl) {
        SingleSchemaDatabaseStore store = new SingleSchemaDatabaseStore(factory);
        store.startEditing(true);
        Database db = new Database(factory.getVdbName(), factory.getVdbVersion());
        store.databaseCreated(db);
        store.databaseSwitched(factory.getVdbName(), factory.getVdbVersion());
        store.dataWrapperCreated(new DataWrapper(NONE));
        Server server = new Server(NONE);
        server.setDataWrapper(NONE);
        store.serverCreated(server);
        if (factory.getSchema().isPhysical()) {
            Server s = new Server(factory.getSchema().getName());
            s.setDataWrapper(NONE);
            store.serverCreated(s);
        }
        List<String> servers = Collections.emptyList();
        store.schemaCreated(factory.getSchema(), servers);
        CompositeMetadataStore cms = new CompositeMetadataStore(db.getMetadataStore());
        TransformationMetadata qmi = new TransformationMetadata(DatabaseUtil.convert(db), cms, null, null, null);
        store.setTransformationMetadata(qmi.getDesignTimeMetadata());
        store.schemaSwitched(factory.getSchema().getName());
        store.setMode(DatabaseStore.Mode.SCHEMA);
        store.setStrict(true);
        try {
            this.parseDDL(store, ddl);
        }
        finally {
            store.stopEditing();
        }
    }

    public void parseDDL(DatabaseStore repository, Reader ddl) throws MetadataException {
        SQLParser sqlParser = this.getSqlParser(ddl);
        try {
            sqlParser.parseMetadata(repository);
        }
        catch (org.teiid.metadata.ParseException e) {
            throw e;
        }
        catch (MetadataException e) {
            Token t = sqlParser.token;
            throw new org.teiid.metadata.ParseException((BundleUtil.Event)QueryPlugin.Event.TEIID31259, (Throwable)e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31259, new Object[]{t.image, t.beginLine, t.beginColumn, e.getMessage()}));
        }
        catch (ParseException e) {
            throw new org.teiid.metadata.ParseException((BundleUtil.Event)QueryPlugin.Event.TEIID30386, (Throwable)((Object)this.convertParserException(e)));
        }
        finally {
            this.tm.reinit();
        }
    }

    private static final class SingleSchemaDatabaseStore
    extends DatabaseStore {
        private final MetadataFactory factory;
        private TransformationMetadata transformationMetadata;

        private SingleSchemaDatabaseStore(MetadataFactory factory) {
            this.factory = factory;
        }

        @Override
        public Map<String, Datatype> getRuntimeTypes() {
            return this.factory.getDataTypes();
        }

        @Override
        protected TransformationMetadata getTransformationMetadata() {
            return this.transformationMetadata;
        }

        public void setTransformationMetadata(TransformationMetadata transformationMetadata) {
            this.transformationMetadata = transformationMetadata;
        }
    }
}

