/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RelationalPlanner;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.optimizer.relational.rules.CriteriaCapabilityValidatorVisitor;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.JoinUtil;
import org.teiid.query.optimizer.relational.rules.NewCalculateCostUtil;
import org.teiid.query.optimizer.relational.rules.RuleChooseJoinStrategy;
import org.teiid.query.optimizer.relational.rules.RulePlanSubqueries;
import org.teiid.query.optimizer.relational.rules.RulePushLimit;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.optimizer.relational.rules.RuleRemoveOptionalJoins;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.relational.AccessNode;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.SourceHint;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.WithQueryCommand;
import org.teiid.query.sql.navigator.DeepPostOrderNavigator;
import org.teiid.query.sql.navigator.PreOrPostOrderNavigator;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.AggregateSymbolCollectorVisitor;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.EvaluatableVisitor;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.util.CommandContext;

public final class RuleCollapseSource
implements OptimizerRule {
    static final String PARTIAL_PROPERTY = "teiid_rel:partial_filter";

    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        for (PlanNode accessNode : NodeEditor.findAllNodes(plan, 1)) {
            ProcessorPlan nonRelationalPlan = FrameUtil.getNestedPlan(accessNode);
            Command command = FrameUtil.getNonQueryCommand(accessNode);
            Object modelId = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
            if (nonRelationalPlan != null) {
                accessNode.setProperty(NodeConstants.Info.PROCESSOR_PLAN, nonRelationalPlan);
            } else if (RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata) != null && command == null) {
                Query query;
                PlanNode commandRoot = accessNode;
                GroupSymbol intoGroup = (GroupSymbol)accessNode.getFirstChild().getProperty(NodeConstants.Info.INTO_GROUP);
                Set toCheck = (Set)commandRoot.getProperty(NodeConstants.Info.CHECK_MAT_VIEW);
                if (intoGroup != null) {
                    commandRoot = NodeEditor.findNodePreOrder(accessNode, 64).getFirstChild();
                } else {
                    plan = this.removeUnnecessaryInlineView(plan, commandRoot);
                }
                QueryCommand queryCommand = this.createQuery(context, capFinder, accessNode, commandRoot);
                if (toCheck != null) {
                    this.modifyToCheckMatViewStatus(metadata, queryCommand, toCheck);
                }
                if (queryCommand instanceof Query && CapabilitiesUtil.supports(SourceCapabilities.Capability.PARTIAL_FILTERS, modelId, metadata, capFinder) && (query = (Query)queryCommand).getCriteria() != null) {
                    ArrayList<Criteria> toFilter = new ArrayList<Criteria>();
                    LinkedHashSet<Expression> select = new LinkedHashSet<Expression>(query.getSelect().getProjectedSymbols());
                    block1: for (Criteria crit : Criteria.separateCriteriaByAnd(query.getCriteria())) {
                        for (ElementSymbol es : ElementCollectorVisitor.getElements((LanguageObject)crit, true)) {
                            if (!Boolean.valueOf(metadata.getExtensionProperty(es.getMetadataID(), PARTIAL_PROPERTY, false)).booleanValue() || !select.contains(es)) continue;
                            toFilter.add((Criteria)crit.clone());
                            continue block1;
                        }
                    }
                    if (!toFilter.isEmpty()) {
                        PlanNode postFilter = RelationalPlanner.createSelectNode(CompoundCriteria.combineCriteria(toFilter), false);
                        ElementCollectorVisitor.getElements(toFilter, select);
                        postFilter.setProperty(NodeConstants.Info.OUTPUT_COLS, new ArrayList<Expression>(query.getSelect().getProjectedSymbols()));
                        if (accessNode.getParent() != null) {
                            accessNode.addAsParent(postFilter);
                        } else {
                            plan = postFilter;
                            postFilter.addFirstChild(accessNode);
                        }
                        if (select.size() != query.getSelect().getProjectedSymbols().size()) {
                            query.getSelect().setSymbols(select);
                            accessNode.setProperty(NodeConstants.Info.OUTPUT_COLS, new ArrayList<Expression>(select));
                        }
                    }
                }
                plan = this.addDistinct(metadata, capFinder, accessNode, plan, queryCommand, capFinder);
                command = queryCommand;
                queryCommand.setSourceHint((SourceHint)accessNode.getProperty(NodeConstants.Info.SOURCE_HINT));
                queryCommand.getProjectedQuery().setSourceHint((SourceHint)accessNode.getProperty(NodeConstants.Info.SOURCE_HINT));
                if (intoGroup != null) {
                    Insert insertCommand = (Insert)commandRoot.getParent().getProperty(NodeConstants.Info.VIRTUAL_COMMAND);
                    if (insertCommand == null) {
                        insertCommand = new Insert(intoGroup, ResolverUtil.resolveElementsInGroup(intoGroup, metadata), null);
                    }
                    insertCommand.setQueryExpression(queryCommand);
                    command = insertCommand;
                }
            }
            if (command != null) {
                this.setEvalFlag(metadata, capFinder, command, modelId);
                accessNode.setProperty(NodeConstants.Info.ATOMIC_REQUEST, command);
            }
            accessNode.removeAllChildren();
        }
        return plan;
    }

    private void setEvalFlag(final QueryMetadataInterface metadata, final CapabilitiesFinder capFinder, Command command, final Object modelId) {
        LanguageVisitor lv = new LanguageVisitor(){

            @Override
            public void visit(Function f) {
                FunctionDescriptor fd = f.getFunctionDescriptor();
                if (f.isEval()) {
                    try {
                        if (modelId != null && fd.getPushdown() == FunctionMethod.PushDown.MUST_PUSHDOWN && fd.getMethod() != null && CapabilitiesUtil.isSameConnector(modelId, fd.getMethod().getParent(), metadata, capFinder)) {
                            f.setEval(false);
                        } else if (fd.getDeterministic() == FunctionMethod.Determinism.NONDETERMINISTIC && CapabilitiesUtil.supportsScalarFunction(modelId, f, metadata, capFinder)) {
                            f.setEval(false);
                        }
                    }
                    catch (QueryMetadataException e) {
                        throw new TeiidRuntimeException((Throwable)((Object)e));
                    }
                    catch (TeiidComponentException e) {
                        throw new TeiidRuntimeException((Throwable)e);
                    }
                }
            }

            @Override
            public void visit(SubqueryFromClause obj) {
                PreOrPostOrderNavigator.doVisit(obj.getCommand(), this, true);
            }

            @Override
            public void visit(WithQueryCommand obj) {
                PreOrPostOrderNavigator.doVisit(obj.getCommand(), this, true);
            }

            @Override
            public void visit(StoredProcedure obj) {
                try {
                    boolean supports = modelId != null && CapabilitiesUtil.supports(SourceCapabilities.Capability.PROCEDURE_PARAMETER_EXPRESSION, modelId, metadata, capFinder);
                    obj.setSupportsExpressionParameters(supports);
                }
                catch (TeiidComponentException e) {
                    throw new TeiidRuntimeException((Throwable)e);
                }
            }
        };
        PreOrPostOrderNavigator.doVisit(command, lv, true);
    }

    private void modifyToCheckMatViewStatus(QueryMetadataInterface metadata, QueryCommand queryCommand, Set<Object> ids) throws QueryMetadataException, TeiidComponentException {
        for (Object viewMatadataId : ids) {
            String schemaName = metadata.getName(metadata.getModelID(viewMatadataId));
            String viewName = metadata.getName(viewMatadataId);
            Constant expr1 = new Constant(schemaName);
            Constant expr2 = new Constant(viewName);
            Function status = new Function("mvstatus", new Expression[]{expr1, expr2});
            status.setType(DataTypeManager.DefaultDataClasses.INTEGER);
            FunctionDescriptor descriptor = metadata.getFunctionLibrary().findFunction("mvstatus", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.STRING});
            status.setFunctionDescriptor(descriptor);
            Query query = queryCommand.getProjectedQuery();
            query.setCriteria(Criteria.combineCriteria(new CompareCriteria(status, 1, new Constant(1)), query.getCriteria()));
        }
    }

    private PlanNode addDistinct(QueryMetadataInterface metadata, CapabilitiesFinder capFinder, PlanNode accessNode, PlanNode root, QueryCommand queryCommand, CapabilitiesFinder capabilitiesFinder) throws QueryMetadataException, TeiidComponentException {
        if (RuleRemoveOptionalJoins.useNonDistinctRows(accessNode.getParent())) {
            return root;
        }
        if (queryCommand instanceof Query) {
            boolean allConstants = true;
            for (Expression ex : (List)accessNode.getProperty(NodeConstants.Info.OUTPUT_COLS)) {
                if (EvaluatableVisitor.willBecomeConstant(SymbolMap.getExpression(ex))) continue;
                allConstants = false;
                break;
            }
            if (allConstants) {
                Object mid = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
                if (!CapabilitiesUtil.supports(SourceCapabilities.Capability.ROW_LIMIT, mid, metadata, capabilitiesFinder)) {
                    PlanNode limit = NodeFactory.getNewNode(1024);
                    limit.setProperty(NodeConstants.Info.MAX_TUPLE_LIMIT, new Constant(1));
                    limit.setProperty(NodeConstants.Info.OUTPUT_COLS, accessNode.getProperty(NodeConstants.Info.OUTPUT_COLS));
                    if (accessNode.getParent() != null) {
                        accessNode.addAsParent(limit);
                        return root;
                    }
                    limit.addFirstChild(accessNode);
                    return limit;
                }
                if (queryCommand.getLimit() != null) {
                    if (queryCommand.getLimit().getRowLimit() == null) {
                        queryCommand.getLimit().setRowLimit(new Constant(1));
                    }
                } else {
                    queryCommand.setLimit(new Limit(null, new Constant(1)));
                }
                return root;
            }
        }
        if (queryCommand.getLimit() != null) {
            return root;
        }
        boolean canRemoveParentDup = false;
        if (queryCommand.getOrderBy() == null) {
            PlanNode project;
            PlanNode dupRemove = NodeEditor.findParent(accessNode, 2, 68);
            if (dupRemove != null && (project = NodeEditor.findParent(accessNode, 8, 2)) != null) {
                List projectCols = (List)project.getProperty(NodeConstants.Info.PROJECT_COLS);
                for (Expression ex : projectCols) {
                    if ((ex = SymbolMap.getExpression(ex)) instanceof ElementSymbol || ex instanceof Constant || EvaluatableVisitor.willBecomeConstant(ex, true)) continue;
                    return root;
                }
                canRemoveParentDup = true;
            }
            if (accessNode.hasBooleanProperty(NodeConstants.Info.IS_MULTI_SOURCE)) {
                if (dupRemove == null) {
                    return root;
                }
                canRemoveParentDup = false;
            } else if (!canRemoveParentDup) {
                return root;
            }
        }
        for (Expression ses : queryCommand.getProjectedSymbols()) {
            if (!DataTypeManager.isNonComparable((String)DataTypeManager.getDataTypeName(ses.getType()))) continue;
            return root;
        }
        if (queryCommand instanceof SetQuery) {
            ((SetQuery)queryCommand).setAll(false);
        } else if (CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_SELECT_DISTINCT, RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata), metadata, capFinder)) {
            Query query = (Query)queryCommand;
            HashSet<GroupSymbol> keyPreservingGroups = new HashSet<GroupSymbol>();
            ResolverUtil.findKeyPreserved(query, keyPreservingGroups, metadata);
            if (!QueryRewriter.isDistinctWithGroupBy(query) && !NewCalculateCostUtil.usesKey(query.getSelect().getProjectedSymbols(), keyPreservingGroups, metadata, true)) {
                if (canRemoveParentDup) {
                    PlanNode dupRemove = NodeEditor.findParent(accessNode, 2, 64);
                    if (dupRemove.getParent() == null) {
                        root = dupRemove.getFirstChild();
                        dupRemove.getFirstChild().removeFromParent();
                    } else {
                        dupRemove.getParent().replaceChild(dupRemove, dupRemove.getFirstChild());
                    }
                }
                ((Query)queryCommand).getSelect().setDistinct(true);
            }
        }
        return root;
    }

    private PlanNode removeUnnecessaryInlineView(PlanNode root, PlanNode accessNode) {
        PlanNode child = accessNode.getFirstChild();
        if (child.getType() == 8 && child.getFirstChild() != null && child.getFirstChild().hasBooleanProperty(NodeConstants.Info.INLINE_VIEW)) {
            HashSet requiredElements = new HashSet((List)child.getFirstChild().getProperty(NodeConstants.Info.OUTPUT_COLS));
            List selectSymbols = (List)child.getProperty(NodeConstants.Info.PROJECT_COLS);
            LinkedHashSet<Expression> symbols = new LinkedHashSet<Expression>();
            for (Expression symbol : selectSymbols) {
                Expression expr = SymbolMap.getExpression(symbol);
                if (!(expr instanceof ElementSymbol)) {
                    return root;
                }
                requiredElements.remove(expr);
                if (symbols.add(expr)) continue;
                return root;
            }
            if (!requiredElements.isEmpty()) {
                return root;
            }
            root = RuleRaiseAccess.performRaise(root, child, accessNode);
            child = accessNode.getFirstChild();
        }
        if (child.hasBooleanProperty(NodeConstants.Info.INLINE_VIEW)) {
            for (Expression ex : (List)accessNode.getProperty(NodeConstants.Info.OUTPUT_COLS)) {
                if (SymbolMap.getExpression(ex) instanceof ElementSymbol) continue;
                return root;
            }
            if (!accessNode.getProperty(NodeConstants.Info.OUTPUT_COLS).equals(child.getProperty(NodeConstants.Info.OUTPUT_COLS))) {
                return root;
            }
            child.removeProperty((Object)NodeConstants.Info.INLINE_VIEW);
            root = RuleRaiseAccess.performRaise(root, child, accessNode);
            accessNode.getGroups().clear();
            PlanNode sourceNode = FrameUtil.findJoinSourceNode(accessNode.getFirstChild());
            if (sourceNode != null) {
                accessNode.addGroups(sourceNode.getGroups());
            }
            child.setProperty(NodeConstants.Info.OUTPUT_COLS, accessNode.getProperty(NodeConstants.Info.OUTPUT_COLS));
            accessNode.setProperty(NodeConstants.Info.OUTPUT_COLS, accessNode.getFirstChild().getProperty(NodeConstants.Info.OUTPUT_COLS));
        }
        return root;
    }

    private QueryCommand createQuery(CommandContext context, CapabilitiesFinder capFinder, PlanNode accessRoot, PlanNode node) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        PlanNode groupNode;
        QueryMetadataInterface metadata = context.getMetadata();
        PlanNode setOpNode = NodeEditor.findNodePreOrder(node, 256, 64);
        Object modelID = RuleRaiseAccess.getModelIDFromAccess(accessRoot, metadata);
        if (setOpNode != null) {
            SetQuery.Operation setOp = (SetQuery.Operation)((Object)setOpNode.getProperty(NodeConstants.Info.SET_OPERATION));
            SetQuery unionCommand = new SetQuery(setOp);
            boolean unionAll = (Boolean)setOpNode.getProperty(NodeConstants.Info.USE_ALL);
            unionCommand.setAll(unionAll);
            int count = 0;
            OrderBy orderBy = null;
            PlanNode sort = NodeEditor.findNodePreOrder(node, 32, 256);
            if (sort != null) {
                this.processOrderBy(sort, unionCommand, context);
                orderBy = unionCommand.getOrderBy();
                unionCommand.setOrderBy(null);
                PlanNode groupNode2 = NodeEditor.findNodePreOrder(setOpNode.getFirstChild(), 128, 64);
                if (groupNode2 != null) {
                    SymbolMap symbolMap = (SymbolMap)groupNode2.getProperty(NodeConstants.Info.SYMBOL_MAP);
                    ExpressionMappingVisitor.mapExpressions(orderBy, symbolMap.asMap(), true);
                }
            }
            for (PlanNode child : setOpNode.getChildren()) {
                QueryCommand command = this.createQuery(context, capFinder, accessRoot, child);
                if (count == 0) {
                    unionCommand.setLeftQuery(command);
                } else if (count == 1) {
                    unionCommand.setRightQuery(command);
                } else {
                    unionCommand = new SetQuery(setOp, unionAll, unionCommand, command);
                }
                ++count;
            }
            PlanNode limit = NodeEditor.findNodePreOrder(node, 1024, 256);
            if (limit != null) {
                this.processLimit(limit, unionCommand, metadata);
            }
            unionCommand.setOrderBy(orderBy);
            return unionCommand;
        }
        Query query = new Query();
        Select select = new Select();
        List columns = (List)node.getProperty(NodeConstants.Info.OUTPUT_COLS);
        this.prepareSubqueries(ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(columns));
        select.addSymbols(columns);
        query.setSelect(select);
        query.setFrom(new From());
        this.buildQuery(accessRoot, node, query, context, capFinder);
        if (!CapabilitiesUtil.useAnsiJoin(modelID, metadata, capFinder)) {
            this.simplifyFromClause(query);
        }
        if (query.getCriteria() instanceof CompoundCriteria) {
            query.setCriteria(QueryRewriter.optimizeCriteria((CompoundCriteria)query.getCriteria(), metadata));
        }
        if (columns.isEmpty()) {
            if (CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, modelID, metadata, capFinder)) {
                select.addSymbol(new ExpressionSymbol("dummy", new Constant(1)));
            } else {
                select.addSymbol(RuleCollapseSource.selectOutputElement(query.getFrom().getGroups(), metadata));
            }
        }
        if ((groupNode = NodeEditor.findNodePreOrder(node, 128, 64)) != null) {
            if (query.getOrderBy() != null) {
                query.setOrderBy(query.getOrderBy().clone());
            }
            if (query.getHaving() != null) {
                query.setHaving((Criteria)query.getHaving().clone());
            }
            query.setSelect(query.getSelect().clone());
            SymbolMap symbolMap = (SymbolMap)groupNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
            ExpressionMappingVisitor.mapExpressions(query.getOrderBy(), symbolMap.asMap(), true);
            ExpressionMappingVisitor.mapExpressions(query.getSelect(), symbolMap.asMap(), true);
            ExpressionMappingVisitor.mapExpressions(query.getHaving(), symbolMap.asMap(), true);
            if (query.getHaving() != null && !CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_HAVING, modelID, metadata, capFinder)) {
                Query query2;
                Select sel = query.getSelect();
                GroupBy groupBy = query.getGroupBy();
                Criteria having = query.getHaving();
                query.setHaving(null);
                OrderBy orderBy = query.getOrderBy();
                query.setOrderBy(null);
                Limit limit = query.getLimit();
                query.setLimit(null);
                HashSet<AggregateSymbol> aggs = new HashSet<AggregateSymbol>();
                aggs.addAll(AggregateSymbolCollectorVisitor.getAggregates(having, true));
                HashSet<Expression> expr = new HashSet<Expression>();
                for (Expression expression : sel.getProjectedSymbols()) {
                    Expression selectExpression = SymbolMap.getExpression(expression);
                    aggs.remove(selectExpression);
                    expr.add(selectExpression);
                }
                int originalSelect = sel.getSymbols().size();
                sel.addSymbols(aggs);
                if (groupBy != null) {
                    for (Expression ex : groupBy.getSymbols()) {
                        if (!expr.add(ex = SymbolMap.getExpression(ex))) continue;
                        sel.addSymbol(ex);
                    }
                }
                Object var21_36 = null;
                try {
                    query2 = QueryRewriter.createInlineViewQuery(new GroupSymbol("X"), query, metadata, query.getSelect().getProjectedSymbols());
                }
                catch (TeiidException err) {
                    throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30257, (Throwable)err);
                }
                Iterator<Expression> iter = query2.getSelect().getProjectedSymbols().iterator();
                HashMap<Expression, Expression> expressionMap = new HashMap<Expression, Expression>();
                for (Expression symbol : query.getSelect().getProjectedSymbols()) {
                    expressionMap.put(SymbolMap.getExpression(symbol), SymbolMap.getExpression(iter.next()));
                }
                ExpressionMappingVisitor.mapExpressions(having, expressionMap, true);
                query2.setCriteria(having);
                ExpressionMappingVisitor.mapExpressions(orderBy, expressionMap, true);
                query2.setOrderBy(orderBy);
                query2.setLimit(limit);
                ExpressionMappingVisitor.mapExpressions(select, expressionMap, true);
                query2.getSelect().setSymbols(query2.getSelect().getProjectedSymbols().subList(0, originalSelect));
                query2.setOption(query.getOption());
                query = query2;
            }
            if (query.getGroupBy() != null) {
                boolean hasExpression = false;
                boolean hasLiteral = false;
                for (Expression ex : query.getGroupBy().getSymbols()) {
                    hasExpression |= !(ex instanceof ElementSymbol);
                    hasLiteral |= EvaluatableVisitor.willBecomeConstant(ex, true);
                }
                if ((hasExpression && !CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_FUNCTIONS_IN_GROUP_BY, modelID, metadata, capFinder) || hasLiteral) && (query = RuleCollapseSource.rewriteGroupByAsView(query, metadata, false)).getHaving() != null) {
                    List<Criteria> crits = Criteria.separateCriteriaByAnd(query.getHaving());
                    Iterator<Criteria> iter = crits.iterator();
                    while (iter.hasNext()) {
                        Criteria crit = iter.next();
                        if (!(crit instanceof DependentSetCriteria)) continue;
                        query.setCriteria(Criteria.combineCriteria(query.getCriteria(), crit));
                        iter.remove();
                    }
                    query.setHaving(Criteria.combineCriteria(crits));
                }
                if (query.getOrderBy() != null && groupNode.hasBooleanProperty(NodeConstants.Info.ROLLUP) && !CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_ORDERBY_EXTENDED_GROUPING, modelID, metadata, capFinder)) {
                    query = RuleCollapseSource.rewriteGroupByAsView(query, metadata, true);
                }
            }
        }
        return query;
    }

    static ElementSymbol selectOutputElement(Collection<GroupSymbol> groups, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        for (GroupSymbol group : groups) {
            List<ElementSymbol> elements = ResolverUtil.resolveElementsInGroup(group, metadata);
            for (ElementSymbol element : elements) {
                if (!metadata.elementSupports(element.getMetadataID(), 0)) continue;
                element = element.clone();
                element.setGroupSymbol(group);
                return element;
            }
        }
        return null;
    }

    void buildQuery(PlanNode accessRoot, PlanNode node, Query query, CommandContext context, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        QueryMetadataInterface metadata = context.getMetadata();
        Object modelID = RuleRaiseAccess.getModelIDFromAccess(accessRoot, metadata);
        switch (node.getType()) {
            case 4: {
                boolean subqueryOn;
                this.prepareSubqueries(node.getSubqueryContainers());
                JoinType joinType = (JoinType)node.getProperty(NodeConstants.Info.JOIN_TYPE);
                ArrayList<Criteria> crits = (ArrayList<Criteria>)node.getProperty(NodeConstants.Info.JOIN_CRITERIA);
                if (crits == null || crits.isEmpty()) {
                    crits = new ArrayList<Criteria>();
                } else {
                    RuleChooseJoinStrategy.filterOptionalCriteria(crits, false);
                    if (crits.isEmpty() && joinType == JoinType.JOIN_INNER) {
                        joinType = JoinType.JOIN_CROSS;
                    }
                }
                PlanNode left = node.getFirstChild();
                PlanNode right = node.getLastChild();
                Criteria savedCriteria = null;
                this.buildQuery(accessRoot, left, query, context, capFinder);
                if (joinType == JoinType.JOIN_LEFT_OUTER) {
                    savedCriteria = query.getCriteria();
                    query.setCriteria(null);
                }
                this.buildQuery(accessRoot, right, query, context, capFinder);
                if (joinType == JoinType.JOIN_LEFT_OUTER) {
                    this.moveWhereClauseIntoOnClause(query, crits);
                    query.setCriteria(savedCriteria);
                }
                if (!(joinType != JoinType.JOIN_LEFT_OUTER && joinType != JoinType.JOIN_FULL_OUTER || (subqueryOn = CapabilitiesUtil.supports(SourceCapabilities.Capability.CRITERIA_ON_SUBQUERY, modelID, metadata, capFinder)))) {
                    for (SubqueryContainer<?> subqueryContainer : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(crits)) {
                        if (subqueryContainer instanceof SubqueryContainer.Evaluatable && ((Command)subqueryContainer.getCommand()).getCorrelatedReferences() == null) {
                            ((SubqueryContainer.Evaluatable)subqueryContainer).setShouldEvaluate(true);
                            continue;
                        }
                        throw new AssertionError((Object)"On clause not expected to contain non-evaluatable subqueries");
                    }
                }
                From from = query.getFrom();
                List<FromClause> clauses = from.getClauses();
                int lastClause = clauses.size() - 1;
                FromClause clause1 = clauses.get(lastClause - 1);
                FromClause clause2 = clauses.get(lastClause);
                if (!joinType.isOuter() && !CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, modelID, metadata, capFinder)) {
                    joinType = JoinType.JOIN_LEFT_OUTER;
                    if (!crits.isEmpty() && !this.useLeftOuterJoin(query, metadata, crits, right.getGroups())) {
                        if (!this.useLeftOuterJoin(query, metadata, crits, left.getGroups())) {
                            throw new AssertionError((Object)"Could not convert inner to outer join.");
                        }
                        FromClause temp = clause1;
                        clause1 = clause2;
                        clause2 = temp;
                    }
                }
                if (joinType != JoinType.JOIN_CROSS && crits.isEmpty()) {
                    crits.add(QueryRewriter.TRUE_CRITERIA);
                } else if (joinType == JoinType.JOIN_CROSS && !crits.isEmpty()) {
                    joinType = JoinType.JOIN_INNER;
                }
                JoinPredicate jp = new JoinPredicate(clause1, clause2, joinType, crits);
                clauses.remove(lastClause);
                clauses.set(lastClause - 1, jp);
                return;
            }
            case 64: {
                PlanNode subPlan;
                boolean pushedTableProcedure = false;
                GroupSymbol symbol = node.getGroups().iterator().next();
                if (node.hasBooleanProperty(NodeConstants.Info.INLINE_VIEW)) {
                    SubqueryFromClause nested;
                    PlanNode child = node.getFirstChild();
                    QueryCommand newQuery = this.createQuery(context, capFinder, accessRoot, child);
                    SubqueryFromClause sfc = new SubqueryFromClause(symbol, (Command)newQuery);
                    SymbolMap map = (SymbolMap)node.getProperty(NodeConstants.Info.CORRELATED_REFERENCES);
                    if (map != null) {
                        RulePlanSubqueries.ReferenceReplacementVisitor visitor = new RulePlanSubqueries.ReferenceReplacementVisitor(map);
                        DeepPostOrderNavigator.doVisit(newQuery, visitor);
                        sfc.setLateral(true);
                    }
                    query.getFrom().addClause(sfc);
                    Query q = newQuery.getProjectedQuery();
                    List<Expression> expressions = q.getSelect().getSymbols();
                    List outputCols = (List)node.getProperty(NodeConstants.Info.OUTPUT_COLS);
                    HashMap<Expression, String> corrected = null;
                    for (int i = 0; i < outputCols.size(); ++i) {
                        Expression ex = expressions.get(i);
                        Expression expected = (Expression)outputCols.get(i);
                        String name = Symbol.getShortName(expected);
                        if (name.equals(Symbol.getShortName(ex))) continue;
                        expressions.set(i, new AliasSymbol(name, SymbolMap.getExpression(ex)));
                        corrected = new HashMap<Expression, String>();
                        corrected.put(ex, name);
                    }
                    if (corrected != null && newQuery.getOrderBy() != null) {
                        for (OrderByItem item : newQuery.getOrderBy().getOrderByItems()) {
                            String name = (String)corrected.get(item.getSymbol());
                            if (name == null) continue;
                            item.setSymbol(new AliasSymbol(name, SymbolMap.getExpression(item.getSymbol())));
                        }
                    }
                    if (newQuery instanceof Query && (q = (Query)newQuery).getFrom() != null && q.getFrom().getClauses().size() == 1 && q.getFrom().getClauses().get(0) instanceof SubqueryFromClause && (nested = (SubqueryFromClause)q.getFrom().getClauses().get(0)).getCommand() instanceof StoredProcedure) {
                        sfc.setCommand(nested.getCommand());
                    }
                    return;
                }
                Command command = (Command)node.getProperty(NodeConstants.Info.VIRTUAL_COMMAND);
                if (command instanceof StoredProcedure) {
                    StoredProcedure storedProcedure = (StoredProcedure)command;
                    storedProcedure.setPushedInQuery(true);
                    SubqueryFromClause subqueryFromClause = new SubqueryFromClause(symbol, (Command)storedProcedure);
                    query.getFrom().addClause(subqueryFromClause);
                    pushedTableProcedure = true;
                }
                if ((subPlan = (PlanNode)node.getProperty(NodeConstants.Info.SUB_PLAN)) != null) {
                    HashMap<GroupSymbol, PlanNode> subPlans = (HashMap<GroupSymbol, PlanNode>)accessRoot.getProperty(NodeConstants.Info.SUB_PLANS);
                    if (subPlans == null) {
                        subPlans = new HashMap<GroupSymbol, PlanNode>();
                        accessRoot.setProperty(NodeConstants.Info.SUB_PLANS, subPlans);
                    }
                    subPlans.put(symbol, subPlan);
                }
                if (pushedTableProcedure) break;
                query.getFrom().addGroup(symbol);
                break;
            }
        }
        for (PlanNode childNode : node.getChildren()) {
            this.buildQuery(accessRoot, childNode, query, context, capFinder);
        }
        switch (node.getType()) {
            case 16: {
                Criteria crit = (Criteria)node.getProperty(NodeConstants.Info.SELECT_CRITERIA);
                this.prepareSubqueries(node.getSubqueryContainers());
                if (!node.hasBooleanProperty(NodeConstants.Info.IS_HAVING)) {
                    query.setCriteria(CompoundCriteria.combineCriteria(query.getCriteria(), crit));
                    break;
                }
                query.setHaving(CompoundCriteria.combineCriteria(query.getHaving(), crit));
                break;
            }
            case 32: {
                this.prepareSubqueries(node.getSubqueryContainers());
                this.processOrderBy(node, query, context);
                break;
            }
            case 2: {
                List groups;
                boolean distinct = true;
                PlanNode grouping = NodeEditor.findNodePreOrder(node.getFirstChild(), 128, 64);
                if (grouping != null && ((groups = (List)grouping.getProperty(NodeConstants.Info.GROUP_COLS)) == null || groups.isEmpty())) {
                    distinct = false;
                }
                query.getSelect().setDistinct(distinct);
                break;
            }
            case 128: {
                List groups = (List)node.getProperty(NodeConstants.Info.GROUP_COLS);
                if (groups == null || groups.isEmpty()) break;
                query.setGroupBy(new GroupBy(groups));
                if (!node.hasBooleanProperty(NodeConstants.Info.ROLLUP)) break;
                query.getGroupBy().setRollup(true);
                break;
            }
            case 1024: {
                this.processLimit(node, query, metadata);
            }
        }
    }

    private boolean useLeftOuterJoin(Query query, QueryMetadataInterface metadata, List<Criteria> crits, Set<GroupSymbol> innerGroups) {
        Criteria c = query.getCriteria();
        if (c != null) {
            List<Criteria> parts = Criteria.separateCriteriaByAnd(c);
            for (Criteria criteria : parts) {
                if (JoinUtil.isNullDependent(metadata, innerGroups, criteria)) continue;
                return true;
            }
        }
        ElementSymbol es = null;
        for (Criteria criteria : crits) {
            if (!(criteria instanceof CompareCriteria)) continue;
            CompareCriteria cc = (CompareCriteria)criteria;
            if (cc.getLeftExpression() instanceof ElementSymbol && innerGroups.contains(((ElementSymbol)cc.getLeftExpression()).getGroupSymbol())) {
                es = (ElementSymbol)cc.getLeftExpression();
                break;
            }
            if (!(cc.getRightExpression() instanceof ElementSymbol) || !innerGroups.contains(((ElementSymbol)cc.getRightExpression()).getGroupSymbol())) continue;
            es = (ElementSymbol)cc.getRightExpression();
            break;
        }
        if (es == null) {
            return false;
        }
        IsNullCriteria inc = new IsNullCriteria(es);
        inc.setNegated(true);
        query.setCriteria(CompoundCriteria.combineCriteria(c, inc));
        return true;
    }

    private void prepareSubqueries(List<SubqueryContainer<?>> containers) {
        for (SubqueryContainer<?> container : containers) {
            RuleCollapseSource.prepareSubquery(container);
        }
    }

    public static void prepareSubquery(SubqueryContainer container) {
        RelationalPlan subqueryPlan = (RelationalPlan)((Command)container.getCommand()).getProcessorPlan();
        AccessNode aNode = CriteriaCapabilityValidatorVisitor.getAccessNode(subqueryPlan);
        QueryCommand command = CriteriaCapabilityValidatorVisitor.getQueryCommand(aNode);
        if (command == null) {
            return;
        }
        SymbolMap map = ((Command)container.getCommand()).getCorrelatedReferences();
        if (map != null) {
            RulePlanSubqueries.ReferenceReplacementVisitor visitor = new RulePlanSubqueries.ReferenceReplacementVisitor(map);
            DeepPostOrderNavigator.doVisit(command, visitor);
        }
        command.setProcessorPlan(((Command)container.getCommand()).getProcessorPlan());
        boolean removeLimit = false;
        if (container instanceof ExistsCriteria) {
            removeLimit = !((ExistsCriteria)container).shouldEvaluate();
        } else if (container instanceof ScalarSubquery) {
            boolean bl = removeLimit = !((ScalarSubquery)container).shouldEvaluate();
        }
        if (removeLimit && command.getLimit() != null && command.getLimit().isImplicit()) {
            command.setLimit(null);
        }
        container.setCommand(command);
    }

    private void processLimit(PlanNode node, QueryCommand query, QueryMetadataInterface metadata) {
        Expression limit = (Expression)node.getProperty(NodeConstants.Info.MAX_TUPLE_LIMIT);
        Expression offset = (Expression)node.getProperty(NodeConstants.Info.OFFSET_TUPLE_COUNT);
        PlanNode limitNode = NodeFactory.getNewNode(1024);
        Expression childLimit = null;
        Expression childOffset = null;
        if (query.getLimit() != null) {
            childLimit = query.getLimit().getRowLimit();
            childOffset = query.getLimit().getOffset();
        }
        RulePushLimit.combineLimits(limitNode, metadata, limit, offset, childLimit, childOffset);
        Limit lim = new Limit((Expression)limitNode.getProperty(NodeConstants.Info.OFFSET_TUPLE_COUNT), (Expression)limitNode.getProperty(NodeConstants.Info.MAX_TUPLE_LIMIT));
        lim.setImplicit(node.hasBooleanProperty(NodeConstants.Info.IS_IMPLICIT_LIMIT) && (query.getLimit() == null || query.getLimit().isImplicit()));
        query.setLimit(lim);
    }

    private void moveWhereClauseIntoOnClause(Query query, List joinCrits) {
        if (query.getCriteria() == null) {
            return;
        }
        LinkedHashSet<Criteria> combinedCrits = new LinkedHashSet<Criteria>();
        combinedCrits.addAll(joinCrits);
        combinedCrits.addAll(Criteria.separateCriteriaByAnd(query.getCriteria()));
        joinCrits.clear();
        joinCrits.addAll(combinedCrits);
        query.setCriteria(null);
    }

    private void processOrderBy(PlanNode node, QueryCommand query, CommandContext context) throws QueryMetadataException, TeiidComponentException {
        OrderBy orderBy = (OrderBy)node.getProperty(NodeConstants.Info.SORT_ORDER);
        query.setOrderBy(orderBy);
        if (query instanceof Query) {
            List<Expression> cols = query.getProjectedSymbols();
            ArrayList<Expression> exprs = new ArrayList<Expression>(cols.size());
            for (Expression expr : cols) {
                exprs.add(SymbolMap.getExpression(expr));
            }
            for (OrderByItem item : orderBy.getOrderByItems()) {
                item.setExpressionPosition(exprs.indexOf(SymbolMap.getExpression(item.getSymbol())));
            }
            try {
                QueryRewriter.rewriteOrderBy(query, orderBy, query.getProjectedSymbols(), context, context.getMetadata());
            }
            catch (TeiidProcessingException e) {
                throw new TeiidComponentException((Throwable)e);
            }
        }
    }

    private void simplifyFromClause(Query query) {
        From from = query.getFrom();
        List<FromClause> clauses = from.getClauses();
        FromClause rootClause = clauses.get(0);
        if (!RuleCollapseSource.hasOuterJoins(rootClause)) {
            from.setClauses(new ArrayList<FromClause>());
            this.shredJoinTree(rootClause, query);
        }
    }

    private void shredJoinTree(FromClause clause, Query query) {
        if (clause instanceof UnaryFromClause || clause instanceof SubqueryFromClause) {
            query.getFrom().addClause(clause);
        } else {
            JoinPredicate jp = (JoinPredicate)clause;
            List crits = jp.getJoinCriteria();
            if (crits != null && crits.size() > 0) {
                Criteria joinCrit = null;
                joinCrit = crits.size() > 1 ? new CompoundCriteria(crits) : (Criteria)crits.get(0);
                query.setCriteria(CompoundCriteria.combineCriteria(joinCrit, query.getCriteria()));
            }
            this.shredJoinTree(jp.getLeftClause(), query);
            this.shredJoinTree(jp.getRightClause(), query);
        }
    }

    static boolean hasOuterJoins(FromClause clause) {
        if (clause instanceof SubqueryFromClause) {
            return ((SubqueryFromClause)clause).isLateral();
        }
        if (clause instanceof UnaryFromClause) {
            return false;
        }
        JoinPredicate jp = (JoinPredicate)clause;
        if (jp.getJoinType().isOuter()) {
            return true;
        }
        boolean childHasOuter = RuleCollapseSource.hasOuterJoins(jp.getLeftClause());
        if (childHasOuter) {
            return true;
        }
        return RuleCollapseSource.hasOuterJoins(jp.getRightClause());
    }

    public String toString() {
        return "CollapseSource";
    }

    public static Query rewriteGroupByAsView(Query query, QueryMetadataInterface metadata, boolean addViewForOrderBy) {
        Query query2;
        if (query.getGroupBy() == null) {
            return query;
        }
        Select select = query.getSelect();
        GroupBy groupBy = query.getGroupBy();
        if (!addViewForOrderBy) {
            query.setGroupBy(null);
        }
        Criteria having = query.getHaving();
        query.setHaving(null);
        OrderBy orderBy = query.getOrderBy();
        query.setOrderBy(null);
        Limit limit = query.getLimit();
        query.setLimit(null);
        LinkedHashSet<Expression> newSelectColumns = new LinkedHashSet<Expression>();
        Iterator<Expression> iterator = groupBy.getSymbols().iterator();
        while (iterator.hasNext()) {
            newSelectColumns.add(iterator.next());
        }
        HashSet<AggregateSymbol> aggs = new HashSet<AggregateSymbol>();
        aggs.addAll(AggregateSymbolCollectorVisitor.getAggregates(select, true));
        if (having != null) {
            aggs.addAll(AggregateSymbolCollectorVisitor.getAggregates(having, true));
        }
        for (AggregateSymbol aggregateSymbol : aggs) {
            for (Expression expr : aggregateSymbol.getArgs()) {
                newSelectColumns.add(SymbolMap.getExpression(expr));
            }
        }
        Select innerSelect = new Select();
        for (Expression expr : newSelectColumns) {
            innerSelect.addSymbol(expr);
        }
        query.setSelect(innerSelect);
        Object var11_13 = null;
        try {
            query2 = QueryRewriter.createInlineViewQuery(new GroupSymbol("X"), query, metadata, query.getSelect().getProjectedSymbols());
        }
        catch (TeiidException err) {
            throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30257, (Throwable)err);
        }
        Iterator<Expression> iter = query2.getSelect().getProjectedSymbols().iterator();
        HashMap<Expression, Expression> expressionMap = new HashMap<Expression, Expression>();
        for (Expression symbol : query.getSelect().getProjectedSymbols()) {
            expressionMap.put(SymbolMap.getExpression(symbol), SymbolMap.getExpression(iter.next()));
        }
        if (!addViewForOrderBy) {
            ExpressionMappingVisitor.mapExpressions(groupBy, expressionMap);
            query2.setGroupBy(groupBy);
        }
        ExpressionMappingVisitor.mapExpressions(having, expressionMap, true);
        query2.setHaving(having);
        ExpressionMappingVisitor.mapExpressions(orderBy, expressionMap, true);
        query2.setOrderBy(orderBy);
        query2.setLimit(limit);
        ExpressionMappingVisitor.mapExpressions(select, expressionMap, true);
        query2.setSelect(select);
        query2.setOption(query.getOption());
        query = query2;
        return query;
    }
}

