/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.id.IDGenerator;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.rules.RuleChooseJoinStrategy;
import org.teiid.query.optimizer.relational.rules.RulePlanSubqueries;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.proc.ForEachRowPlan;
import org.teiid.query.processor.proc.ProcedurePlan;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.FilteredCommand;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.navigator.DeepPostOrderNavigator;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.proc.Statement;
import org.teiid.query.sql.proc.TriggerAction;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;
import org.teiid.query.util.CommandContext;

public final class TriggerActionPlanner {
    public ProcessorPlan optimize(ProcedureContainer userCommand, TriggerAction ta, IDGenerator idGenerator, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryMetadataException, TeiidComponentException, QueryResolverException, TeiidProcessingException {
        QueryRewriter.rewrite(ta, metadata, context, QueryResolver.getVariableValues(userCommand, true, metadata));
        QueryCommand query = null;
        HashMap<ElementSymbol, Expression> params = new HashMap<ElementSymbol, Expression>();
        Map<ElementSymbol, Expression> mapping = QueryResolver.getVariableValues(userCommand, false, metadata);
        for (Map.Entry<ElementSymbol, Expression> entry : mapping.entrySet()) {
            entry.setValue(QueryRewriter.rewriteExpression(entry.getValue(), context, metadata));
        }
        boolean singleRow = false;
        if (userCommand instanceof Insert) {
            Insert insert = (Insert)userCommand;
            if (insert.getQueryExpression() != null) {
                query = insert.getQueryExpression();
            } else {
                singleRow = true;
                query = new Query();
                ((Query)query).setSelect(new Select(RuleChooseJoinStrategy.createExpressionSymbols(insert.getValues())));
            }
            ProcessorPlan processorPlan = this.rewritePlan(ta, idGenerator, metadata, capFinder, analysisRecord, context, query, mapping, insert);
            if (processorPlan != null) {
                return processorPlan;
            }
        } else if (userCommand instanceof Delete) {
            query = this.createOldQuery(userCommand, ta, metadata, params);
        } else if (userCommand instanceof Update) {
            query = this.createOldQuery(userCommand, ta, metadata, params);
        } else {
            throw new AssertionError();
        }
        for (Map.Entry entry : mapping.entrySet()) {
            Expression value = (Expression)entry.getValue();
            params.put((ElementSymbol)entry.getKey(), value);
            if (!((ElementSymbol)entry.getKey()).getGroupSymbol().getShortName().equalsIgnoreCase("NEW") || !(userCommand instanceof Update)) continue;
            ((Query)query).getSelect().addSymbol(value);
        }
        ForEachRowPlan result = new ForEachRowPlan();
        result.setSingleRow(singleRow);
        result.setParams(params);
        ProcessorPlan processorPlan = QueryOptimizer.optimizePlan(query, metadata, idGenerator, capFinder, analysisRecord, context);
        result.setQueryPlan(processorPlan);
        result.setLookupMap(RelationalNode.createLookupMap(query.getProjectedSymbols()));
        CreateProcedureCommand command = new CreateProcedureCommand(ta.getBlock());
        command.setVirtualGroup(ta.getView());
        command.setUpdateType(userCommand.getType());
        ProcedurePlan rowProcedure = (ProcedurePlan)QueryOptimizer.optimizePlan(command, metadata, idGenerator, capFinder, analysisRecord, context);
        rowProcedure.setRunInContext(false);
        result.setRowProcedure(rowProcedure);
        return result;
    }

    private ProcessorPlan rewritePlan(TriggerAction ta, IDGenerator idGenerator, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context, QueryCommand query, Map<ElementSymbol, Expression> mapping, Insert insert) throws QueryMetadataException, QueryResolverException, TeiidComponentException, QueryPlannerException {
        if (ta.getBlock().getStatements().size() != 1) {
            return null;
        }
        Statement s = ta.getBlock().getStatements().get(0);
        if (!(s instanceof CommandStatement)) {
            return null;
        }
        CommandStatement cs = (CommandStatement)s;
        if (!(cs.getCommand() instanceof Insert)) {
            return null;
        }
        Insert mapped = (Insert)cs.getCommand();
        if (mapped.getQueryExpression() != null) {
            return null;
        }
        if (insert.getQueryExpression() != null) {
            GroupSymbol group = new GroupSymbol("X");
            Collection<GroupSymbol> groups = GroupCollectorVisitor.getGroups((LanguageObject)query, true);
            int i = 0;
            while (groups.contains(group)) {
                group.setName("X_" + i);
                ++i;
            }
            List<Expression> projectedSymbols = query.getProjectedSymbols();
            Query queryExpression = QueryRewriter.createInlineViewQuery(group, query, metadata, projectedSymbols);
            ArrayList<Expression> viewSymbols = new ArrayList<Expression>(queryExpression.getSelect().getSymbols());
            queryExpression.getSelect().clearSymbols();
            List values = mapped.getValues();
            queryExpression.getSelect().addSymbols(values);
            values.clear();
            for (int i2 = 0; i2 < projectedSymbols.size(); ++i2) {
                ElementSymbol es = insert.getVariables().get(i2);
                mapping.put(new ElementSymbol(es.getShortName(), new GroupSymbol("NEW")), SymbolMap.getExpression((Expression)viewSymbols.get(i2)));
            }
            SymbolMap queryMapping = new SymbolMap();
            queryMapping.asUpdatableMap().putAll(mapping);
            RulePlanSubqueries.ReferenceReplacementVisitor visitor = new RulePlanSubqueries.ReferenceReplacementVisitor(queryMapping);
            DeepPostOrderNavigator.doVisit(queryExpression.getSelect(), visitor);
            mapped.setQueryExpression(queryExpression);
            return QueryOptimizer.optimizePlan(mapped, metadata, idGenerator, capFinder, analysisRecord, context);
        }
        List values = mapped.getValues();
        SymbolMap queryMapping = new SymbolMap();
        queryMapping.asUpdatableMap().putAll(mapping);
        RulePlanSubqueries.ReferenceReplacementVisitor visitor = new RulePlanSubqueries.ReferenceReplacementVisitor(queryMapping);
        Select select = new Select();
        select.addSymbols(values);
        DeepPostOrderNavigator.doVisit(select, visitor);
        values.clear();
        for (Expression ex : select.getSymbols()) {
            try {
                values.add(QueryRewriter.rewriteExpression(SymbolMap.getExpression(ex), context, metadata));
            }
            catch (TeiidProcessingException e) {
                throw new QueryPlannerException(e);
            }
        }
        return QueryOptimizer.optimizePlan(mapped, metadata, idGenerator, capFinder, analysisRecord, context);
    }

    private QueryCommand createOldQuery(ProcedureContainer userCommand, TriggerAction ta, QueryMetadataInterface metadata, Map<ElementSymbol, Expression> params) throws QueryMetadataException, TeiidComponentException {
        List<ElementSymbol> allSymbols = ResolverUtil.resolveElementsInGroup(ta.getView(), metadata);
        GroupSymbol old = new GroupSymbol("OLD");
        GroupSymbol newGroup = new GroupSymbol("NEW");
        for (ElementSymbol elementSymbol : allSymbols) {
            ElementSymbol es = elementSymbol.clone();
            es.setGroupSymbol(old);
            params.put(es, elementSymbol);
            if (!(userCommand instanceof Update)) continue;
            es = elementSymbol.clone();
            es.setGroupSymbol(newGroup);
            params.put(es, elementSymbol);
        }
        ArrayList<ElementSymbol> selectSymbols = new ArrayList<ElementSymbol>(LanguageObject.Util.deepClone(allSymbols, ElementSymbol.class));
        Query query = new Query(new Select(selectSymbols), new From(Arrays.asList(new UnaryFromClause(ta.getView()))), ((FilteredCommand)((Object)userCommand)).getCriteria(), null, null);
        return query;
    }
}

