/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.teiid.adminapi.Admin;
import org.teiid.core.types.DataTypeManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.DataWrapper;
import org.teiid.metadata.Database;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.Permission;
import org.teiid.metadata.Policy;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Role;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Server;
import org.teiid.metadata.Table;
import org.teiid.metadata.Trigger;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class DDLStringVisitor {
    private static final String TAB = "\t";
    private static final String NEWLINE = "\n";
    public static final String GENERATED = "TEIID_GENERATED";
    private static final HashSet<String> PRECISION_DATATYPES = new HashSet<String>(Arrays.asList("bigdecimal"));
    protected StringBuilder buffer = new StringBuilder();
    private boolean includeTables = true;
    private boolean includeProcedures = true;
    private boolean includeFunctions = true;
    private Pattern filter;

    public static String getDDLString(Schema schema, EnumSet<Admin.SchemaObjectType> types, String regexPattern) {
        DDLStringVisitor visitor = new DDLStringVisitor(types, regexPattern);
        visitor.visit(schema);
        return visitor.toString();
    }

    public static String getDDLString(Database database) {
        DDLStringVisitor visitor = new DDLStringVisitor(null, null);
        visitor.visit(database);
        return visitor.toString();
    }

    public DDLStringVisitor(EnumSet<Admin.SchemaObjectType> types, String regexPattern) {
        if (types != null) {
            this.includeTables = types.contains(Admin.SchemaObjectType.TABLES);
            this.includeProcedures = types.contains(Admin.SchemaObjectType.PROCEDURES);
            this.includeFunctions = types.contains(Admin.SchemaObjectType.FUNCTIONS);
        }
        if (regexPattern != null) {
            this.filter = Pattern.compile(regexPattern);
        }
    }

    public void visit(Database database) {
        this.append(NEWLINE);
        this.append("/*").append(NEWLINE);
        this.append("###########################################").append(NEWLINE);
        this.append("# START DATABASE ").append(database.getName()).append(NEWLINE);
        this.append("###########################################").append(NEWLINE);
        this.append("*/").append(NEWLINE);
        this.append("CREATE").append(" ").append("DATABASE").append(" ").append(SQLStringVisitor.escapeSinglePart(database.getName())).append(" ").append("VERSION").append(" ").append(new Constant(database.getVersion()));
        this.appendOptions((AbstractMetadataRecord)database);
        this.append(";");
        this.append(NEWLINE);
        this.append("USE").append(" ").append("DATABASE").append(" ");
        this.append(SQLStringVisitor.escapeSinglePart(database.getName())).append(" ");
        this.append("VERSION").append(" ").append(new Constant(database.getVersion()));
        this.append(";");
        this.append(NEWLINE);
        boolean outputDt = false;
        for (Datatype dt : database.getMetadataStore().getDatatypes().values()) {
            if (dt.getType() != Datatype.Type.Domain) continue;
            outputDt = true;
            break;
        }
        if (outputDt) {
            this.append(NEWLINE);
            this.append("--############ Domains ############");
            this.append(NEWLINE);
            for (Datatype dt : database.getMetadataStore().getDatatypes().values()) {
                if (dt.isBuiltin()) continue;
                this.visit(dt);
                this.append(NEWLINE);
                this.append(NEWLINE);
            }
        }
        if (!database.getDataWrappers().isEmpty()) {
            this.append(NEWLINE);
            this.append("--############ Translators ############");
            this.append(NEWLINE);
            for (DataWrapper dw : database.getDataWrappers()) {
                this.visit(dw);
                this.append(NEWLINE);
                this.append(NEWLINE);
            }
        }
        if (!database.getServers().isEmpty()) {
            this.append(NEWLINE);
            this.append("--############ Servers ############");
            this.append(NEWLINE);
            for (Server server : database.getServers()) {
                this.visit(server);
                this.append(NEWLINE);
                this.append(NEWLINE);
            }
        }
        if (!database.getSchemas().isEmpty()) {
            this.append(NEWLINE);
            this.append("--############ Schemas ############");
            this.append(NEWLINE);
            for (Schema schema : database.getSchemas()) {
                this.append("CREATE");
                if (!schema.isPhysical()) {
                    this.append(" ").append("VIRTUAL");
                }
                this.append(" ").append("SCHEMA").append(" ").append(SQLStringVisitor.escapeSinglePart(schema.getName()));
                if (!schema.getServers().isEmpty()) {
                    this.append(" ").append("SERVER");
                    boolean first = true;
                    for (Server s : schema.getServers()) {
                        if (first) {
                            first = false;
                        } else {
                            this.append(",");
                        }
                        this.append(" ").append(SQLStringVisitor.escapeSinglePart(s.getName()));
                    }
                }
                this.appendOptions((AbstractMetadataRecord)schema);
                this.append(";");
                this.append(NEWLINE);
                this.append(NEWLINE);
                this.createdSchmea(schema);
            }
        }
        if (!database.getRoles().isEmpty()) {
            this.append(NEWLINE);
            this.append("--############ Roles ############");
            this.append(NEWLINE);
            for (Role role : database.getRoles()) {
                this.visit(role);
                this.append(NEWLINE);
                this.append(NEWLINE);
            }
        }
        for (Schema schema : database.getSchemas()) {
            this.append(NEWLINE);
            this.append("--############ Schema:").append(schema.getName()).append(" ############");
            this.append(NEWLINE);
            this.append("SET").append(" ").append("SCHEMA").append(" ");
            this.append(SQLStringVisitor.escapeSinglePart(schema.getName())).append(";");
            this.append(NEWLINE);
            this.append(NEWLINE);
            this.visit(schema);
        }
        if (!database.getRoles().isEmpty()) {
            boolean hasPolicies = false;
            this.append(NEWLINE);
            this.append("--############ Grants ############");
            this.append(NEWLINE);
            for (Role role : database.getRoles()) {
                this.visitGrants(role);
                this.append(NEWLINE);
                if (role.getPolicies().isEmpty()) continue;
                hasPolicies = true;
            }
            if (hasPolicies) {
                this.append(NEWLINE);
                this.append("--############ Policies ############");
                this.append(NEWLINE);
                for (Role role : database.getRoles()) {
                    this.visitPolicies(role);
                    this.append(NEWLINE);
                }
            }
        }
        this.append(NEWLINE);
        this.append("/*").append(NEWLINE);
        this.append("###########################################").append(NEWLINE);
        this.append("# END DATABASE ").append(database.getName()).append(NEWLINE);
        this.append("###########################################").append(NEWLINE);
        this.append("*/").append(NEWLINE);
        this.append(NEWLINE);
    }

    protected void createdSchmea(Schema schema) {
    }

    private void visit(Datatype dt) {
        this.append("CREATE").append(" ").append("DOMAIN").append(" ");
        this.append(SQLStringVisitor.escapeSinglePart(dt.getName())).append(" ").append("AS").append(" ");
        String runtimeTypeName = dt.getBasetypeName();
        this.append(runtimeTypeName);
        Datatype base = SystemMetadata.getInstance().getRuntimeTypeMap().get(runtimeTypeName);
        if (DataTypeManager.hasLength((String)runtimeTypeName)) {
            if (dt.getLength() != base.getLength()) {
                this.append("(").append(dt.getLength()).append(")");
            }
        } else if (PRECISION_DATATYPES.contains(runtimeTypeName) && (dt.getPrecision() != base.getPrecision() || dt.getScale() != base.getScale())) {
            this.append("(").append(dt.getPrecision());
            if (dt.getScale() != 0) {
                this.append(",").append(dt.getScale());
            }
            this.append(")");
        }
        if (dt.getNullType() == BaseColumn.NullType.No_Nulls) {
            this.append(" ").append("NOT NULL");
        }
        this.append(";");
    }

    private void visitPolicies(Role r) {
        for (Map policies : r.getPolicies().values()) {
            for (Policy p : policies.values()) {
                this.visitPolicy(r, p);
            }
        }
    }

    private void visitPolicy(Role r, Policy p) {
        this.append("CREATE").append(" ").append("POLICY").append(" ");
        this.append(SQLStringVisitor.escapeSinglePart(p.getName())).append(" ");
        this.append("ON").append(" ");
        if (p.getResourceType() == Database.ResourceType.PROCEDURE) {
            this.append("PROCEDURE").append(" ");
            this.append(new GroupSymbol(p.getResourceName())).append(" ");
            if (p.getOperations().contains(Policy.Operation.ALL)) {
                this.append("FOR").append(" ").append("ALL");
            }
        } else {
            this.append(new GroupSymbol(p.getResourceName())).append(" ");
            if (p.getOperations().contains(Policy.Operation.ALL)) {
                this.append("FOR").append(" ").append("ALL").append(" ");
            } else if (!p.getOperations().isEmpty()) {
                this.append("FOR").append(" ");
                boolean first = true;
                for (Policy.Operation oper : p.getOperations()) {
                    if (!first) {
                        this.append(",").append(" ");
                    }
                    this.append(oper.name());
                    first = false;
                }
                this.append(" ");
            }
        }
        this.append("TO").append(" ").append(r.getName()).append(" ");
        this.append("USING").append(" ").append("(").append(p.getCondition()).append(")");
        this.append(";").append(NEWLINE);
    }

    private void visitGrants(Role r) {
        for (Permission permission : r.getGrants().values()) {
            if (permission.getResourceType() == Database.ResourceType.DATABASE && permission.getResourceName() == null) {
                for (Permission.Privilege p : permission.getPrivileges()) {
                    this.appendGrant(r, permission, EnumSet.of(p), false);
                }
                for (Permission.Privilege p : permission.getRevokePrivileges()) {
                    this.appendGrant(r, permission, EnumSet.of(p), true);
                }
                continue;
            }
            if (!permission.getPrivileges().isEmpty() || permission.getMask() != null) {
                this.appendGrant(r, permission, permission.getPrivileges(), false);
            }
            if (permission.getCondition() != null) {
                Policy p = new Policy();
                p.setCondition(permission.getCondition());
                p.setName("grant_policy_" + permission.getResourceName());
                if (Boolean.FALSE.equals(permission.isConditionAConstraint())) {
                    p.getOperations().add(Policy.Operation.SELECT);
                    p.getOperations().add(Policy.Operation.DELETE);
                } else {
                    p.getOperations().add(Policy.Operation.ALL);
                }
                p.setResourceName(permission.getResourceName());
                p.setResourceType(permission.getResourceType());
                this.visitPolicy(r, p);
            }
            if (permission.getRevokePrivileges().isEmpty()) continue;
            this.appendGrant(r, permission, permission.getRevokePrivileges(), true);
        }
    }

    private void appendGrant(Role role, Permission permission, EnumSet<Permission.Privilege> privileges, boolean revoke) {
        this.append(revoke ? "REVOKE" : "GRANT");
        boolean first = true;
        for (Permission.Privilege allowance : privileges) {
            if (first) {
                first = false;
                this.append(" ");
            } else {
                this.append(",");
            }
            this.append(allowance);
        }
        if (permission.getResourceType() != Database.ResourceType.DATABASE) {
            this.append(" ").append("ON").append(" ").append(permission.getResourceType());
        }
        if (permission.getResourceName() != null) {
            this.append(" ").append(SQLStringVisitor.escapeSinglePart(permission.getResourceName()));
        }
        if (!revoke && permission.getMask() != null) {
            this.append(" ").append("MASK");
            if (permission.getMaskOrder() != null && permission.getMaskOrder() != -1) {
                this.append(" ").append("ORDER").append(" ").append(permission.getMaskOrder());
            }
            this.append(" ").append(new Constant(permission.getMask()));
        }
        this.append(" ").append(revoke ? "FROM" : "TO").append(" ").append(role.getName());
        this.append(";").append(NEWLINE);
    }

    private void visit(Role role) {
        this.append("CREATE").append(" ").append("ROLE").append(" ").append(SQLStringVisitor.escapeSinglePart(role.getName()));
        if (role.isAnyAuthenticated()) {
            this.append(" ").append("WITH").append(" ").append("ANY").append(" ").append("AUTHENTICATED");
        } else if (role.getMappedRoles() != null && !role.getMappedRoles().isEmpty()) {
            this.append(" ").append("WITH").append(" ").append("FOREIGN").append(" ").append("ROLE");
            for (String str : role.getMappedRoles()) {
                this.append(" ").append(SQLStringVisitor.escapeSinglePart(str));
            }
        }
        this.append(";");
    }

    private void visit(DataWrapper dw) {
        this.append("CREATE").append(" ").append("FOREIGN").append(" ").append("DATA").append(" ").append("WRAPPER").append(" ");
        this.append(SQLStringVisitor.escapeSinglePart(dw.getName()));
        if (dw.getType() != null) {
            this.append(" ").append("TYPE").append(" ").append(SQLStringVisitor.escapeSinglePart(dw.getType()));
        }
        this.appendOptions((AbstractMetadataRecord)dw);
        this.append(";");
    }

    private void visit(Server server) {
        this.append("CREATE").append(" ").append("SERVER").append(" ").append(SQLStringVisitor.escapeSinglePart(server.getName()));
        if (server.getType() != null) {
            this.append(" ").append("TYPE").append(" ").append(new Constant(server.getType()));
        }
        if (server.getVersion() != null) {
            this.append(" ").append("VERSION").append(" ").append(new Constant(server.getVersion()));
        }
        this.append(" ").append("FOREIGN").append(" ").append("DATA").append(" ").append("WRAPPER").append(" ");
        this.append(SQLStringVisitor.escapeSinglePart(server.getDataWrapper()));
        this.appendOptions((AbstractMetadataRecord)server);
        this.append(";");
    }

    protected void visit(Schema schema) {
        boolean first = true;
        for (AbstractMetadataRecord record : schema.getResolvingOrder()) {
            String generated = record.getProperty(GENERATED, false);
            if (generated != null && Boolean.valueOf(generated).booleanValue()) continue;
            if (record instanceof Table) {
                if (!this.includeTables) {
                    continue;
                }
            } else if (!(record instanceof Procedure) ? record instanceof FunctionMethod && !this.includeFunctions : !this.includeProcedures) continue;
            if (!this.shouldInclude(record)) continue;
            if (first) {
                first = false;
            } else {
                this.append(NEWLINE);
                this.append(NEWLINE);
            }
            if (record instanceof Table) {
                this.visit((Table)record);
                continue;
            }
            if (record instanceof Procedure) {
                this.visit((Procedure)record);
                continue;
            }
            if (!(record instanceof FunctionMethod)) continue;
            this.visit((FunctionMethod)record);
        }
    }

    private boolean shouldInclude(AbstractMetadataRecord record) {
        return this.filter == null || this.filter.matcher(record.getName()).matches();
    }

    private void visit(Table table) {
        this.append("CREATE").append(" ");
        if (table.isPhysical()) {
            this.append("FOREIGN TABLE");
        } else if (table.getTableType() == Table.Type.TemporaryTable) {
            this.append("GLOBAL").append(" ").append("TEMPORARY").append(" ").append("TABLE");
        } else {
            this.append("VIEW");
        }
        this.append(" ");
        String name = this.addTableBody(table);
        if (table.getTableType() != Table.Type.TemporaryTable) {
            if (table.isVirtual()) {
                this.append(NEWLINE).append("AS").append(NEWLINE).append(table.getSelectTransformation());
            }
            this.append(";");
            if (table.isInsertPlanEnabled()) {
                this.buildTrigger(name, null, "INSERT", table.getInsertPlan(), false);
            }
            if (table.isUpdatePlanEnabled()) {
                this.buildTrigger(name, null, "UPDATE", table.getUpdatePlan(), false);
            }
            if (table.isDeletePlanEnabled()) {
                this.buildTrigger(name, null, "DELETE", table.getDeletePlan(), false);
            }
            for (Trigger tr : table.getTriggers().values()) {
                String generated = tr.getProperty(GENERATED, false);
                if (generated != null && Boolean.valueOf(generated).booleanValue()) continue;
                this.buildTrigger(name, tr.getName(), tr.getEvent().name(), tr.getPlan(), tr.isAfter());
            }
        } else {
            this.append(";");
        }
    }

    public String addTableBody(Table table) {
        String options;
        String name = SQLStringVisitor.escapeSinglePart(table.getName());
        this.append(name);
        if (table.getColumns() != null) {
            this.append(" ");
            this.append("(");
            boolean first = true;
            for (Column c : table.getColumns()) {
                if (first) {
                    first = false;
                } else {
                    this.append(",");
                }
                this.visit(table, c);
            }
            this.buildContraints(table);
            this.append(NEWLINE);
            this.append(")");
        }
        if (!(options = this.buildTableOptions(table)).isEmpty()) {
            this.append(" ").append("OPTIONS").append(" ").append("(").append(options).append(")");
        }
        return name;
    }

    protected DDLStringVisitor append(Object o) {
        this.buffer.append(o);
        return this;
    }

    private void buildTrigger(String name, String trigger_name, String type, String plan, boolean isAfter) {
        this.append(NEWLINE);
        this.append(NEWLINE);
        this.append("CREATE").append(" ").append("TRIGGER").append(" ");
        if (trigger_name != null) {
            this.append(SQLStringVisitor.escapeSinglePart(trigger_name)).append(" ");
        }
        this.append("ON").append(" ").append(name).append(" ");
        if (isAfter) {
            this.append("AFTER");
        } else {
            this.append("INSTEAD OF");
        }
        this.append(" ").append(type).append(" ").append("AS").append(NEWLINE);
        this.append(plan);
        this.append(";");
    }

    private String buildTableOptions(Table table) {
        StringBuilder options = new StringBuilder();
        this.addCommonOptions(options, (AbstractMetadataRecord)table);
        if (table.isMaterialized()) {
            this.addOption(options, "MATERIALIZED", table.isMaterialized());
            if (table.getMaterializedTable() != null) {
                this.addOption(options, "MATERIALIZED_TABLE", table.getMaterializedTable().getName());
            }
        }
        if (table.supportsUpdate()) {
            this.addOption(options, "UPDATABLE", table.supportsUpdate());
        }
        if (table.getCardinality() != -1) {
            if ((float)table.getCardinality() != table.getCardinalityAsFloat()) {
                this.addOption(options, "CARDINALITY", (long)table.getCardinalityAsFloat());
            } else {
                this.addOption(options, "CARDINALITY", table.getCardinality());
            }
        }
        if (!table.getProperties().isEmpty()) {
            for (String key : table.getProperties().keySet()) {
                this.addOption(options, key, table.getProperty(key, false));
            }
        }
        return options.toString();
    }

    private void addCommonOptions(StringBuilder sb, AbstractMetadataRecord record) {
        if (record.isUUIDSet() && record.getUUID() != null && !record.getUUID().startsWith("tid:")) {
            this.addOption(sb, "UUID", record.getUUID());
        }
        if (record.getAnnotation() != null) {
            this.addOption(sb, "ANNOTATION", record.getAnnotation());
        }
        if (record.getNameInSource() != null) {
            this.addOption(sb, "NAMEINSOURCE", record.getNameInSource());
        }
    }

    private void buildContraints(Table table) {
        this.addConstraints(table.getAccessPatterns(), "AP", "ACCESSPATTERN");
        KeyRecord pk = table.getPrimaryKey();
        if (pk != null) {
            this.addConstraint("PK", "PRIMARY KEY", pk, true);
        }
        this.addConstraints(table.getUniqueKeys(), "UNIQUE", "UNIQUE");
        this.addConstraints(table.getIndexes(), "INDEX", "INDEX");
        this.addConstraints(table.getFunctionBasedIndexes(), "INDEX", "INDEX");
        for (int i = 0; i < table.getForeignKeys().size(); ++i) {
            ForeignKey key = (ForeignKey)table.getForeignKeys().get(i);
            if (key.getReferenceKey() != null && !this.shouldInclude(key.getReferenceKey().getParent())) continue;
            this.addConstraint("FK" + i, "FOREIGN KEY", (KeyRecord)key, false);
            this.append(" ").append("REFERENCES");
            if (key.getReferenceKey() != null) {
                if (((Schema)((Table)key.getReferenceKey().getParent()).getParent()).equals((Object)((Table)key.getParent()).getParent())) {
                    this.append(" ").append(new GroupSymbol(((Table)key.getReferenceKey().getParent()).getName()));
                } else {
                    this.append(" ").append(new GroupSymbol(((Table)key.getReferenceKey().getParent()).getFullName()));
                }
            } else if (key.getReferenceTableName() != null) {
                this.append(" ").append(new GroupSymbol(key.getReferenceTableName()));
            }
            this.append(" ");
            this.addNames(key.getReferenceColumns());
            this.appendOptions((AbstractMetadataRecord)key);
        }
    }

    private void addConstraints(List<KeyRecord> constraints, String defaultName, String type) {
        for (int i = 0; i < constraints.size(); ++i) {
            KeyRecord constraint = constraints.get(i);
            this.addConstraint(defaultName + i, type, constraint, true);
        }
    }

    private void addConstraint(String defaultName, String type, KeyRecord constraint, boolean addOptions) {
        this.append(",").append(NEWLINE).append(TAB);
        boolean nameMatches = defaultName.equals(constraint.getName());
        if (!nameMatches) {
            this.append("CONSTRAINT").append(" ").append(SQLStringVisitor.escapeSinglePart(constraint.getName())).append(" ");
        }
        this.append(type);
        this.addColumns(constraint.getColumns(), false);
        if (addOptions) {
            this.appendOptions((AbstractMetadataRecord)constraint);
        }
    }

    private void addColumns(List<Column> columns, boolean includeType) {
        this.append("(");
        boolean first = true;
        for (Column c : columns) {
            if (first) {
                first = false;
            } else {
                this.append(",").append(" ");
            }
            if (includeType) {
                this.appendColumn((BaseColumn)c, true, includeType);
                this.appendColumnOptions((BaseColumn)c);
                continue;
            }
            if (c.getParent() instanceof KeyRecord) {
                this.append(c.getNameInSource());
                continue;
            }
            this.append(SQLStringVisitor.escapeSinglePart(c.getName()));
        }
        this.append(")");
    }

    private void addNames(List<String> columns) {
        if (columns != null) {
            this.append("(");
            boolean first = true;
            for (String c : columns) {
                if (first) {
                    first = false;
                } else {
                    this.append(",").append(" ");
                }
                this.append(SQLStringVisitor.escapeSinglePart(c));
            }
            this.append(")");
        }
    }

    private void visit(Table table, Column column) {
        this.append(NEWLINE).append(TAB);
        if (table.getTableType() == Table.Type.TemporaryTable && column.isAutoIncremented() && column.getNullType() == BaseColumn.NullType.No_Nulls && column.getJavaType() == DataTypeManager.DefaultDataClasses.INTEGER) {
            this.append(SQLStringVisitor.escapeSinglePart(column.getName()));
            this.append(" ");
            this.append("SERIAL");
        } else {
            this.appendColumn((BaseColumn)column, true, !table.isVirtual() || Boolean.valueOf(column.getProperty("teiid_internal:untyped", false)) == false);
            if (column.isAutoIncremented()) {
                this.append(" ").append("AUTO_INCREMENT");
            }
        }
        this.appendDefault((BaseColumn)column);
        this.appendColumnOptions((BaseColumn)column);
    }

    private void appendDefault(BaseColumn column) {
        if (column.getDefaultValue() != null) {
            this.append(" ").append("DEFAULT").append(" ");
            if ("expression".equalsIgnoreCase(column.getProperty("teiid_rel:default_handling", false))) {
                this.append(column.getDefaultValue());
            } else {
                this.append(new Constant(column.getDefaultValue()));
            }
        }
    }

    private void appendColumn(BaseColumn column, boolean includeName, boolean includeType) {
        if (includeName) {
            this.append(SQLStringVisitor.escapeSinglePart(column.getName()));
        }
        if (includeType) {
            Datatype datatype = column.getDatatype();
            String runtimeTypeName = column.getRuntimeType();
            boolean domain = false;
            if (datatype != null) {
                runtimeTypeName = datatype.getRuntimeTypeName();
                boolean bl = domain = datatype.getType() == Datatype.Type.Domain;
            }
            if (includeName) {
                this.append(" ");
            }
            if (domain) {
                this.append(datatype.getName());
            } else {
                this.append(runtimeTypeName);
                if (DataTypeManager.hasLength((String)runtimeTypeName)) {
                    if (column.getLength() != 0 && (datatype == null || column.getLength() != datatype.getLength())) {
                        this.append("(").append(column.getLength()).append(")");
                    }
                } else if (PRECISION_DATATYPES.contains(runtimeTypeName) && !column.isDefaultPrecisionScale()) {
                    this.append("(").append(column.getPrecision());
                    if (column.getScale() != 0) {
                        this.append(",").append(column.getScale());
                    }
                    this.append(")");
                } else if (runtimeTypeName.equals("timestamp") && !column.isDefaultPrecisionScale()) {
                    this.append("(");
                    this.append(column.getScale());
                    this.append(")");
                }
            }
            if (datatype != null) {
                for (int dims = column.getArrayDimensions(); dims > 0; --dims) {
                    this.append("[").append("]");
                }
            }
            if (!(column.getNullType() != BaseColumn.NullType.No_Nulls || domain && datatype.getNullType() == BaseColumn.NullType.No_Nulls)) {
                this.append(" ").append("NOT NULL");
            }
        }
    }

    private void appendColumnOptions(BaseColumn column) {
        StringBuilder options = new StringBuilder();
        this.addCommonOptions(options, (AbstractMetadataRecord)column);
        if (!column.getDatatype().isBuiltin() && column.getDatatype().getType() != Datatype.Type.Domain) {
            this.addOption(options, "UDT", column.getDatatype().getName() + "(" + column.getLength() + ", " + column.getPrecision() + ", " + column.getScale() + ")");
        }
        if (column.getDatatype().getRadix() != 0 && column.getRadix() != column.getDatatype().getRadix()) {
            this.addOption(options, "RADIX", column.getRadix());
        }
        this.buildColumnOptions(column, options);
        if (options.length() != 0) {
            this.append(" ").append("OPTIONS").append(" ").append("(").append(options).append(")");
        }
    }

    private void buildColumnOptions(BaseColumn baseColumn, StringBuilder options) {
        if (baseColumn instanceof Column) {
            Column column = (Column)baseColumn;
            if (!column.isSelectable()) {
                this.addOption(options, "SELECTABLE", column.isSelectable());
            }
            if (!column.isUpdatable() && column.getParent() instanceof Table && ((Table)column.getParent()).supportsUpdate()) {
                this.addOption(options, "UPDATABLE", column.isUpdatable());
            }
            if (column.isCurrency()) {
                this.addOption(options, "CURRENCY", column.isCurrency());
            }
            if (!column.isCaseSensitive() && column.getDatatype().isCaseSensitive()) {
                this.addOption(options, "CASE_SENSITIVE", column.isCaseSensitive());
            }
            if (!column.isSigned() && column.getDatatype().isSigned()) {
                this.addOption(options, "SIGNED", column.isSigned());
            }
            if (column.isFixedLength()) {
                this.addOption(options, "FIXED_LENGTH", column.isFixedLength());
            }
            if (column.getCharOctetLength() != 0 && column.getLength() != column.getCharOctetLength()) {
                this.addOption(options, "CHAR_OCTET_LENGTH", column.getCharOctetLength());
            }
            if (column.getSearchType() != null && (!column.getSearchType().equals((Object)column.getDatatype().getSearchType()) || column.isSearchTypeSet())) {
                this.addOption(options, "SEARCHABLE", column.getSearchType().name());
            }
            if (column.getMinimumValue() != null) {
                this.addOption(options, "MIN_VALUE", column.getMinimumValue());
            }
            if (column.getMaximumValue() != null) {
                this.addOption(options, "MAX_VALUE", column.getMaximumValue());
            }
            if (column.getNullValues() != -1) {
                this.addOption(options, "NULL_VALUE_COUNT", column.getNullValues());
            }
            if (column.getDistinctValues() != -1) {
                this.addOption(options, "DISTINCT_VALUES", column.getDistinctValues());
            }
        }
        if (baseColumn.getNativeType() != null) {
            this.addOption(options, "NATIVE_TYPE", baseColumn.getNativeType());
        }
        this.buildOptions((AbstractMetadataRecord)baseColumn, options);
    }

    private void appendOptions(AbstractMetadataRecord record) {
        StringBuilder options = new StringBuilder();
        this.addCommonOptions(options, record);
        this.buildOptions(record, options);
        if (options.length() != 0) {
            this.append(" ").append("OPTIONS").append(" ").append("(").append(options).append(")");
        }
    }

    private void buildOptions(AbstractMetadataRecord record, StringBuilder options) {
        if (!record.getProperties().isEmpty()) {
            for (Map.Entry entry : record.getProperties().entrySet()) {
                if (record instanceof Database && ((String)entry.getKey()).equals("full-ddl") || ((String)entry.getKey()).equals("teiid_internal:untyped")) continue;
                this.addOption(options, (String)entry.getKey(), entry.getValue());
            }
        }
    }

    private void addOption(StringBuilder sb, String key, Object value) {
        if (sb.length() != 0) {
            sb.append(",").append(" ");
        }
        value = value != null ? new Constant(value) : Constant.NULL_CONSTANT;
        sb.append(SQLStringVisitor.escapeSinglePart(key)).append(" ").append(value);
    }

    private void visit(Procedure procedure) {
        String options;
        this.append("CREATE").append(" ");
        if (procedure.isVirtual()) {
            this.append("VIRTUAL");
        } else {
            this.append("FOREIGN");
        }
        this.append(" ").append(procedure.isFunction() ? "FUNCTION" : "PROCEDURE").append(" ").append(SQLStringVisitor.escapeSinglePart(procedure.getName()));
        this.append("(");
        boolean first = true;
        for (ProcedureParameter pp : procedure.getParameters()) {
            if (first) {
                first = false;
            } else {
                this.append(",").append(" ");
            }
            this.visit(pp);
        }
        this.append(")");
        if (procedure.getResultSet() != null) {
            this.append(" ").append("RETURNS");
            this.appendOptions((AbstractMetadataRecord)procedure.getResultSet());
            this.append(" ").append("TABLE").append(" ");
            this.addColumns(procedure.getResultSet().getColumns(), true);
        }
        if (!(options = this.buildProcedureOptions(procedure)).isEmpty()) {
            this.append(NEWLINE).append("OPTIONS").append(" ").append("(").append(options).append(")");
        }
        if (procedure.isVirtual()) {
            this.append(NEWLINE).append("AS").append(NEWLINE);
            String plan = procedure.getQueryPlan();
            this.append(plan);
        }
        this.append(";");
    }

    private String buildProcedureOptions(Procedure procedure) {
        StringBuilder options = new StringBuilder();
        this.addCommonOptions(options, (AbstractMetadataRecord)procedure);
        if (procedure.getUpdateCount() != -1) {
            this.addOption(options, "UPDATECOUNT", procedure.getUpdateCount());
        }
        if (!procedure.getProperties().isEmpty()) {
            for (String key : procedure.getProperties().keySet()) {
                this.addOption(options, key, procedure.getProperty(key, false));
            }
        }
        return options.toString();
    }

    private void visit(ProcedureParameter param) {
        ProcedureParameter.Type type = param.getType();
        String typeStr = null;
        switch (type) {
            case InOut: {
                typeStr = "INOUT";
                break;
            }
            case ReturnValue: 
            case Out: {
                typeStr = "OUT";
                break;
            }
            case In: {
                typeStr = param.isVarArg() ? "VARIADIC" : "IN";
            }
        }
        this.append(typeStr).append(" ");
        this.appendColumn((BaseColumn)param, true, true);
        if (type == ProcedureParameter.Type.ReturnValue) {
            this.append(" ").append("RESULT");
        }
        this.appendDefault((BaseColumn)param);
        this.appendColumnOptions((BaseColumn)param);
    }

    private void visit(FunctionMethod function) {
        this.append("CREATE").append(" ");
        if (function.getPushdown().equals((Object)FunctionMethod.PushDown.MUST_PUSHDOWN)) {
            this.append("FOREIGN");
        } else {
            this.append("VIRTUAL");
        }
        this.append(" ").append("FUNCTION").append(" ").append(SQLStringVisitor.escapeSinglePart(function.getName()));
        this.append("(");
        boolean first = true;
        for (FunctionParameter fp : function.getInputParameters()) {
            if (first) {
                first = false;
            } else {
                this.append(",").append(" ");
            }
            this.visit(fp);
        }
        this.append(")");
        this.append(" ").append("RETURNS");
        this.appendOptions((AbstractMetadataRecord)function.getOutputParameter());
        this.append(" ");
        this.append(function.getOutputParameter().getType());
        String options = this.buildFunctionOptions(function);
        if (!options.isEmpty()) {
            this.append(NEWLINE).append("OPTIONS").append(" ").append("(").append(options).append(")");
        }
        this.append(";");
    }

    private String buildFunctionOptions(FunctionMethod function) {
        StringBuilder options = new StringBuilder();
        this.addCommonOptions(options, (AbstractMetadataRecord)function);
        if (function.getCategory() != null) {
            this.addOption(options, "CATEGORY", function.getCategory());
        }
        if (!function.getDeterminism().equals((Object)FunctionMethod.Determinism.DETERMINISTIC)) {
            this.addOption(options, "DETERMINISM", function.getDeterminism().name());
        }
        if (function.getInvocationClass() != null) {
            this.addOption(options, "JAVA_CLASS", function.getInvocationClass());
        }
        if (function.getInvocationMethod() != null) {
            this.addOption(options, "JAVA_METHOD", function.getInvocationMethod());
        }
        if (!function.getProperties().isEmpty()) {
            for (String key : function.getProperties().keySet()) {
                this.addOption(options, key, function.getProperty(key, false));
            }
        }
        return options.toString();
    }

    private void visit(FunctionParameter param) {
        if (param.isVarArg()) {
            this.append("VARIADIC").append(" ");
        }
        this.appendColumn((BaseColumn)param, true, true);
    }

    public String toString() {
        return this.buffer.toString();
    }

    public static String getDomainDDLString(Database database) {
        DDLStringVisitor visitor = new DDLStringVisitor(null, null);
        for (Datatype dt : database.getMetadataStore().getDatatypes().values()) {
            if (dt.getType() != Datatype.Type.Domain) continue;
            visitor.visit(dt);
            visitor.append(" ");
        }
        return visitor.toString();
    }
}

