/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.impl.TransactionMetadata;
import org.teiid.client.xa.XATransactionException;
import org.teiid.client.xa.XidImpl;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.Assertion;
import org.teiid.dqp.service.TransactionContext;
import org.teiid.dqp.service.TransactionService;
import org.teiid.query.QueryPlugin;
import org.teiid.resource.api.XAImporter;

public class TransactionServerImpl
implements TransactionService {
    protected TransactionMapping transactions = new TransactionMapping();
    protected TransactionManager transactionManager;
    private boolean detectTransactions;
    private XAImporter xaImporter;

    public void setDetectTransactions(boolean detectTransactions) {
        this.detectTransactions = detectTransactions;
    }

    public boolean isDetectTransactions() {
        return this.detectTransactions;
    }

    public void setXaImporter(XAImporter xaImporter) {
        this.xaImporter = xaImporter;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public int prepare(String threadId, XidImpl xid, boolean singleTM) throws XATransactionException {
        TransactionContext tc = this.checkXAState(threadId, xid, true, false);
        if (!tc.getSuspendedBy().isEmpty()) {
            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30505, -6, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30505, new Object[]{xid}));
        }
        if (singleTM) {
            return 3;
        }
        try {
            return this.xaImporter.prepare(tc.getXid());
        }
        catch (XAException e) {
            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30506, (Throwable)e);
        }
    }

    @Override
    public void commit(String threadId, XidImpl xid, boolean onePhase, boolean singleTM) throws XATransactionException {
        TransactionContext tc = this.checkXAState(threadId, xid, true, false);
        try {
            if (singleTM || onePhase && 3 == this.prepare(threadId, xid, singleTM)) {
                return;
            }
            this.xaImporter.commit(tc.getXid(), false);
        }
        catch (XAException e) {
            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30507, (Throwable)e);
        }
        finally {
            this.transactions.removeTransactionContext(tc);
        }
    }

    @Override
    public void rollback(String threadId, XidImpl xid, boolean singleTM) throws XATransactionException {
        TransactionContext tc = this.checkXAState(threadId, xid, true, false);
        try {
            if (!singleTM) {
                this.xaImporter.rollback(tc.getXid());
            }
        }
        catch (XAException e) {
            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30508, (Throwable)e);
        }
        finally {
            this.transactions.removeTransactionContext(tc);
        }
    }

    @Override
    public Xid[] recover(int flag, boolean singleTM) throws XATransactionException {
        if (singleTM) {
            return new Xid[0];
        }
        try {
            return this.xaImporter.recover(flag);
        }
        catch (XAException e) {
            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30509, (Throwable)e);
        }
    }

    @Override
    public void forget(String threadId, XidImpl xid, boolean singleTM) throws XATransactionException {
        TransactionContext tc = this.checkXAState(threadId, xid, true, false);
        try {
            if (singleTM) {
                return;
            }
            this.xaImporter.forget((Xid)xid);
        }
        catch (XAException err) {
            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30510, (Throwable)err);
        }
        finally {
            this.transactions.removeTransactionContext(tc);
        }
    }

    @Override
    public void start(String threadId, XidImpl xid, int flags, int timeout, boolean singleTM) throws XATransactionException {
        TransactionContext tc = null;
        switch (flags) {
            case 0: {
                try {
                    this.checkXAState(threadId, xid, false, false);
                    tc = this.transactions.getOrCreateTransactionContext(threadId);
                    if (tc.getTransactionType() != TransactionContext.Scope.NONE) {
                        throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30517, -6, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30517, new Object[0]));
                    }
                    tc.setXid((Xid)xid);
                    if (singleTM) {
                        tc.setTransaction(this.transactionManager.getTransaction());
                        if (tc.getTransaction() == null) {
                            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30590, -5, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30590, new Object[0]));
                        }
                    } else {
                        Transaction txn = this.xaImporter.importTransaction(this.transactionManager, (Xid)xid, timeout);
                        tc.setTransaction(txn);
                    }
                    tc.setTransactionType(TransactionContext.Scope.GLOBAL);
                    break;
                }
                catch (XAException e) {
                    throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30512, -5, (Throwable)e);
                }
                catch (SystemException e) {
                    throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30512, -5, (Throwable)e);
                }
            }
            case 0x200000: 
            case 0x8000000: {
                tc = this.checkXAState(threadId, xid, true, false);
                TransactionContext threadContext = this.transactions.getOrCreateTransactionContext(threadId);
                if (threadContext.getTransactionType() != TransactionContext.Scope.NONE) {
                    throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30517, -6, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30517, new Object[0]));
                }
                if (flags != 0x8000000 || tc.getSuspendedBy().remove(threadId)) break;
                throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30518, -6, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30518, new Object[]{xid, threadId}));
            }
            default: {
                throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30519, -5, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30519, new Object[0]));
            }
        }
        tc.setThreadId(threadId);
        this.transactions.addTransactionContext(tc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void end(String threadId, XidImpl xid, int flags, boolean singleTM) throws XATransactionException {
        TransactionContext tc = this.checkXAState(threadId, xid, true, true);
        try {
            switch (flags) {
                case 0x2000000: {
                    tc.getSuspendedBy().add(threadId);
                    return;
                }
                case 0x4000000: {
                    return;
                }
                case 0x20000000: {
                    this.cancelTransactions(threadId, false);
                    return;
                }
                default: {
                    throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30520, -5, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30520, new Object[0]));
                }
            }
        }
        finally {
            tc.setThreadId(null);
            this.transactions.removeTransactionContext(threadId);
        }
    }

    private TransactionContext checkXAState(String threadId, XidImpl xid, boolean transactionExpected, boolean threadBound) throws XATransactionException {
        TransactionContext tc = this.transactions.getTransactionContext(xid);
        if (transactionExpected && tc == null) {
            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30521, -4, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30521, new Object[]{xid}));
        }
        if (!transactionExpected) {
            if (tc != null) {
                throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30522, -8, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30522, new Object[]{xid}));
            }
            if (!threadBound && (tc = this.transactions.getOrCreateTransactionContext(threadId)).getTransactionType() != TransactionContext.Scope.NONE) {
                throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30517, -6, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30517, new Object[0]));
            }
            return null;
        }
        if (threadBound) {
            if (!threadId.equals(tc.getThreadId())) {
                throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30524, -6, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30524, new Object[]{xid}));
            }
        } else if (tc.getThreadId() != null) {
            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30525, -6, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30525, new Object[]{xid}));
        }
        return tc;
    }

    private TransactionContext checkLocalTransactionState(String threadId, boolean transactionExpected) throws XATransactionException {
        TransactionContext tc = this.transactions.getOrCreateTransactionContext(threadId);
        if (!transactionExpected && this.detectTransactions) {
            try {
                Transaction tx = this.transactionManager.getTransaction();
                if (tx != null && tx != tc.getTransaction()) {
                    throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30517, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30517, new Object[0]));
                }
            }
            catch (SystemException tx) {
            }
            catch (IllegalStateException tx) {
                // empty catch block
            }
        }
        try {
            if (tc.getTransactionType() != TransactionContext.Scope.NONE) {
                if (tc.getTransactionType() != TransactionContext.Scope.LOCAL || !transactionExpected) {
                    throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30517, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30517, new Object[0]));
                }
                this.transactionManager.resume(tc.getTransaction());
            } else if (transactionExpected) {
                throw new InvalidTransactionException(QueryPlugin.Util.getString("TransactionServer.no_transaction", new Object[]{threadId}));
            }
        }
        catch (InvalidTransactionException e) {
            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30526, (Throwable)e);
        }
        catch (SystemException e) {
            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30527, (Throwable)e);
        }
        return tc;
    }

    private void beginDirect(TransactionContext tc) throws XATransactionException {
        try {
            this.transactionManager.begin();
            Transaction tx = this.transactionManager.suspend();
            tc.setTransaction(tx);
            tc.setCreationTime(System.currentTimeMillis());
        }
        catch (NotSupportedException err) {
            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30528, (Throwable)err);
        }
        catch (SystemException err) {
            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30528, (Throwable)err);
        }
    }

    private void commitDirect(TransactionContext context) throws XATransactionException {
        try {
            this.transactionManager.commit();
        }
        catch (SecurityException e) {
            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30530, (Throwable)e);
        }
        catch (RollbackException e) {
            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30530, (Throwable)e);
        }
        catch (HeuristicMixedException e) {
            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30530, (Throwable)e);
        }
        catch (HeuristicRollbackException e) {
            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30530, (Throwable)e);
        }
        catch (SystemException e) {
            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30530, (Throwable)e);
        }
        finally {
            this.transactions.removeTransactionContext(context);
        }
    }

    private void rollbackDirect(TransactionContext tc) throws XATransactionException {
        try {
            this.transactionManager.rollback();
        }
        catch (SecurityException e) {
            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30535, (Throwable)e);
        }
        catch (SystemException e) {
            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30535, (Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30535, (Throwable)e);
        }
        finally {
            this.transactions.removeTransactionContext(tc);
        }
    }

    @Override
    public void suspend(TransactionContext context) throws XATransactionException {
        try {
            this.transactionManager.suspend();
        }
        catch (SystemException e) {
            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30537, (Throwable)e);
        }
    }

    @Override
    public void resume(TransactionContext context) throws XATransactionException {
        try {
            if (this.transactionManager.getTransaction() == context.getTransaction()) {
                return;
            }
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        try {
            this.transactionManager.resume(context.getTransaction());
        }
        catch (IllegalStateException e) {
            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30538, (Throwable)e);
        }
        catch (InvalidTransactionException e) {
            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30538, (Throwable)e);
        }
        catch (SystemException e) {
            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30538, (Throwable)e);
        }
    }

    @Override
    public TransactionContext begin(String threadId) throws XATransactionException {
        TransactionContext tc = this.checkLocalTransactionState(threadId, false);
        this.beginDirect(tc);
        tc.setTransactionType(TransactionContext.Scope.LOCAL);
        return tc;
    }

    @Override
    public void commit(String threadId) throws XATransactionException {
        TransactionContext tc = this.checkLocalTransactionState(threadId, true);
        this.commitDirect(tc);
    }

    @Override
    public void rollback(String threadId) throws XATransactionException {
        TransactionContext tc = this.checkLocalTransactionState(threadId, true);
        this.rollbackDirect(tc);
    }

    @Override
    public TransactionContext getOrCreateTransactionContext(final String threadId) {
        TransactionContext tc = this.transactions.getOrCreateTransactionContext(threadId);
        if (this.detectTransactions) {
            try {
                Transaction tx = this.transactionManager.getTransaction();
                if (tx != null && tx != tc.getTransaction()) {
                    tx.registerSynchronization(new Synchronization(){

                        public void beforeCompletion() {
                        }

                        public void afterCompletion(int status) {
                            TransactionServerImpl.this.transactions.removeTransactionContext(threadId);
                        }
                    });
                    tc.setTransaction(tx);
                    tc.setTransactionType(TransactionContext.Scope.INHERITED);
                }
            }
            catch (SystemException systemException) {
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (RollbackException rollbackException) {
                // empty catch block
            }
        }
        return tc;
    }

    @Override
    public void begin(TransactionContext context) throws XATransactionException {
        if (context.getTransactionType() != TransactionContext.Scope.NONE) {
            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30517, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30517, new Object[0]));
        }
        this.beginDirect(context);
        context.setTransactionType(TransactionContext.Scope.REQUEST);
        this.transactions.addTransactionContext(context);
    }

    @Override
    public void commit(TransactionContext context) throws XATransactionException {
        Assertion.assertTrue((context.getTransactionType() == TransactionContext.Scope.REQUEST ? 1 : 0) != 0);
        try {
            this.commitDirect(context);
        }
        finally {
            context.setTransaction(null);
            context.setTransactionType(TransactionContext.Scope.NONE);
        }
    }

    @Override
    public void rollback(TransactionContext context) throws XATransactionException {
        Assertion.assertTrue((context.getTransactionType() == TransactionContext.Scope.REQUEST ? 1 : 0) != 0);
        try {
            this.rollbackDirect(context);
        }
        finally {
            context.setTransaction(null);
            context.setTransactionType(TransactionContext.Scope.NONE);
        }
    }

    @Override
    public void cancelTransactions(String threadId, boolean requestOnly) throws XATransactionException {
        TransactionContext tc;
        TransactionContext transactionContext = tc = requestOnly ? this.transactions.getTransactionContext(threadId) : this.transactions.removeTransactionContext(threadId);
        if (tc == null || tc.getTransactionType() == TransactionContext.Scope.NONE || tc.getTransactionType() == TransactionContext.Scope.INHERITED || requestOnly && tc.getTransactionType() != TransactionContext.Scope.REQUEST) {
            return;
        }
        try {
            Transaction t = tc.getTransaction();
            if (t != null) {
                t.setRollbackOnly();
            }
        }
        catch (SystemException e) {
            throw new XATransactionException((BundleUtil.Event)QueryPlugin.Event.TEIID30541, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<TransactionMetadata> getTransactions() {
        Set<TransactionContext> txnSet = Collections.newSetFromMap(new IdentityHashMap());
        TransactionMapping transactionMapping = this.transactions;
        synchronized (transactionMapping) {
            txnSet.addAll(this.transactions.threadToTransactionContext.values());
            txnSet.addAll(this.transactions.xidToTransactionContext.values());
        }
        ArrayList<TransactionMetadata> result = new ArrayList<TransactionMetadata>(txnSet.size());
        for (TransactionContext transactionContext : txnSet) {
            if (transactionContext.getTransactionType() == TransactionContext.Scope.NONE) continue;
            TransactionMetadata txnImpl = new TransactionMetadata();
            txnImpl.setAssociatedSession(transactionContext.getThreadId());
            txnImpl.setCreatedTime(transactionContext.getCreationTime());
            txnImpl.setScope(transactionContext.getTransactionType().toString());
            txnImpl.setId(transactionContext.getTransactionId());
            result.add(txnImpl);
        }
        return result;
    }

    @Override
    public void terminateTransaction(String threadId) throws AdminException {
        if (threadId == null) {
            return;
        }
        try {
            this.cancelTransactions(threadId, false);
        }
        catch (XATransactionException e) {
            throw new AdminProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30542, (Throwable)e);
        }
    }

    protected static class TransactionMapping {
        private Map<String, TransactionContext> threadToTransactionContext = new HashMap<String, TransactionContext>();
        private Map<Xid, TransactionContext> xidToTransactionContext = new HashMap<Xid, TransactionContext>();

        protected TransactionMapping() {
        }

        public synchronized TransactionContext getOrCreateTransactionContext(String threadId) {
            TransactionContext tc = this.threadToTransactionContext.get(threadId);
            if (tc == null) {
                tc = new TransactionContext();
                tc.setThreadId(threadId);
                this.threadToTransactionContext.put(threadId, tc);
            }
            return tc;
        }

        public synchronized TransactionContext getTransactionContext(String threadId) {
            return this.threadToTransactionContext.get(threadId);
        }

        public synchronized TransactionContext getTransactionContext(XidImpl xid) {
            return this.xidToTransactionContext.get(xid);
        }

        public synchronized TransactionContext removeTransactionContext(String threadId) {
            return this.threadToTransactionContext.remove(threadId);
        }

        public synchronized void removeTransactionContext(TransactionContext tc) {
            if (tc.getXid() != null) {
                this.xidToTransactionContext.remove(tc.getXid());
            }
            if (tc.getThreadId() != null) {
                this.threadToTransactionContext.remove(tc.getThreadId());
            }
        }

        public synchronized void addTransactionContext(TransactionContext tc) {
            if (tc.getXid() != null) {
                this.xidToTransactionContext.put(tc.getXid(), tc);
            }
            if (tc.getThreadId() != null) {
                this.threadToTransactionContext.put(tc.getThreadId(), tc);
            }
        }
    }
}

