/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.sql.Clob;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.XMLType;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.sql.lang.ExplainCommand;
import org.teiid.query.util.CommandContext;

public class ExplainProcessPlan
extends ProcessorPlan {
    private ExplainCommand explainCommand;
    private ProcessorPlan actualPlan;

    public ExplainProcessPlan(ProcessorPlan actualPlan, ExplainCommand explainCommand) {
        this.actualPlan = actualPlan;
        this.explainCommand = explainCommand;
    }

    @Override
    public void initialize(CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        super.initialize(context, dataMgr, bufferMgr);
        this.actualPlan.initialize(context, dataMgr, bufferMgr);
    }

    @Override
    public List getOutputElements() {
        return this.explainCommand.getProjectedSymbols();
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        if (!this.explainCommand.isNoExec()) {
            this.actualPlan.open();
        }
    }

    @Override
    public TupleBatch nextBatch() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        Object result;
        TupleBatch batch;
        while (!this.explainCommand.isNoExec() && !(batch = this.actualPlan.nextBatch()).getTerminationFlag()) {
        }
        RequestWorkItem workItem = this.getContext().getWorkItem();
        PlanNode planNode = workItem.getQueryPlan();
        ExplainCommand.Format format = ExplainCommand.Format.TEXT;
        if (this.explainCommand.getFormat() != null) {
            format = this.explainCommand.getFormat();
        }
        ArrayList<Object> row = new ArrayList<Object>(1);
        switch (format) {
            case TEXT: {
                result = planNode.toString();
                row.add(new ClobType((Clob)new ClobImpl((String)result)));
                break;
            }
            case YAML: {
                String yaml = planNode.toYaml();
                row.add(new ClobType((Clob)new ClobImpl(yaml)));
                break;
            }
            case XML: {
                String xml = planNode.toXml();
                row.add(new XMLType((SQLXML)new SQLXMLImpl(xml)));
                break;
            }
            default: {
                throw new AssertionError((Object)"format not implemented");
            }
        }
        result = new TupleBatch(1L, Arrays.asList(row));
        ((TupleBatch)result).setTerminationFlag(true);
        return result;
    }

    @Override
    public void close() throws TeiidComponentException {
        if (!this.explainCommand.isNoExec()) {
            this.actualPlan.close();
        }
    }

    @Override
    public ProcessorPlan clone() {
        ExplainProcessPlan clone = new ExplainProcessPlan(this.actualPlan.clone(), this.explainCommand);
        return clone;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        return this.actualPlan.getDescriptionProperties();
    }

    @Override
    public void reset() {
        this.actualPlan.reset();
    }

    public String toString() {
        return "EXPLAIN " + this.actualPlan.toString();
    }
}

