/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.teiid.CommandContext;
import org.teiid.PolicyDecider;
import org.teiid.adminapi.DataPolicy;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.dqp.internal.process.AuthorizationValidationVisitor;
import org.teiid.dqp.internal.process.AuthorizationValidator;
import org.teiid.dqp.internal.process.Request;
import org.teiid.dqp.internal.process.multisource.MultiSourceElement;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Schema;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.MultipleElementSymbol;

public class DefaultAuthorizationValidator
implements AuthorizationValidator {
    public static final String IGNORE_UNAUTHORIZED_ASTERISK = "ignore_unauthorized_asterisk";
    private PolicyDecider policyDecider;
    private boolean ignoreUnauthorizedAsteriskDefault = (Boolean)PropertiesUtils.getHierarchicalProperty((String)"org.teiid.ignoreUnauthorizedAsterisk", (Object)false, Boolean.class);
    private boolean metadataRequiresPermission = (Boolean)PropertiesUtils.getHierarchicalProperty((String)"org.teiid.metadataRequiresPermission", (Object)true, Boolean.class);

    public void setMetadataRequiresPermission(boolean metadataRequiresPermission) {
        this.metadataRequiresPermission = metadataRequiresPermission;
    }

    @Override
    public boolean validate(String[] originalSql, Command command, QueryMetadataInterface metadata, org.teiid.query.util.CommandContext commandContext, AuthorizationValidator.CommandType commandType) throws QueryValidatorException, TeiidComponentException {
        boolean modified = false;
        if (this.policyDecider != null && this.policyDecider.validateCommand((CommandContext)commandContext)) {
            if (this.ignoreUnathorizedInAsterisk(command, commandContext)) {
                Query query = (Query)command;
                HashMap<AbstractMetadataRecord, LanguageObject> map = null;
                for (Expression ex : query.getSelect().getSymbols()) {
                    if (!(ex instanceof MultipleElementSymbol)) continue;
                    MultipleElementSymbol mes = (MultipleElementSymbol)ex;
                    if (map == null) {
                        map = new HashMap<AbstractMetadataRecord, LanguageObject>();
                    }
                    Iterator<ElementSymbol> iter = mes.getElementSymbols().iterator();
                    while (iter.hasNext()) {
                        ElementSymbol es = iter.next();
                        Object metadataObject = es.getMetadataID();
                        if (metadataObject instanceof MultiSourceElement || metadataObject instanceof TempMetadataID) continue;
                        map.clear();
                        AuthorizationValidationVisitor.addToMap(metadataObject, es, map, commandContext.getMetadata());
                        Set results = this.policyDecider.getInaccessibleResources(DataPolicy.PermissionType.READ, map.keySet(), DataPolicy.Context.QUERY, (CommandContext)commandContext);
                        if (results.isEmpty()) continue;
                        iter.remove();
                        modified = true;
                    }
                }
                if (query.getProjectedSymbols().isEmpty()) {
                    throw new QueryValidatorException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31151, new Object[0]));
                }
            }
            AuthorizationValidationVisitor visitor = new AuthorizationValidationVisitor(this.policyDecider, commandContext);
            Request.validateWithVisitor(visitor, metadata, command);
        }
        return modified;
    }

    private boolean ignoreUnathorizedInAsterisk(Command command, org.teiid.query.util.CommandContext commandContext) {
        if (!(command instanceof Query)) {
            return false;
        }
        Query query = (Query)command;
        if (query.getInto() != null) {
            return false;
        }
        if (this.ignoreUnauthorizedAsteriskDefault) {
            return true;
        }
        Object value = commandContext.getSessionVariable(IGNORE_UNAUTHORIZED_ASTERISK);
        if (value != null) {
            try {
                return Boolean.TRUE.equals(DataTypeManager.transformValue((Object)value, (Class)DataTypeManager.DefaultDataClasses.BOOLEAN));
            }
            catch (TransformationException transformationException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean hasRole(String roleName, org.teiid.query.util.CommandContext commandContext) {
        if (this.policyDecider == null) {
            return true;
        }
        return this.policyDecider.hasRole(roleName, (CommandContext)commandContext);
    }

    public void setPolicyDecider(PolicyDecider policyDecider) {
        this.policyDecider = policyDecider;
    }

    @Override
    public boolean isAccessible(AbstractMetadataRecord record, org.teiid.query.util.CommandContext commandContext) {
        if (this.policyDecider == null || !this.policyDecider.validateCommand((CommandContext)commandContext)) {
            return true;
        }
        if (!this.metadataRequiresPermission) {
            return true;
        }
        AbstractMetadataRecord parent = record;
        while (parent.getParent() != null) {
            if (!((parent = parent.getParent()) instanceof Procedure)) continue;
            return true;
        }
        if (!(parent instanceof Schema) || "SYS".equalsIgnoreCase(parent.getName()) || "pg_catalog".equalsIgnoreCase(parent.getName())) {
            return true;
        }
        DataPolicy.PermissionType action = DataPolicy.PermissionType.READ;
        if (record instanceof FunctionMethod || record instanceof Procedure) {
            action = DataPolicy.PermissionType.EXECUTE;
        }
        HashSet<AbstractMetadataRecord> resources = new HashSet<AbstractMetadataRecord>(2);
        boolean result = false;
        if (record instanceof Schema) {
            Boolean cachedResult = commandContext.isAccessible(record);
            if (cachedResult != null) {
                return cachedResult;
            }
            Schema s = (Schema)record;
            if (s.getTables().entrySet().stream().anyMatch(e -> this.isAccessibleInternal((AbstractMetadataRecord)e.getValue(), commandContext, resources, DataPolicy.PermissionType.READ))) {
                result = true;
            } else if (s.getProcedures().entrySet().stream().anyMatch(e -> this.isAccessibleInternal((AbstractMetadataRecord)e.getValue(), commandContext, resources, DataPolicy.PermissionType.EXECUTE))) {
                result = true;
            } else if (s.getFunctions().entrySet().stream().anyMatch(e -> this.isAccessibleInternal((AbstractMetadataRecord)e.getValue(), commandContext, resources, DataPolicy.PermissionType.EXECUTE))) {
                result = true;
            }
        } else {
            result = this.isAccessibleInternal(record, commandContext, resources, action);
        }
        commandContext.setAccessible(record, result);
        return result;
    }

    private boolean isAccessibleInternal(AbstractMetadataRecord record, org.teiid.query.util.CommandContext commandContext, HashSet<AbstractMetadataRecord> resources, DataPolicy.PermissionType action) {
        Boolean result = commandContext.isAccessible(record);
        if (result != null) {
            return result;
        }
        resources.clear();
        resources.add(record);
        return this.policyDecider.getInaccessibleResources(action, resources, DataPolicy.Context.METADATA, (CommandContext)commandContext).isEmpty();
    }
}

