/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import io.opentracing.Tracer;
import io.opentracing.contrib.concurrent.TracedRunnable;
import java.util.Properties;
import org.teiid.PreParser;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.dqp.internal.process.AuthorizationValidator;
import org.teiid.dqp.internal.process.TeiidExecutor;
import org.teiid.dqp.internal.process.ThreadReuseExecutor;
import org.teiid.jdbc.tracing.GlobalTracerInjector;

public class DQPConfiguration {
    static final int DEFAULT_FETCH_SIZE = 20480;
    static final int DEFAULT_PROCESSOR_TIMESLICE = 2000;
    static final int DEFAULT_MAX_RESULTSET_CACHE_ENTRIES = 1024;
    static final int DEFAULT_QUERY_THRESHOLD = 600000;
    static final String PROCESS_PLAN_QUEUE_NAME = "QueryProcessorQueue";
    public static final int DEFAULT_MAX_PROCESS_WORKERS = 64;
    public static final int DEFAULT_MAX_SOURCE_ROWS = -1;
    public static final int DEFAULT_MAX_ACTIVE_PLANS = 20;
    public static final int DEFAULT_USER_REQUEST_SOURCE_CONCURRENCY = 0;
    public static final int DEFAULT_MAX_STALENESS_SECONDS = 0;
    private int maxThreads = 64;
    private int timeSliceInMilli = 2000;
    private int maxRowsFetchSize = 20480;
    private int lobChunkSizeInKB = 100;
    private long queryThresholdInMilli = 600000L;
    private boolean exceptionOnMaxSourceRows = true;
    private int maxSourceRows = -1;
    private int maxActivePlans = 20;
    private int userRequestSourceConcurrency = 0;
    private boolean detectingChangeEvents = true;
    private long queryTimeout;
    private transient AuthorizationValidator authorizationValidator;
    private transient PreParser preParser;
    private Properties properties = PropertiesUtils.getDefaultProperties();

    public int getMaxActivePlans() {
        return this.maxActivePlans;
    }

    public void setMaxActivePlans(int maxActivePlans) {
        this.maxActivePlans = maxActivePlans;
    }

    public int getUserRequestSourceConcurrency() {
        return this.userRequestSourceConcurrency;
    }

    public void setUserRequestSourceConcurrency(int userRequestSourceConcurrency) {
        this.userRequestSourceConcurrency = userRequestSourceConcurrency;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getTimeSliceInMilli() {
        return this.timeSliceInMilli;
    }

    public void setTimeSliceInMilli(int timeSliceInMilli) {
        this.timeSliceInMilli = timeSliceInMilli;
    }

    public int getMaxRowsFetchSize() {
        return this.maxRowsFetchSize;
    }

    public void setMaxRowsFetchSize(int maxRowsFetchSize) {
        this.maxRowsFetchSize = maxRowsFetchSize;
    }

    public int getLobChunkSizeInKB() {
        return this.lobChunkSizeInKB;
    }

    public void setLobChunkSizeInKB(int lobChunkSizeInKB) {
        this.lobChunkSizeInKB = lobChunkSizeInKB;
    }

    public int getQueryThresholdInSecs() {
        return (int)this.queryThresholdInMilli / 1000;
    }

    public long getQueryThresholdInMilli() {
        return this.queryThresholdInMilli;
    }

    public void setQueryThresholdInMilli(long queryThreshold) {
        this.queryThresholdInMilli = queryThreshold;
    }

    public void setQueryThresholdInSecs(int queryThresholdInSecs) {
        this.queryThresholdInMilli = queryThresholdInSecs * 1000;
    }

    public boolean isExceptionOnMaxSourceRows() {
        return this.exceptionOnMaxSourceRows;
    }

    public void setExceptionOnMaxSourceRows(boolean exceptionOnMaxSourceRows) {
        this.exceptionOnMaxSourceRows = exceptionOnMaxSourceRows;
    }

    public int getMaxSourceRows() {
        return this.maxSourceRows;
    }

    public void setMaxSourceRows(int maxSourceRows) {
        this.maxSourceRows = maxSourceRows;
    }

    public AuthorizationValidator getAuthorizationValidator() {
        return this.authorizationValidator;
    }

    public void setAuthorizationValidator(AuthorizationValidator authorizationValidator) {
        this.authorizationValidator = authorizationValidator;
    }

    public boolean isDetectingChangeEvents() {
        return this.detectingChangeEvents;
    }

    public void setDetectingChangeEvents(boolean detectingChangeEvents) {
        this.detectingChangeEvents = detectingChangeEvents;
    }

    public void setQueryTimeout(long queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public long getQueryTimeout() {
        return this.queryTimeout;
    }

    public TeiidExecutor getTeiidExecutor() {
        return new ThreadReuseExecutor(PROCESS_PLAN_QUEUE_NAME, this.getMaxThreads()){
            Tracer tracer;
            {
                this.tracer = GlobalTracerInjector.getTracer();
            }

            @Override
            public void execute(Runnable command) {
                super.execute(this.tracer.activeSpan() == null ? command : new TracedRunnable(command, this.tracer));
            }
        };
    }

    public void setPreParser(PreParser preParser) {
        this.preParser = preParser;
    }

    public PreParser getPreParser() {
        return this.preParser;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

