/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.teiid.CommandContext;
import org.teiid.PolicyDecider;
import org.teiid.adminapi.DataPolicy;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.dqp.internal.process.multisource.MultiSourceElement;
import org.teiid.logging.AuditMessage;
import org.teiid.logging.LogManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.AlterProcedure;
import org.teiid.query.sql.lang.AlterTrigger;
import org.teiid.query.sql.lang.AlterView;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.Drop;
import org.teiid.query.sql.lang.DynamicCommand;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Into;
import org.teiid.query.sql.lang.ObjectTable;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;
import org.teiid.query.validator.AbstractValidationVisitor;

public class AuthorizationValidationVisitor
extends AbstractValidationVisitor {
    private CommandContext commandContext;
    private PolicyDecider decider;

    public AuthorizationValidationVisitor(PolicyDecider decider, CommandContext commandContext) {
        this.decider = decider;
        this.commandContext = commandContext;
    }

    @Override
    public void visit(Create obj) {
        this.validateTemp(DataPolicy.PermissionType.CREATE, obj.getTable().getNonCorrelationName(), obj.getTable(), DataPolicy.Context.CREATE);
    }

    @Override
    public void visit(DynamicCommand obj) {
        if (obj.getIntoGroup() != null) {
            this.validateTemp(DataPolicy.PermissionType.CREATE, obj.getIntoGroup().getNonCorrelationName(), obj.getIntoGroup(), DataPolicy.Context.CREATE);
        }
    }

    @Override
    public void visit(AlterProcedure obj) {
        this.validateEntitlements(Arrays.asList(obj.getTarget()), DataPolicy.PermissionType.ALTER, DataPolicy.Context.ALTER);
    }

    @Override
    public void visit(AlterTrigger obj) {
        this.validateEntitlements(Arrays.asList(obj.getTarget()), DataPolicy.PermissionType.ALTER, obj.isCreate() ? DataPolicy.Context.CREATE : DataPolicy.Context.ALTER);
    }

    @Override
    public void visit(AlterView obj) {
        this.validateEntitlements(Arrays.asList(obj.getTarget()), DataPolicy.PermissionType.ALTER, DataPolicy.Context.ALTER);
    }

    @Override
    public void visit(ObjectTable objectTable) {
        String language = "teiid_script";
        if (objectTable.getScriptingLanguage() != null) {
            language = objectTable.getScriptingLanguage();
        }
        String[] resources = new String[]{language};
        this.logRequest(resources, DataPolicy.Context.QUERY);
        boolean result = this.decider.isLanguageAllowed(language, this.commandContext);
        this.logResult(resources, DataPolicy.Context.QUERY, result);
        if (!result) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.018.005.0095", new Object[]{this.commandContext.getUserName(), "LANGUAGE"}), Arrays.asList(objectTable));
        }
    }

    private void validateTemp(DataPolicy.PermissionType action, String resource, LanguageObject object, DataPolicy.Context context) {
        String[] resources = new String[]{resource};
        this.logRequest(resources, context);
        boolean allowed = this.decider.isTempAccessible(action, null, context, this.commandContext);
        this.logResult(resources, context, allowed);
        if (!allowed) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.018.005.0095", new Object[]{this.commandContext.getUserName(), "CREATE_TEMPORARY_TABLES"}), Arrays.asList(object));
        }
    }

    private void logRequest(Set<AbstractMetadataRecord> resources, DataPolicy.Context context) {
        this.logRequest((String[])resources.stream().map(r -> r.getFullName()).toArray(String[]::new), context);
    }

    private void logRequest(String[] resources, DataPolicy.Context context) {
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.AUDIT_LOG", (int)5)) {
            AuditMessage msg = new AuditMessage(context.name(), "getInaccessibleResources-request", resources, this.commandContext);
            LogManager.logDetail((String)"org.teiid.AUDIT_LOG", (Object)msg);
        }
    }

    @Override
    public void visit(Drop obj) {
        this.validateTemp(DataPolicy.PermissionType.DROP, obj.getTable().getNonCorrelationName(), obj.getTable(), DataPolicy.Context.DROP);
    }

    @Override
    public void visit(Delete obj) {
        this.validateEntitlements(obj);
    }

    @Override
    public void visit(Insert obj) {
        this.validateEntitlements(obj);
    }

    @Override
    public void visit(Query obj) {
        this.validateEntitlements(obj);
    }

    @Override
    public void visit(Update obj) {
        this.validateEntitlements(obj);
    }

    @Override
    public void visit(StoredProcedure obj) {
        this.validateEntitlements(obj);
    }

    @Override
    public void visit(Function obj) {
        if ("lookup".equalsIgnoreCase(obj.getName())) {
            try {
                ResolverUtil.ResolvedLookup lookup = ResolverUtil.resolveLookup(obj, this.getMetadata());
                LinkedList<Symbol> symbols = new LinkedList<Symbol>();
                symbols.add(lookup.getGroup());
                symbols.add(lookup.getKeyElement());
                symbols.add(lookup.getReturnElement());
                this.validateEntitlements(symbols, DataPolicy.PermissionType.READ, DataPolicy.Context.QUERY);
            }
            catch (TeiidComponentException e) {
                this.handleException((TeiidException)((Object)e), obj);
            }
            catch (TeiidProcessingException e) {
                this.handleException((TeiidException)((Object)e), obj);
            }
        } else {
            String schema = obj.getFunctionDescriptor().getSchema();
            if (schema != null && !AuthorizationValidationVisitor.isSystemSchema(schema)) {
                HashMap<FunctionMethod, Function> map = new HashMap<FunctionMethod, Function>();
                map.put(obj.getFunctionDescriptor().getMethod(), obj);
                this.validateEntitlements(DataPolicy.PermissionType.EXECUTE, DataPolicy.Context.FUNCTION, map);
            }
        }
    }

    protected void validateEntitlements(Insert obj) {
        LinkedList<Symbol> insert = new LinkedList<Symbol>();
        insert.add(obj.getGroup());
        insert.addAll(obj.getVariables());
        this.validateEntitlements(insert, DataPolicy.PermissionType.CREATE, DataPolicy.Context.INSERT);
        if (obj.isUpsert()) {
            this.validateEntitlements(insert, DataPolicy.PermissionType.UPDATE, DataPolicy.Context.MERGE);
        }
    }

    protected void validateEntitlements(Update obj) {
        HashSet<ElementSymbol> elements = new HashSet<ElementSymbol>();
        ElementCollectorVisitor.getElements(obj.getChangeList().getClauseMap().values(), elements);
        if (obj.getCriteria() != null) {
            ElementCollectorVisitor.getElements((LanguageObject)obj.getCriteria(), elements);
        }
        this.validateEntitlements(elements, DataPolicy.PermissionType.READ, DataPolicy.Context.UPDATE);
        LinkedList<Symbol> updated = new LinkedList<Symbol>();
        updated.add(obj.getGroup());
        updated.addAll(obj.getChangeList().getClauseMap().keySet());
        this.validateEntitlements(updated, DataPolicy.PermissionType.UPDATE, DataPolicy.Context.UPDATE);
    }

    protected void validateEntitlements(Delete obj) {
        if (obj.getCriteria() != null) {
            this.validateEntitlements(ElementCollectorVisitor.getElements((LanguageObject)obj.getCriteria(), true), DataPolicy.PermissionType.READ, DataPolicy.Context.DELETE);
        }
        this.validateEntitlements(Arrays.asList(obj.getGroup()), DataPolicy.PermissionType.DELETE, DataPolicy.Context.DELETE);
    }

    protected void validateEntitlements(Query obj) {
        Into intoObj = obj.getInto();
        if (intoObj != null) {
            GroupSymbol intoGroup = intoObj.getGroup();
            LinkedList<Symbol> intoElements = new LinkedList<Symbol>();
            intoElements.add(intoGroup);
            try {
                intoElements.addAll(ResolverUtil.resolveElementsInGroup(intoGroup, this.getMetadata()));
            }
            catch (QueryMetadataException err) {
                this.handleException((TeiidException)((Object)err), intoGroup);
            }
            catch (TeiidComponentException err) {
                this.handleException((TeiidException)((Object)err), intoGroup);
            }
            this.validateEntitlements(intoElements, DataPolicy.PermissionType.CREATE, DataPolicy.Context.INSERT);
        }
        ArrayList<GroupSymbol> entitledObjects = new ArrayList<GroupSymbol>(GroupCollectorVisitor.getGroupsIgnoreInlineViews(obj, true));
        entitledObjects.addAll(ElementCollectorVisitor.getElements((LanguageObject)obj, true));
        if (entitledObjects.size() == 0) {
            return;
        }
        this.validateEntitlements(entitledObjects, DataPolicy.PermissionType.READ, DataPolicy.Context.QUERY);
    }

    protected void validateEntitlements(StoredProcedure obj) {
        this.validateEntitlements(Arrays.asList(obj.getGroup()), DataPolicy.PermissionType.EXECUTE, DataPolicy.Context.STORED_PROCEDURE);
    }

    protected void validateEntitlements(Collection<? extends LanguageObject> symbols, DataPolicy.PermissionType actionCode, DataPolicy.Context auditContext) {
        LinkedHashMap<AbstractMetadataRecord, LanguageObject> recordToSymbolMap = new LinkedHashMap<AbstractMetadataRecord, LanguageObject>();
        for (LanguageObject languageObject : symbols) {
            try {
                GroupSymbol group;
                Object metadataID = null;
                if (languageObject instanceof ElementSymbol) {
                    metadataID = ((ElementSymbol)languageObject).getMetadataID();
                    if (metadataID instanceof MultiSourceElement || metadataID instanceof TempMetadataID) {
                        continue;
                    }
                } else if (languageObject instanceof GroupSymbol && (metadataID = (group = (GroupSymbol)languageObject).getMetadataID()) instanceof TempMetadataID) {
                    if (group.isProcedure()) {
                        LinkedHashMap<AbstractMetadataRecord, LanguageObject> procMap = new LinkedHashMap<AbstractMetadataRecord, LanguageObject>();
                        AuthorizationValidationVisitor.addToMap(((TempMetadataID)metadataID).getOriginalMetadataID(), languageObject, procMap, this.getMetadata());
                        this.validateEntitlements(DataPolicy.PermissionType.EXECUTE, auditContext, procMap);
                        continue;
                    }
                    if (!group.isTempTable() || !group.isImplicitTempGroupSymbol()) continue;
                    this.validateTemp(actionCode, group.getNonCorrelationName(), group, auditContext);
                    continue;
                }
                AuthorizationValidationVisitor.addToMap(metadataID, languageObject, recordToSymbolMap, this.getMetadata());
            }
            catch (QueryMetadataException e) {
                this.handleException((TeiidException)((Object)e));
            }
            catch (TeiidComponentException e) {
                this.handleException((TeiidException)((Object)e));
            }
        }
        this.validateEntitlements(actionCode, auditContext, recordToSymbolMap);
    }

    static void addToMap(Object metadataID, LanguageObject symbol, Map<AbstractMetadataRecord, LanguageObject> recordToSymbolMap, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        Object modelId = metadata.getModelID(metadataID);
        String modelName = metadata.getFullName(modelId);
        if (!AuthorizationValidationVisitor.isSystemSchema(modelName)) {
            if (!metadata.isVirtualModel(modelId)) {
                GroupSymbol group = null;
                if (symbol instanceof ElementSymbol) {
                    group = ((ElementSymbol)symbol).getGroupSymbol();
                } else if (symbol instanceof GroupSymbol) {
                    group = (GroupSymbol)symbol;
                }
                if (group != null && group.isTempGroupSymbol() && !group.isGlobalTable()) {
                    metadataID = metadata.getGroupIDForElementID(metadataID);
                }
            }
            if (metadataID instanceof AbstractMetadataRecord) {
                recordToSymbolMap.put((AbstractMetadataRecord)metadataID, symbol);
            }
        }
    }

    private static boolean isSystemSchema(String modelName) {
        return "SYS".equalsIgnoreCase(modelName) || "pg_catalog".equalsIgnoreCase(modelName);
    }

    private void validateEntitlements(DataPolicy.PermissionType actionCode, DataPolicy.Context auditContext, Map<AbstractMetadataRecord, ? extends LanguageObject> recordToSymbolMap) {
        if (recordToSymbolMap.isEmpty()) {
            return;
        }
        Set<AbstractMetadataRecord> inaccessibleResources = this.getInaccessibleResources(actionCode, recordToSymbolMap, auditContext);
        if (inaccessibleResources.isEmpty()) {
            return;
        }
        ArrayList<LanguageObject> inaccessibleSymbols = new ArrayList<LanguageObject>(inaccessibleResources.size());
        for (AbstractMetadataRecord record : inaccessibleResources) {
            inaccessibleSymbols.add(recordToSymbolMap.get(record));
        }
        this.handleValidationError(QueryPlugin.Util.getString("ERR.018.005.0095", new Object[]{this.commandContext.getUserName(), actionCode}), inaccessibleSymbols);
    }

    public Set<AbstractMetadataRecord> getInaccessibleResources(DataPolicy.PermissionType action, Map<AbstractMetadataRecord, ? extends LanguageObject> resources, DataPolicy.Context context) {
        this.logRequest(resources.keySet(), context);
        Set results = this.decider.getInaccessibleResources(action, resources.keySet(), context, this.commandContext);
        this.logResult(resources.keySet(), context, results.isEmpty());
        return results;
    }

    private void logResult(Set<AbstractMetadataRecord> resources, DataPolicy.Context context, boolean granted) {
        this.logResult((String[])resources.stream().map(r -> r.getFullName()).toArray(String[]::new), context, granted);
    }

    private void logResult(String[] resources, DataPolicy.Context context, boolean granted) {
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.AUDIT_LOG", (int)5)) {
            if (granted) {
                AuditMessage msg = new AuditMessage(context.name(), "getInaccessibleResources-granted all", resources, this.commandContext);
                LogManager.logDetail((String)"org.teiid.AUDIT_LOG", (Object)msg);
            } else {
                AuditMessage msg = new AuditMessage(context.name(), "getInaccessibleResources-denied", resources, this.commandContext);
                LogManager.logDetail((String)"org.teiid.AUDIT_LOG", (Object)msg);
            }
        }
    }
}

