/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.teiid.core.CorePlugin;

public class ReaderInputStream
extends InputStream {
    static final int DEFAULT_BUFFER_SIZE = 8192;
    private final Reader reader;
    private CharBuffer cb;
    private ByteBuffer bb;
    private boolean done;
    private boolean wasOverflow;
    private CharsetEncoder encoder;
    private byte[] singleByte = new byte[1];

    public ReaderInputStream(Reader reader, Charset charset) {
        this(reader, charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE), 8192);
    }

    public ReaderInputStream(Reader reader, CharsetEncoder encoder) {
        this(reader, encoder, 8192);
    }

    public ReaderInputStream(Reader reader, CharsetEncoder encoder, int bufferSize) {
        this.reader = reader;
        this.encoder = encoder;
        this.encoder.reset();
        this.cb = CharBuffer.allocate(bufferSize);
        this.bb = ByteBuffer.allocate(bufferSize);
        this.bb.limit(0);
    }

    @Override
    public int read(byte[] bbuf, int off, int len) throws IOException {
        if (off < 0 || off > bbuf.length || len < 0 || off + len > bbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        while (!this.done && !this.bb.hasRemaining()) {
            int read = 0;
            int pos = this.cb.position();
            if (!this.wasOverflow) {
                while ((read = this.reader.read(this.cb)) == 0) {
                }
                this.cb.flip();
            }
            this.bb.clear();
            CoderResult cr = this.encoder.encode(this.cb, this.bb, read == -1);
            this.checkResult(cr);
            if (read == -1 && !this.wasOverflow) {
                cr = this.encoder.flush(this.bb);
                this.checkResult(cr);
                if (!this.wasOverflow) {
                    this.done = true;
                }
            }
            if (!this.wasOverflow) {
                if (read != 0 && this.cb.position() != read + pos) {
                    this.cb.compact();
                } else {
                    this.cb.clear();
                }
            }
            this.bb.flip();
        }
        if ((len = Math.min(len, this.bb.remaining())) == 0 && this.done) {
            return -1;
        }
        this.bb.get(bbuf, off, len);
        return len;
    }

    private void checkResult(CoderResult cr) throws IOException {
        if (cr.isOverflow()) {
            this.wasOverflow = true;
            assert (this.bb.position() > 0);
        } else if (!cr.isUnderflow()) {
            try {
                cr.throwException();
            }
            catch (CharacterCodingException e) {
                throw new IOException(CorePlugin.Util.gs(CorePlugin.Event.TEIID10083, this.encoder.charset().displayName()), e);
            }
        } else {
            this.wasOverflow = false;
        }
    }

    @Override
    public int read() throws IOException {
        int read = this.read(this.singleByte, 0, 1);
        if (read == 1) {
            return this.singleByte[0] & 0xFF;
        }
        assert (read != 0);
        return -1;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

