/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.teiid.core.CorePlugin;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;

public class StringToJsonTransform
extends Transform {
    private static Method METHOD;

    @Override
    public Object transformDirect(Object value) throws TransformationException {
        String json = (String)value;
        if (METHOD == null) {
            try {
                Class<?> clazz = Class.forName("org.teiid.query.function.JSONFunctionMethods");
                METHOD = clazz.getMethod("jsonParse", ClobType.class, Boolean.TYPE);
            }
            catch (Exception e) {
                throw new TransformationException(e, CorePlugin.Util.gs(CorePlugin.Event.TEIID10084, new Object[0]));
            }
        }
        try {
            return METHOD.invoke(null, new ClobType(new ClobImpl(json)), false);
        }
        catch (InvocationTargetException e) {
            throw new TransformationException(e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new TransformationException(e);
        }
        catch (IllegalArgumentException e) {
            throw new TransformationException(e);
        }
    }

    @Override
    public Class<?> getSourceType() {
        return DataTypeManager.DefaultDataClasses.STRING;
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManager.DefaultDataClasses.JSON;
    }

    @Override
    public boolean isExplicit() {
        return true;
    }
}

