/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.language;

import org.teiid.language.BaseLanguageObject;
import org.teiid.language.Condition;
import org.teiid.language.TableReference;
import org.teiid.language.visitor.LanguageObjectVisitor;

public class Join
extends BaseLanguageObject
implements TableReference {
    private TableReference leftItem;
    private TableReference rightItem;
    private JoinType joinType;
    private Condition condition;

    public Join(TableReference left, TableReference right, JoinType joinType, Condition criteria) {
        this.leftItem = left;
        this.rightItem = right;
        this.joinType = joinType;
        this.condition = criteria;
    }

    public TableReference getLeftItem() {
        return this.leftItem;
    }

    public TableReference getRightItem() {
        return this.rightItem;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public Condition getCondition() {
        return this.condition;
    }

    @Override
    public void acceptVisitor(LanguageObjectVisitor visitor) {
        visitor.visit(this);
    }

    public void setLeftItem(TableReference item) {
        this.leftItem = item;
    }

    public void setRightItem(TableReference item) {
        this.rightItem = item;
    }

    public void setJoinType(JoinType type) {
        this.joinType = type;
    }

    public void setCondition(Condition criteria) {
        this.condition = criteria;
    }

    public static enum JoinType {
        INNER_JOIN,
        CROSS_JOIN,
        LEFT_OUTER_JOIN,
        RIGHT_OUTER_JOIN,
        FULL_OUTER_JOIN;

    }
}

