/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.util.ArrayList;
import java.util.List;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;

public class Procedure
extends AbstractMetadataRecord
implements AbstractMetadataRecord.Modifiable {
    private static final long serialVersionUID = 7714869437683360834L;
    public static final int AUTO_UPDATECOUNT = -1;
    private boolean isFunction;
    private boolean isVirtual;
    private int updateCount = -1;
    private List<ProcedureParameter> parameters = new ArrayList<ProcedureParameter>(2);
    private ColumnSet<Procedure> resultSet;
    private volatile String queryPlan;
    private Schema parent;
    private volatile transient long lastModified;

    public void setParent(Schema parent) {
        this.parent = parent;
    }

    public boolean isFunction() {
        return this.isFunction;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public Type getType() {
        if (this.isFunction()) {
            if (this.isVirtual()) {
                return Type.UDF;
            }
            return Type.Function;
        }
        if (this.isVirtual()) {
            return Type.StoredQuery;
        }
        return Type.StoredProc;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public List<ProcedureParameter> getParameters() {
        return this.parameters;
    }

    public ProcedureParameter getParameterByName(String param) {
        for (ProcedureParameter p : this.parameters) {
            if (!p.getName().equals(param)) continue;
            return p;
        }
        return null;
    }

    public void setParameters(List<ProcedureParameter> parameters) {
        this.parameters = parameters;
    }

    public String getQueryPlan() {
        return this.queryPlan;
    }

    public void setQueryPlan(String queryPlan) {
        this.queryPlan = queryPlan;
    }

    public void setFunction(boolean b) {
        this.isFunction = b;
    }

    public void setVirtual(boolean b) {
        this.isVirtual = b;
    }

    public void setUpdateCount(int count) {
        this.updateCount = count;
    }

    public void setResultSet(ColumnSet<Procedure> resultSet) {
        this.resultSet = resultSet;
        if (resultSet != null) {
            resultSet.setParent(this);
        }
    }

    public ColumnSet<Procedure> getResultSet() {
        return this.resultSet;
    }

    @Override
    public Schema getParent() {
        return this.parent;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public static enum Type {
        Function,
        UDF,
        StoredProc,
        StoredQuery;

    }
}

