/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.tooling.sources;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.teavm.tooling.sources.SourceFileInfo;
import org.teavm.tooling.sources.SourceFileProvider;

public class DirectorySourceFileProvider
implements SourceFileProvider {
    private File baseDirectory;

    public DirectorySourceFileProvider(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public SourceFileInfo getSourceFile(String fullPath) throws IOException {
        File file = new File(this.baseDirectory, fullPath);
        return file.exists() ? new DirectorySourceFile(file) : null;
    }

    static class DirectorySourceFile
    implements SourceFileInfo {
        private File file;

        DirectorySourceFile(File file) {
            this.file = file;
        }

        @Override
        public long lastModified() {
            return this.file.lastModified();
        }

        @Override
        public InputStream open() throws IOException {
            return new FileInputStream(this.file);
        }
    }
}

