/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.tooling;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.teavm.backend.c.CTarget;
import org.teavm.backend.c.generate.CNameProvider;
import org.teavm.backend.javascript.JavaScriptTarget;
import org.teavm.backend.lowlevel.generate.NameProvider;
import org.teavm.backend.wasm.WasmTarget;
import org.teavm.backend.wasm.render.WasmBinaryVersion;
import org.teavm.cache.AlwaysStaleCacheStatus;
import org.teavm.cache.CacheStatus;
import org.teavm.cache.DiskCachedClassReaderSource;
import org.teavm.cache.DiskMethodNodeCache;
import org.teavm.cache.DiskProgramCache;
import org.teavm.cache.EmptyProgramCache;
import org.teavm.cache.FileSymbolTable;
import org.teavm.cache.MethodNodeCache;
import org.teavm.cache.SymbolTable;
import org.teavm.debugging.information.DebugInformation;
import org.teavm.debugging.information.DebugInformationBuilder;
import org.teavm.debugging.information.DebugInformationEmitter;
import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.FastDependencyAnalyzer;
import org.teavm.dependency.PreciseDependencyAnalyzer;
import org.teavm.diagnostics.ProblemProvider;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.PreOptimizingClassHolderSource;
import org.teavm.model.ProgramCache;
import org.teavm.model.ReferenceCache;
import org.teavm.parsing.ClassDateProvider;
import org.teavm.parsing.ClasspathClassHolderSource;
import org.teavm.tooling.EmptyTeaVMToolLog;
import org.teavm.tooling.InstructionLocationReader;
import org.teavm.tooling.TeaVMTargetType;
import org.teavm.tooling.TeaVMToolException;
import org.teavm.tooling.TeaVMToolLog;
import org.teavm.tooling.sources.SourceFileProvider;
import org.teavm.tooling.sources.SourceFilesCopier;
import org.teavm.vm.BuildTarget;
import org.teavm.vm.DirectoryBuildTarget;
import org.teavm.vm.TeaVM;
import org.teavm.vm.TeaVMBuilder;
import org.teavm.vm.TeaVMOptimizationLevel;
import org.teavm.vm.TeaVMProgressListener;
import org.teavm.vm.TeaVMTarget;

public class TeaVMTool {
    private File targetDirectory = new File(".");
    private TeaVMTargetType targetType = TeaVMTargetType.JAVASCRIPT;
    private String targetFileName = "";
    private boolean minifying = true;
    private int maxTopLevelNames = 10000;
    private String mainClass;
    private String entryPointName = "main";
    private Properties properties = new Properties();
    private boolean debugInformationGenerated;
    private boolean sourceMapsFileGenerated;
    private boolean sourceFilesCopied;
    private boolean incremental;
    private File cacheDirectory = new File("./teavm-cache");
    private List<String> transformers = new ArrayList<String>();
    private List<String> classesToPreserve = new ArrayList<String>();
    private TeaVMToolLog log = new EmptyTeaVMToolLog();
    private ClassLoader classLoader = TeaVMTool.class.getClassLoader();
    private DiskCachedClassReaderSource cachedClassSource;
    private DiskProgramCache programCache;
    private DiskMethodNodeCache astCache;
    private FileSymbolTable symbolTable;
    private FileSymbolTable fileTable;
    private FileSymbolTable variableTable;
    private boolean cancelled;
    private TeaVMProgressListener progressListener;
    private TeaVM vm;
    private boolean fastDependencyAnalysis;
    private TeaVMOptimizationLevel optimizationLevel = TeaVMOptimizationLevel.SIMPLE;
    private List<SourceFileProvider> sourceFileProviders = new ArrayList<SourceFileProvider>();
    private DebugInformationBuilder debugEmitter;
    private JavaScriptTarget javaScriptTarget;
    private WasmTarget webAssemblyTarget;
    private WasmBinaryVersion wasmVersion = WasmBinaryVersion.V_0x1;
    private CTarget cTarget;
    private Set<File> generatedFiles = new HashSet<File>();
    private int minHeapSize = 0x2000000;
    private ReferenceCache referenceCache;
    private boolean longjmpSupported = true;
    private boolean heapDump;

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    public void setTargetDirectory(File targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public String getTargetFileName() {
        return this.targetFileName;
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }

    public boolean isMinifying() {
        return this.minifying;
    }

    public void setMinifying(boolean minifying) {
        this.minifying = minifying;
    }

    public void setMaxTopLevelNames(int maxTopLevelNames) {
        this.maxTopLevelNames = maxTopLevelNames;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setEntryPointName(String entryPointName) {
        this.entryPointName = entryPointName;
    }

    public boolean isDebugInformationGenerated() {
        return this.debugInformationGenerated;
    }

    public void setDebugInformationGenerated(boolean debugInformationGenerated) {
        this.debugInformationGenerated = debugInformationGenerated;
    }

    public File getCacheDirectory() {
        return this.cacheDirectory;
    }

    public void setCacheDirectory(File cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    public boolean isSourceMapsFileGenerated() {
        return this.sourceMapsFileGenerated;
    }

    public void setSourceMapsFileGenerated(boolean sourceMapsFileGenerated) {
        this.sourceMapsFileGenerated = sourceMapsFileGenerated;
    }

    public boolean isSourceFilesCopied() {
        return this.sourceFilesCopied;
    }

    public void setSourceFilesCopied(boolean sourceFilesCopied) {
        this.sourceFilesCopied = sourceFilesCopied;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public List<String> getTransformers() {
        return this.transformers;
    }

    public List<String> getClassesToPreserve() {
        return this.classesToPreserve;
    }

    public TeaVMToolLog getLog() {
        return this.log;
    }

    public void setLog(TeaVMToolLog log) {
        this.log = log;
    }

    public TeaVMTargetType getTargetType() {
        return this.targetType;
    }

    public void setTargetType(TeaVMTargetType targetType) {
        this.targetType = targetType;
    }

    public TeaVMOptimizationLevel getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public void setOptimizationLevel(TeaVMOptimizationLevel optimizationLevel) {
        this.optimizationLevel = optimizationLevel;
    }

    public boolean isFastDependencyAnalysis() {
        return this.fastDependencyAnalysis;
    }

    public void setFastDependencyAnalysis(boolean fastDependencyAnalysis) {
        this.fastDependencyAnalysis = fastDependencyAnalysis;
    }

    public void setMinHeapSize(int minHeapSize) {
        this.minHeapSize = minHeapSize;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public WasmBinaryVersion getWasmVersion() {
        return this.wasmVersion;
    }

    public void setWasmVersion(WasmBinaryVersion wasmVersion) {
        this.wasmVersion = wasmVersion;
    }

    public void setLongjmpSupported(boolean longjmpSupported) {
        this.longjmpSupported = longjmpSupported;
    }

    public void setHeapDump(boolean heapDump) {
        this.heapDump = heapDump;
    }

    public void setProgressListener(TeaVMProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public ProblemProvider getProblemProvider() {
        return this.vm != null ? this.vm.getProblemProvider() : null;
    }

    public DependencyInfo getDependencyInfo() {
        return this.vm.getDependencyInfo();
    }

    public Collection<String> getClasses() {
        return this.vm != null ? this.vm.getClasses() : Collections.emptyList();
    }

    public Set<File> getGeneratedFiles() {
        return this.generatedFiles;
    }

    public Collection<String> getUsedResources() {
        if (this.vm == null) {
            return Collections.emptyList();
        }
        return InstructionLocationReader.extractUsedResources(this.vm);
    }

    public void addSourceFileProvider(SourceFileProvider sourceFileProvider) {
        this.sourceFileProviders.add(sourceFileProvider);
    }

    private TeaVMTarget prepareTarget() {
        switch (this.targetType) {
            case JAVASCRIPT: {
                return this.prepareJavaScriptTarget();
            }
            case WEBASSEMBLY: {
                return this.prepareWebAssemblyTarget();
            }
            case C: {
                return this.prepareCTarget();
            }
        }
        throw new IllegalStateException("Unknown target type: " + (Object)((Object)this.targetType));
    }

    private TeaVMTarget prepareJavaScriptTarget() {
        this.javaScriptTarget = new JavaScriptTarget();
        this.javaScriptTarget.setMinifying(this.minifying);
        this.javaScriptTarget.setTopLevelNameLimit(this.maxTopLevelNames);
        this.debugEmitter = this.debugInformationGenerated || this.sourceMapsFileGenerated ? new DebugInformationBuilder(this.referenceCache) : null;
        this.javaScriptTarget.setDebugEmitter((DebugInformationEmitter)this.debugEmitter);
        return this.javaScriptTarget;
    }

    private WasmTarget prepareWebAssemblyTarget() {
        this.webAssemblyTarget = new WasmTarget();
        this.webAssemblyTarget.setDebugging(this.debugInformationGenerated);
        this.webAssemblyTarget.setCEmitted(this.debugInformationGenerated);
        this.webAssemblyTarget.setWastEmitted(this.debugInformationGenerated);
        this.webAssemblyTarget.setVersion(this.wasmVersion);
        this.webAssemblyTarget.setMinHeapSize(this.minHeapSize);
        return this.webAssemblyTarget;
    }

    private CTarget prepareCTarget() {
        this.cTarget = new CTarget((NameProvider)new CNameProvider());
        this.cTarget.setMinHeapSize(this.minHeapSize);
        this.cTarget.setLineNumbersGenerated(this.debugInformationGenerated);
        this.cTarget.setLongjmpUsed(this.longjmpSupported);
        this.cTarget.setHeapDump(this.heapDump);
        return this.cTarget;
    }

    public void generate() throws TeaVMToolException {
        try {
            AlwaysStaleCacheStatus cacheStatus;
            this.cancelled = false;
            this.log.info("Running TeaVM");
            this.referenceCache = new ReferenceCache();
            TeaVMBuilder vmBuilder = new TeaVMBuilder(this.prepareTarget());
            vmBuilder.setReferenceCache(this.referenceCache);
            if (this.incremental) {
                this.cacheDirectory.mkdirs();
                this.symbolTable = new FileSymbolTable(new File(this.cacheDirectory, "symbols"));
                this.fileTable = new FileSymbolTable(new File(this.cacheDirectory, "files"));
                this.variableTable = new FileSymbolTable(new File(this.cacheDirectory, "variables"));
                ClasspathClassHolderSource innerClassSource = new ClasspathClassHolderSource(this.classLoader, this.referenceCache);
                PreOptimizingClassHolderSource classSource = new PreOptimizingClassHolderSource((ClassHolderSource)innerClassSource);
                this.cachedClassSource = new DiskCachedClassReaderSource(this.cacheDirectory, this.referenceCache, (SymbolTable)this.symbolTable, (SymbolTable)this.fileTable, (SymbolTable)this.variableTable, (ClassHolderSource)classSource, (ClassDateProvider)innerClassSource);
                this.programCache = new DiskProgramCache(this.cacheDirectory, this.referenceCache, (SymbolTable)this.symbolTable, (SymbolTable)this.fileTable, (SymbolTable)this.variableTable);
                if (this.incremental && this.targetType == TeaVMTargetType.JAVASCRIPT) {
                    this.astCache = new DiskMethodNodeCache(this.cacheDirectory, this.referenceCache, (SymbolTable)this.symbolTable, (SymbolTable)this.fileTable, (SymbolTable)this.variableTable);
                    this.javaScriptTarget.setAstCache((MethodNodeCache)this.astCache);
                }
                try {
                    this.symbolTable.update();
                    this.fileTable.update();
                    this.variableTable.update();
                }
                catch (IOException e) {
                    this.log.info("Cache is missing");
                }
                vmBuilder.setClassLoader(this.classLoader).setClassSource((ClassReaderSource)this.cachedClassSource);
                cacheStatus = this.cachedClassSource;
            } else {
                vmBuilder.setClassLoader(this.classLoader).setClassSource((ClassReaderSource)new PreOptimizingClassHolderSource((ClassHolderSource)new ClasspathClassHolderSource(this.classLoader, this.referenceCache)));
                cacheStatus = AlwaysStaleCacheStatus.INSTANCE;
            }
            vmBuilder.setDependencyAnalyzerFactory(this.fastDependencyAnalysis ? FastDependencyAnalyzer::new : PreciseDependencyAnalyzer::new);
            this.vm = vmBuilder.build();
            if (this.progressListener != null) {
                this.vm.setProgressListener(this.progressListener);
            }
            this.vm.setProperties(this.properties);
            this.vm.setProgramCache((ProgramCache)(this.incremental ? this.programCache : EmptyProgramCache.INSTANCE));
            this.vm.setCacheStatus((CacheStatus)cacheStatus);
            this.vm.setOptimizationLevel(!this.fastDependencyAnalysis && !this.incremental ? this.optimizationLevel : TeaVMOptimizationLevel.SIMPLE);
            if (this.incremental) {
                this.vm.addVirtualMethods(m -> true);
            }
            this.vm.installPlugins();
            for (ClassHolderTransformer transformer : this.resolveTransformers(this.classLoader)) {
                this.vm.add(transformer);
            }
            if (this.mainClass != null) {
                this.vm.entryPoint(this.mainClass, this.entryPointName != null ? this.entryPointName : "main");
            }
            for (String className : this.classesToPreserve) {
                this.vm.preserveType(className);
            }
            this.targetDirectory.mkdirs();
            DirectoryBuildTarget buildTarget = new DirectoryBuildTarget(this.targetDirectory);
            String outputName = this.getResolvedTargetFileName();
            this.vm.build((BuildTarget)buildTarget, outputName);
            if (this.vm.wasCancelled()) {
                this.log.info("Build cancelled");
                this.cancelled = true;
                return;
            }
            ProblemProvider problemProvider = this.vm.getProblemProvider();
            if (problemProvider.getProblems().isEmpty()) {
                this.log.info("Output file successfully built");
            } else if (problemProvider.getSevereProblems().isEmpty()) {
                this.log.info("Output file built with warnings");
            } else {
                this.log.info("Output file built with errors");
            }
            File outputFile = new File(this.targetDirectory, outputName);
            this.generatedFiles.add(outputFile);
            if (this.targetType == TeaVMTargetType.JAVASCRIPT) {
                try (FileOutputStream output = new FileOutputStream(new File(this.targetDirectory, outputName), true);
                     OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, StandardCharsets.UTF_8);){
                    this.additionalJavaScriptOutput(writer);
                }
            }
            if (this.incremental) {
                this.programCache.flush();
                if (this.astCache != null) {
                    this.astCache.flush();
                }
                this.cachedClassSource.flush();
                this.symbolTable.flush();
                this.fileTable.flush();
                this.variableTable.flush();
                this.log.info("Cache updated");
            }
            this.printStats();
        }
        catch (IOException e) {
            throw new TeaVMToolException("IO error occurred", e);
        }
    }

    private String getResolvedTargetFileName() {
        if (this.targetFileName.isEmpty()) {
            switch (this.targetType) {
                case JAVASCRIPT: {
                    return "classes.js";
                }
                case WEBASSEMBLY: {
                    return "classes.wasm";
                }
                case C: {
                    return "classes.c";
                }
            }
            return "classes";
        }
        return this.targetFileName;
    }

    private void additionalJavaScriptOutput(Writer writer) throws IOException {
        DebugInformation debugInfo;
        if (this.debugInformationGenerated) {
            assert (this.debugEmitter != null);
            debugInfo = this.debugEmitter.getDebugInformation();
            File debugSymbolFile = new File(this.targetDirectory, this.getResolvedTargetFileName() + ".teavmdbg");
            try (BufferedOutputStream debugInfoOut = new BufferedOutputStream(new FileOutputStream(debugSymbolFile));){
                debugInfo.write((OutputStream)debugInfoOut);
            }
            this.generatedFiles.add(debugSymbolFile);
            this.log.info("Debug information successfully written");
        }
        if (this.sourceMapsFileGenerated) {
            assert (this.debugEmitter != null);
            debugInfo = this.debugEmitter.getDebugInformation();
            String sourceMapsFileName = this.getResolvedTargetFileName() + ".map";
            writer.append("\n//# sourceMappingURL=").append(sourceMapsFileName);
            File sourceMapsFile = new File(this.targetDirectory, sourceMapsFileName);
            try (OutputStreamWriter sourceMapsOut = new OutputStreamWriter((OutputStream)new FileOutputStream(sourceMapsFile), StandardCharsets.UTF_8);){
                debugInfo.writeAsSourceMaps((Writer)sourceMapsOut, "src", this.getResolvedTargetFileName());
            }
            this.generatedFiles.add(sourceMapsFile);
            this.log.info("Source maps successfully written");
        }
        if (this.sourceFilesCopied) {
            this.copySourceFiles();
            this.log.info("Source files successfully written");
        }
    }

    private void printStats() {
        if (this.vm == null || this.vm.getWrittenClasses() == null) {
            return;
        }
        int classCount = this.vm.getWrittenClasses().getClassNames().size();
        int methodCount = 0;
        for (String className : this.vm.getWrittenClasses().getClassNames()) {
            ClassReader cls = this.vm.getWrittenClasses().get(className);
            methodCount += cls.getMethods().size();
        }
        this.log.info("Classes compiled: " + classCount);
        this.log.info("Methods compiled: " + methodCount);
    }

    private void copySourceFiles() {
        if (this.vm.getWrittenClasses() == null) {
            return;
        }
        SourceFilesCopier copier = new SourceFilesCopier(this.sourceFileProviders, this.generatedFiles::add);
        copier.addClasses(this.vm.getWrittenClasses());
        copier.setLog(this.log);
        copier.copy(new File(this.targetDirectory, "src"));
    }

    private List<ClassHolderTransformer> resolveTransformers(ClassLoader classLoader) {
        ArrayList<ClassHolderTransformer> transformerInstances = new ArrayList<ClassHolderTransformer>();
        if (this.transformers == null) {
            return transformerInstances;
        }
        for (String transformerName : this.transformers) {
            Constructor<ClassHolderTransformer> ctor;
            Class<?> transformerRawType;
            try {
                transformerRawType = Class.forName(transformerName, true, classLoader);
            }
            catch (ClassNotFoundException e) {
                this.log.error("Transformer not found: " + transformerName, e);
                continue;
            }
            if (!ClassHolderTransformer.class.isAssignableFrom(transformerRawType)) {
                this.log.error("Transformer " + transformerName + " is not subtype of " + ClassHolderTransformer.class.getName());
                continue;
            }
            Class<ClassHolderTransformer> transformerType = transformerRawType.asSubclass(ClassHolderTransformer.class);
            try {
                ctor = transformerType.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.log.error("Transformer " + transformerName + " has no default constructor");
                continue;
            }
            try {
                ClassHolderTransformer transformer = ctor.newInstance(new Object[0]);
                transformerInstances.add(transformer);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                this.log.error("Error instantiating transformer " + transformerName, e);
            }
        }
        return transformerInstances;
    }
}

