/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.runtime;

import org.teavm.interop.Address;
import org.teavm.runtime.GC;
import org.teavm.runtime.RuntimeObject;

final class MarkQueue {
    private static int head;
    private static int tail;
    private static int limit;

    private MarkQueue() {
    }

    static void init() {
        head = 0;
        tail = 0;
        limit = GC.gcStorageSize() / Address.sizeOf();
    }

    static void enqueue(RuntimeObject object) {
        GC.gcStorageAddress().add(Address.sizeOf() * tail).putAddress(object.toAddress());
        if (++tail >= limit) {
            tail = 0;
        }
    }

    static RuntimeObject dequeue() {
        Address result = GC.gcStorageAddress().add(Address.sizeOf() * head).getAddress();
        if (++head >= limit) {
            head = 0;
        }
        return (RuntimeObject)result.toStructure();
    }

    static boolean isEmpty() {
        return head == tail;
    }
}

