/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.analysis;

import com.carrotsearch.hppc.IntArrayDeque;
import com.carrotsearch.hppc.IntIntMap;
import com.carrotsearch.hppc.IntIntOpenHashMap;
import com.carrotsearch.hppc.IntOpenHashSet;
import com.carrotsearch.hppc.IntSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.teavm.common.DominatorTree;
import org.teavm.common.Graph;
import org.teavm.common.GraphBuilder;
import org.teavm.common.GraphUtils;
import org.teavm.model.BasicBlock;
import org.teavm.model.Incoming;
import org.teavm.model.Instruction;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.Variable;
import org.teavm.model.instructions.AbstractInstructionVisitor;
import org.teavm.model.instructions.ArrayLengthInstruction;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.BinaryBranchingInstruction;
import org.teavm.model.instructions.BranchingInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.CloneArrayInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ConstructMultiArrayInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.MonitorEnterInstruction;
import org.teavm.model.instructions.MonitorExitInstruction;
import org.teavm.model.instructions.NullCheckInstruction;
import org.teavm.model.instructions.NullConstantInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.instructions.UnwrapArrayInstruction;
import org.teavm.model.util.DominatorWalker;
import org.teavm.model.util.DominatorWalkerCallback;
import org.teavm.model.util.PhiUpdater;

class NullnessInformationBuilder {
    private Program program;
    private MethodDescriptor methodDescriptor;
    BitSet notNullVariables = new BitSet();
    BitSet nullVariables = new BitSet();
    BitSet synthesizedVariables = new BitSet();
    PhiUpdater phiUpdater;
    private List<NullConstantInstruction> nullInstructions = new ArrayList<NullConstantInstruction>();
    private List<NullCheckInstruction> notNullInstructions = new ArrayList<NullCheckInstruction>();
    private Graph assignmentGraph;
    private int[] notNullPredecessorsLeft;
    private int[] sccIndexes;

    NullnessInformationBuilder(Program program, MethodDescriptor methodDescriptor) {
        this.program = program;
        this.methodDescriptor = methodDescriptor;
    }

    void build() {
        this.extendProgram();
        this.buildAssignmentGraph();
        this.propagateNullness();
    }

    private void extendProgram() {
        this.notNullVariables.set(0);
        this.insertAdditionalVariables();
        Variable[] parameters = new Variable[this.methodDescriptor.parameterCount() + 1];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = this.program.variableAt(i);
        }
        this.phiUpdater = new PhiUpdater();
        this.phiUpdater.updatePhis(this.program, parameters);
        this.collectAdditionalVariables();
    }

    private void insertAdditionalVariables() {
        DominatorWalker walker = new DominatorWalker(this.program);
        NullExtensionVisitor ev = new NullExtensionVisitor();
        walker.walk(ev);
    }

    private void collectAdditionalVariables() {
        for (NullConstantInstruction nullInstruction : this.nullInstructions) {
            this.nullVariables.set(nullInstruction.getReceiver().getIndex());
            this.synthesizedVariables.set(nullInstruction.getReceiver().getIndex());
        }
        for (NullCheckInstruction notNullInstruction : this.notNullInstructions) {
            this.notNullVariables.set(notNullInstruction.getReceiver().getIndex());
            this.synthesizedVariables.set(notNullInstruction.getReceiver().getIndex());
        }
        this.nullInstructions.clear();
        this.notNullInstructions.clear();
    }

    private void buildAssignmentGraph() {
        GraphBuilder builder = new GraphBuilder(this.program.variableCount());
        for (BasicBlock block : this.program.getBasicBlocks()) {
            for (Phi phi : block.getPhis()) {
                for (Incoming incoming : phi.getIncomings()) {
                    builder.addEdge(incoming.getValue().getIndex(), phi.getReceiver().getIndex());
                }
            }
            for (Instruction instruction : block) {
                if (!(instruction instanceof AssignInstruction)) continue;
                AssignInstruction assignment = (AssignInstruction)instruction;
                builder.addEdge(assignment.getAssignee().getIndex(), assignment.getReceiver().getIndex());
            }
        }
        this.assignmentGraph = builder.build();
        this.sccIndexes = new int[this.program.variableCount()];
        if (this.assignmentGraph.size() > 0) {
            int[][] sccs = GraphUtils.findStronglyConnectedComponents(this.assignmentGraph, new int[]{0});
            for (int i = 0; i < sccs.length; ++i) {
                for (Object sccNode : (Object)sccs[i]) {
                    this.sccIndexes[sccNode] = i + 1;
                }
            }
        }
        this.notNullPredecessorsLeft = new int[this.assignmentGraph.size()];
        for (int i = 0; i < this.assignmentGraph.size(); ++i) {
            this.notNullPredecessorsLeft[i] = this.assignmentGraph.incomingEdgesCount(i);
            if (this.sccIndexes[i] <= 0) continue;
            for (int predecessor : this.assignmentGraph.outgoingEdges(i)) {
                if (this.sccIndexes[predecessor] != this.sccIndexes[i]) continue;
                int n = i;
                this.notNullPredecessorsLeft[n] = this.notNullPredecessorsLeft[n] - 1;
            }
        }
    }

    private void propagateNullness() {
        if (this.assignmentGraph.size() == 0) {
            return;
        }
        IntArrayDeque deque = new IntArrayDeque();
        int i = this.notNullVariables.nextSetBit(0);
        while (i >= 0) {
            deque.addLast(i);
            i = this.notNullVariables.nextSetBit(i + 1);
        }
        boolean[] visited = new boolean[this.program.variableCount()];
        while (!deque.isEmpty()) {
            int node = deque.removeFirst();
            if (visited[node]) continue;
            visited[node] = true;
            this.notNullVariables.set(node);
            for (int successor : this.assignmentGraph.outgoingEdges(node)) {
                if (this.sccIndexes[successor] != 0 && this.sccIndexes[successor] == this.sccIndexes[node]) continue;
                int n = successor;
                this.notNullPredecessorsLeft[n] = this.notNullPredecessorsLeft[n] - 1;
                if (this.notNullPredecessorsLeft[n] != 0) continue;
                deque.addLast(successor);
            }
        }
    }

    static class State {
        IntSet newlyNonNull = new IntOpenHashSet();
        IntSet newlyNull = new IntOpenHashSet();

        State() {
        }
    }

    class NullExtensionVisitor
    extends AbstractInstructionVisitor
    implements DominatorWalkerCallback<State> {
        State currentState;
        BasicBlock currentBlock;
        IntIntMap nullSuccessors = new IntIntOpenHashMap();
        IntIntMap notNullSuccessors = new IntIntOpenHashMap();
        private DominatorTree dom;

        NullExtensionVisitor() {
        }

        @Override
        public void setDomTree(DominatorTree domTree) {
            this.dom = domTree;
        }

        @Override
        public State visit(BasicBlock block) {
            int varIndex;
            this.currentState = new State();
            if (block.getExceptionVariable() != null) {
                NullnessInformationBuilder.this.notNullVariables.set(block.getExceptionVariable().getIndex());
            }
            this.currentBlock = block;
            if (this.nullSuccessors.containsKey(block.getIndex())) {
                varIndex = this.nullSuccessors.remove(block.getIndex());
                this.insertNullInstruction(NullnessInformationBuilder.this.program.variableAt(varIndex));
            }
            if (this.notNullSuccessors.containsKey(block.getIndex())) {
                varIndex = this.notNullSuccessors.remove(block.getIndex());
                this.insertNotNullInstruction(null, NullnessInformationBuilder.this.program.variableAt(varIndex));
            }
            for (Instruction insn : block) {
                insn.acceptVisitor(this);
            }
            return this.currentState;
        }

        @Override
        public void endVisit(BasicBlock block, State state) {
            for (int rollbackToNull : state.newlyNonNull.toArray()) {
                NullnessInformationBuilder.this.notNullVariables.clear(rollbackToNull);
            }
            for (int rollbackToNotNull : state.newlyNull.toArray()) {
                NullnessInformationBuilder.this.nullVariables.clear(rollbackToNotNull);
            }
        }

        @Override
        public void visit(GetFieldInstruction insn) {
            if (insn.getInstance() != null) {
                this.insertNotNullInstruction(insn, insn.getInstance());
            }
        }

        @Override
        public void visit(PutFieldInstruction insn) {
            if (insn.getInstance() != null) {
                this.insertNotNullInstruction(insn, insn.getInstance());
            }
        }

        @Override
        public void visit(ArrayLengthInstruction insn) {
            this.insertNotNullInstruction(insn, insn.getArray());
        }

        @Override
        public void visit(CloneArrayInstruction insn) {
            this.insertNotNullInstruction(insn, insn.getArray());
        }

        @Override
        public void visit(UnwrapArrayInstruction insn) {
            this.insertNotNullInstruction(insn, insn.getArray());
        }

        @Override
        public void visit(InvokeInstruction insn) {
            if (insn.getInstance() != null) {
                this.insertNotNullInstruction(insn, insn.getInstance());
            }
        }

        @Override
        public void visit(MonitorEnterInstruction insn) {
            this.insertNotNullInstruction(insn, insn.getObjectRef());
        }

        @Override
        public void visit(MonitorExitInstruction insn) {
            this.insertNotNullInstruction(insn, insn.getObjectRef());
        }

        @Override
        public void visit(StringConstantInstruction insn) {
            NullnessInformationBuilder.this.notNullVariables.set(insn.getReceiver().getIndex());
        }

        @Override
        public void visit(ClassConstantInstruction insn) {
            NullnessInformationBuilder.this.notNullVariables.set(insn.getReceiver().getIndex());
        }

        @Override
        public void visit(NullConstantInstruction insn) {
            NullnessInformationBuilder.this.nullVariables.set(insn.getReceiver().getIndex());
        }

        @Override
        public void visit(AssignInstruction insn) {
            NullnessInformationBuilder.this.notNullVariables.set(insn.getReceiver().getIndex(), NullnessInformationBuilder.this.notNullVariables.get(insn.getAssignee().getIndex()));
            NullnessInformationBuilder.this.nullVariables.set(insn.getReceiver().getIndex(), NullnessInformationBuilder.this.nullVariables.get(insn.getAssignee().getIndex()));
        }

        @Override
        public void visit(ConstructArrayInstruction insn) {
            NullnessInformationBuilder.this.notNullVariables.set(insn.getReceiver().getIndex());
        }

        @Override
        public void visit(ConstructInstruction insn) {
            NullnessInformationBuilder.this.notNullVariables.set(insn.getReceiver().getIndex());
        }

        @Override
        public void visit(ConstructMultiArrayInstruction insn) {
            NullnessInformationBuilder.this.notNullVariables.set(insn.getReceiver().getIndex());
        }

        @Override
        public void visit(NullCheckInstruction insn) {
            NullnessInformationBuilder.this.notNullVariables.set(insn.getReceiver().getIndex());
        }

        @Override
        public void visit(BranchingInstruction insn) {
            switch (insn.getCondition()) {
                case NOT_NULL: {
                    this.setNotNullSuccessor(insn.getConsequent(), insn.getOperand());
                    this.setNullSuccessor(insn.getAlternative(), insn.getOperand());
                    break;
                }
                case NULL: {
                    this.setNullSuccessor(insn.getConsequent(), insn.getOperand());
                    this.setNotNullSuccessor(insn.getAlternative(), insn.getOperand());
                    break;
                }
            }
        }

        @Override
        public void visit(BinaryBranchingInstruction insn) {
            Variable first = insn.getFirstOperand();
            Variable second = insn.getSecondOperand();
            if (NullnessInformationBuilder.this.nullVariables.get(first.getIndex())) {
                first = second;
            } else if (!NullnessInformationBuilder.this.nullVariables.get(second.getIndex())) {
                return;
            }
            switch (insn.getCondition()) {
                case REFERENCE_EQUAL: {
                    this.setNotNullSuccessor(insn.getConsequent(), first);
                    this.setNullSuccessor(insn.getAlternative(), first);
                    break;
                }
                case REFERENCE_NOT_EQUAL: {
                    this.setNullSuccessor(insn.getConsequent(), first);
                    this.setNotNullSuccessor(insn.getAlternative(), first);
                    break;
                }
            }
        }

        private void setNullSuccessor(BasicBlock successor, Variable value) {
            if (this.shouldSetSuccessor(successor, value)) {
                this.nullSuccessors.put(successor.getIndex(), value.getIndex());
            }
        }

        private void setNotNullSuccessor(BasicBlock successor, Variable value) {
            if (this.shouldSetSuccessor(successor, value)) {
                this.notNullSuccessors.put(successor.getIndex(), value.getIndex());
            }
        }

        private boolean shouldSetSuccessor(BasicBlock successor, Variable value) {
            for (Phi phi : successor.getPhis()) {
                if (!phi.getIncomings().stream().anyMatch(incoming -> incoming.getValue() == value)) continue;
                return false;
            }
            return true;
        }

        private void insertNotNullInstruction(Instruction currentInstruction, Variable var) {
            if (NullnessInformationBuilder.this.notNullVariables.get(var.getIndex())) {
                return;
            }
            NullCheckInstruction insn = new NullCheckInstruction();
            insn.setReceiver(var);
            insn.setValue(var);
            NullnessInformationBuilder.this.notNullInstructions.add(insn);
            if (currentInstruction != null) {
                currentInstruction.insertNext(insn);
            } else {
                this.currentBlock.addFirst(insn);
            }
            this.markAsNonNull(var);
        }

        private void insertNullInstruction(Variable var) {
            if (NullnessInformationBuilder.this.nullVariables.get(var.getIndex())) {
                return;
            }
            NullConstantInstruction insn = new NullConstantInstruction();
            insn.setReceiver(var);
            NullnessInformationBuilder.this.nullInstructions.add(insn);
            this.currentBlock.addFirst(insn);
            this.markAsNull(var);
        }

        private void markAsNonNull(Variable var) {
            if (NullnessInformationBuilder.this.notNullVariables.get(var.getIndex())) {
                return;
            }
            NullnessInformationBuilder.this.notNullVariables.set(var.getIndex());
            this.currentState.newlyNonNull.add(var.getIndex());
        }

        private void markAsNull(Variable var) {
            if (NullnessInformationBuilder.this.nullVariables.get(var.getIndex())) {
                return;
            }
            NullnessInformationBuilder.this.nullVariables.set(var.getIndex());
            this.currentState.newlyNull.add(var.getIndex());
        }
    }
}

