/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics;

import java.util.stream.Collectors;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.WasmRuntime;
import org.teavm.backend.wasm.generate.WasmClassGenerator;
import org.teavm.backend.wasm.generate.WasmMangling;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt32Subtype;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmLoadInt32;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReference;
import org.teavm.runtime.Allocator;
import org.teavm.runtime.RuntimeClass;

public class AllocatorIntrinsic
implements WasmIntrinsic {
    private static final FieldReference flagsField = new FieldReference(RuntimeClass.class.getName(), "flags");
    private int flagsFieldOffset;

    public AllocatorIntrinsic(WasmClassGenerator classGenerator) {
        this.flagsFieldOffset = classGenerator.getFieldOffset(flagsField);
    }

    @Override
    public boolean isApplicable(MethodReference methodReference) {
        if (!methodReference.getClassName().equals(Allocator.class.getName())) {
            return false;
        }
        switch (methodReference.getName()) {
            case "fillZero": 
            case "moveMemoryBlock": 
            case "isInitialized": {
                return true;
            }
        }
        return false;
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        switch (invocation.getMethod().getName()) {
            case "fillZero": 
            case "moveMemoryBlock": {
                MethodReference delegateMethod = new MethodReference(WasmRuntime.class.getName(), invocation.getMethod().getDescriptor());
                WasmCall call = new WasmCall(WasmMangling.mangleMethod(delegateMethod));
                call.getArguments().addAll(invocation.getArguments().stream().map(manager::generate).collect(Collectors.toList()));
                return call;
            }
            case "isInitialized": {
                WasmExpression pointer = manager.generate(invocation.getArguments().get(0));
                pointer = pointer instanceof WasmInt32Constant ? new WasmInt32Constant(((WasmInt32Constant)pointer).getValue() + this.flagsFieldOffset) : new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, pointer, new WasmInt32Constant(this.flagsFieldOffset));
                WasmLoadInt32 flags = new WasmLoadInt32(4, pointer, WasmInt32Subtype.INT32);
                WasmIntBinary flag = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.AND, flags, new WasmInt32Constant(1));
                return new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.EQ, flag, new WasmInt32Constant(0));
            }
        }
        throw new IllegalArgumentException(invocation.getMethod().toString());
    }
}

