/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.util;

import java.util.List;
import org.teavm.common.Graph;
import org.teavm.common.GraphBuilder;
import org.teavm.common.IntegerStack;
import org.teavm.model.BasicBlockReader;
import org.teavm.model.FieldReference;
import org.teavm.model.IncomingReader;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHandle;
import org.teavm.model.MethodReference;
import org.teavm.model.PhiReader;
import org.teavm.model.ProgramReader;
import org.teavm.model.RuntimeConstant;
import org.teavm.model.ValueType;
import org.teavm.model.VariableReader;
import org.teavm.model.instructions.AbstractInstructionReader;
import org.teavm.model.instructions.ArrayElementType;
import org.teavm.model.instructions.BinaryOperation;
import org.teavm.model.instructions.CastIntegerDirection;
import org.teavm.model.instructions.InstructionReader;
import org.teavm.model.instructions.IntegerSubtype;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.NumericOperandType;
import org.teavm.model.util.VariableType;

public class TypeInferer {
    VariableType[] types;
    GraphBuilder builder;
    GraphBuilder arrayElemBuilder;
    InstructionReader reader = new AbstractInstructionReader(){

        @Override
        public void unwrapArray(VariableReader receiver, VariableReader array, ArrayElementType elementType) {
            TypeInferer.this.builder.addEdge(array.getIndex(), receiver.getIndex());
        }

        @Override
        public void stringConstant(VariableReader receiver, String cst) {
            TypeInferer.this.types[receiver.getIndex()] = VariableType.OBJECT;
        }

        @Override
        public void nullConstant(VariableReader receiver) {
            TypeInferer.this.types[receiver.getIndex()] = VariableType.OBJECT;
        }

        @Override
        public void nullCheck(VariableReader receiver, VariableReader value) {
            TypeInferer.this.builder.addEdge(value.getIndex(), receiver.getIndex());
        }

        @Override
        public void negate(VariableReader receiver, VariableReader operand, NumericOperandType type) {
            TypeInferer.this.types[receiver.getIndex()] = TypeInferer.this.convert(type);
        }

        @Override
        public void longConstant(VariableReader receiver, long cst) {
            TypeInferer.this.types[receiver.getIndex()] = VariableType.LONG;
        }

        @Override
        public void isInstance(VariableReader receiver, VariableReader value, ValueType type) {
            TypeInferer.this.types[receiver.getIndex()] = VariableType.INT;
        }

        @Override
        public void invoke(VariableReader receiver, VariableReader instance, MethodReference method, List<? extends VariableReader> arguments, InvocationType type) {
            if (receiver != null) {
                TypeInferer.this.types[receiver.getIndex()] = TypeInferer.this.convert(method.getReturnType());
            }
        }

        @Override
        public void invokeDynamic(VariableReader receiver, VariableReader instance, MethodDescriptor method, List<? extends VariableReader> arguments, MethodHandle bootstrapMethod, List<RuntimeConstant> bootstrapArguments) {
            if (receiver != null) {
                TypeInferer.this.types[receiver.getIndex()] = TypeInferer.this.convert(method.getResultType());
            }
        }

        @Override
        public void integerConstant(VariableReader receiver, int cst) {
            TypeInferer.this.types[receiver.getIndex()] = VariableType.INT;
        }

        @Override
        public void getField(VariableReader receiver, VariableReader instance, FieldReference field, ValueType fieldType) {
            TypeInferer.this.types[receiver.getIndex()] = TypeInferer.this.convert(fieldType);
        }

        @Override
        public void getElement(VariableReader receiver, VariableReader array, VariableReader index, ArrayElementType type) {
            TypeInferer.this.arrayElemBuilder.addEdge(array.getIndex(), receiver.getIndex());
        }

        @Override
        public void floatConstant(VariableReader receiver, float cst) {
            TypeInferer.this.types[receiver.getIndex()] = VariableType.FLOAT;
        }

        @Override
        public void doubleConstant(VariableReader receiver, double cst) {
            TypeInferer.this.types[receiver.getIndex()] = VariableType.DOUBLE;
        }

        @Override
        public void createArray(VariableReader receiver, ValueType itemType, List<? extends VariableReader> dimensions) {
            TypeInferer.this.types[receiver.getIndex()] = TypeInferer.this.convert(ValueType.arrayOf(itemType));
        }

        @Override
        public void createArray(VariableReader receiver, ValueType itemType, VariableReader size) {
            TypeInferer.this.types[receiver.getIndex()] = TypeInferer.this.convert(ValueType.arrayOf(itemType));
        }

        @Override
        public void create(VariableReader receiver, String type) {
            TypeInferer.this.types[receiver.getIndex()] = VariableType.OBJECT;
        }

        @Override
        public void cloneArray(VariableReader receiver, VariableReader array) {
            TypeInferer.this.builder.addEdge(array.getIndex(), receiver.getIndex());
        }

        @Override
        public void classConstant(VariableReader receiver, ValueType cst) {
            TypeInferer.this.types[receiver.getIndex()] = VariableType.OBJECT;
        }

        @Override
        public void cast(VariableReader receiver, VariableReader value, IntegerSubtype type, CastIntegerDirection targetType) {
            TypeInferer.this.types[receiver.getIndex()] = VariableType.INT;
        }

        @Override
        public void cast(VariableReader receiver, VariableReader value, NumericOperandType sourceType, NumericOperandType targetType) {
            TypeInferer.this.types[receiver.getIndex()] = TypeInferer.this.convert(targetType);
        }

        @Override
        public void cast(VariableReader receiver, VariableReader value, ValueType targetType) {
            TypeInferer.this.types[receiver.getIndex()] = TypeInferer.this.convert(targetType);
        }

        @Override
        public void binary(BinaryOperation op, VariableReader receiver, VariableReader first, VariableReader second, NumericOperandType type) {
            switch (op) {
                case COMPARE: {
                    TypeInferer.this.types[receiver.getIndex()] = VariableType.INT;
                    break;
                }
                default: {
                    TypeInferer.this.types[receiver.getIndex()] = TypeInferer.this.convert(type);
                }
            }
        }

        @Override
        public void assign(VariableReader receiver, VariableReader assignee) {
            TypeInferer.this.builder.addEdge(assignee.getIndex(), receiver.getIndex());
        }

        @Override
        public void arrayLength(VariableReader receiver, VariableReader array) {
            TypeInferer.this.types[receiver.getIndex()] = VariableType.INT;
        }
    };

    /*
     * WARNING - void declaration
     */
    public void inferTypes(ProgramReader program, MethodReference method) {
        void var7_10;
        int i;
        int sz = program.variableCount();
        this.types = new VariableType[sz];
        this.types[0] = VariableType.OBJECT;
        for (i = 0; i < method.parameterCount(); ++i) {
            ValueType param = method.parameterType(i);
            this.types[i + 1] = this.convert(param);
        }
        this.builder = new GraphBuilder(sz);
        this.arrayElemBuilder = new GraphBuilder(sz);
        for (i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlockReader block = program.basicBlockAt(i);
            if (block.getExceptionVariable() != null) {
                this.types[block.getExceptionVariable().getIndex()] = VariableType.OBJECT;
            }
            block.readAllInstructions(this.reader);
            for (PhiReader phiReader : block.readPhis()) {
                for (IncomingReader incomingReader : phiReader.readIncomings()) {
                    this.builder.addEdge(incomingReader.getValue().getIndex(), phiReader.getReceiver().getIndex());
                }
            }
        }
        IntegerStack stack = new IntegerStack(sz);
        Graph graph = this.builder.build();
        Graph arrayElemGraph = this.arrayElemBuilder.build();
        boolean bl = false;
        while (var7_10 < sz) {
            if (!(var7_10 < graph.size() && graph.incomingEdgesCount((int)var7_10) != 0 || var7_10 < arrayElemGraph.size() && arrayElemGraph.incomingEdgesCount((int)var7_10) != 0)) {
                stack.push((int)var7_10);
            }
            ++var7_10;
        }
        boolean[] blArray = new boolean[sz];
        while (!stack.isEmpty()) {
            int node = stack.pop();
            if (blArray[node]) continue;
            blArray[node] = true;
            if (this.types[node] == null) {
                for (int pred : graph.incomingEdges(node)) {
                    if (this.types[pred] == null) continue;
                    this.types[node] = this.types[pred];
                    break;
                }
            }
            if (this.types[node] == null) {
                for (int pred : arrayElemGraph.incomingEdges(node)) {
                    if (this.types[pred] == null) continue;
                    this.types[node] = this.convertFromArray(this.types[pred]);
                    break;
                }
            }
            for (int succ : graph.outgoingEdges(node)) {
                if (blArray[succ]) continue;
                stack.push(succ);
            }
            for (int succ : arrayElemGraph.outgoingEdges(node)) {
                if (blArray[succ]) continue;
                stack.push(succ);
            }
        }
    }

    public VariableType typeOf(int variableIndex) {
        return this.types[variableIndex];
    }

    VariableType convert(ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case CHARACTER: 
                case INTEGER: {
                    return VariableType.INT;
                }
                case FLOAT: {
                    return VariableType.FLOAT;
                }
                case DOUBLE: {
                    return VariableType.DOUBLE;
                }
                case LONG: {
                    return VariableType.LONG;
                }
            }
        } else if (type instanceof ValueType.Array) {
            ValueType item = ((ValueType.Array)type).getItemType();
            return this.convertArray(item);
        }
        return VariableType.OBJECT;
    }

    VariableType convertFromArray(VariableType type) {
        switch (type) {
            case BYTE_ARRAY: 
            case SHORT_ARRAY: 
            case CHAR_ARRAY: 
            case INT_ARRAY: {
                return VariableType.INT;
            }
            case LONG_ARRAY: {
                return VariableType.LONG;
            }
            case FLOAT_ARRAY: {
                return VariableType.FLOAT;
            }
            case DOUBLE_ARRAY: {
                return VariableType.DOUBLE;
            }
        }
        return VariableType.OBJECT;
    }

    VariableType convert(NumericOperandType type) {
        switch (type) {
            case INT: {
                return VariableType.INT;
            }
            case LONG: {
                return VariableType.LONG;
            }
            case FLOAT: {
                return VariableType.FLOAT;
            }
            case DOUBLE: {
                return VariableType.DOUBLE;
            }
        }
        throw new AssertionError();
    }

    VariableType convertArray(ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: 
                case BYTE: {
                    return VariableType.BYTE_ARRAY;
                }
                case SHORT: {
                    return VariableType.SHORT_ARRAY;
                }
                case CHARACTER: {
                    return VariableType.CHAR_ARRAY;
                }
                case INTEGER: {
                    return VariableType.INT_ARRAY;
                }
                case FLOAT: {
                    return VariableType.FLOAT_ARRAY;
                }
                case DOUBLE: {
                    return VariableType.DOUBLE_ARRAY;
                }
                case LONG: {
                    return VariableType.LONG_ARRAY;
                }
            }
        }
        return VariableType.OBJECT_ARRAY;
    }
}

