/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.optimization;

import com.carrotsearch.hppc.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.teavm.dependency.DependencyInfo;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.Incoming;
import org.teavm.model.Instruction;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.analysis.ClassInference;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.BinaryBranchingInstruction;
import org.teavm.model.instructions.BranchingInstruction;
import org.teavm.model.instructions.EmptyInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.JumpInstruction;
import org.teavm.model.instructions.SwitchInstruction;
import org.teavm.model.optimization.UnreachableBasicBlockEliminator;
import org.teavm.model.util.BasicBlockMapper;
import org.teavm.model.util.InstructionTransitionExtractor;
import org.teavm.model.util.InstructionVariableMapper;
import org.teavm.model.util.ProgramUtils;

public class Inlining {
    private static final int DEFAULT_THRESHOLD = 17;
    private static final int MAX_DEPTH = 7;
    private IntArrayList depthsByBlock;
    private Set<Instruction> instructionsToSkip;

    public void apply(Program program, MethodReference method, ClassReaderSource classes, DependencyInfo dependencyInfo) {
        this.depthsByBlock = new IntArrayList(program.basicBlockCount());
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            this.depthsByBlock.add(0);
        }
        this.instructionsToSkip = new HashSet<Instruction>();
        while (this.applyOnce(program, classes)) {
            this.devirtualize(program, method, dependencyInfo);
        }
        this.depthsByBlock = null;
        this.instructionsToSkip = null;
        new UnreachableBasicBlockEliminator().optimize(program);
    }

    private boolean applyOnce(Program program, ClassReaderSource classSource) {
        List<PlanEntry> plan = this.buildPlan(program, classSource, 0);
        if (plan.isEmpty()) {
            return false;
        }
        this.execPlan(program, plan, 0);
        return true;
    }

    private void execPlan(Program program, List<PlanEntry> plan, int offset) {
        for (PlanEntry entry : plan) {
            this.execPlanEntry(program, entry, offset);
        }
    }

    private void execPlanEntry(Program program, PlanEntry planEntry, int offset) {
        BasicBlock block = program.basicBlockAt(planEntry.targetBlock + offset);
        InvokeInstruction invoke = (InvokeInstruction)planEntry.targetInstruction;
        BasicBlock splitBlock = program.createBasicBlock();
        BasicBlock firstInlineBlock = program.createBasicBlock();
        Program inlineProgram = planEntry.program;
        for (int i = 1; i < inlineProgram.basicBlockCount(); ++i) {
            program.createBasicBlock();
        }
        while (this.depthsByBlock.size() < program.basicBlockCount()) {
            this.depthsByBlock.add(planEntry.depth + 1);
        }
        int variableOffset = program.variableCount();
        for (int i = 0; i < inlineProgram.variableCount(); ++i) {
            program.createVariable();
        }
        while (planEntry.targetInstruction.getNext() != null) {
            Instruction insn = planEntry.targetInstruction.getNext();
            insn.delete();
            splitBlock.add(insn);
        }
        splitBlock.getTryCatchBlocks().addAll(ProgramUtils.copyTryCatches(block, program));
        invoke.delete();
        if (invoke.getInstance() == null || invoke.getMethod().getName().equals("<init>")) {
            InitClassInstruction clinit = new InitClassInstruction();
            clinit.setClassName(invoke.getMethod().getClassName());
            block.add(clinit);
        }
        JumpInstruction jumpToInlinedProgram = new JumpInstruction();
        jumpToInlinedProgram.setTarget(firstInlineBlock);
        block.add(jumpToInlinedProgram);
        for (int i = 0; i < inlineProgram.basicBlockCount(); ++i) {
            BasicBlock blockToInline = inlineProgram.basicBlockAt(i);
            BasicBlock inlineBlock = program.basicBlockAt(firstInlineBlock.getIndex() + i);
            while (blockToInline.getFirstInstruction() != null) {
                Instruction insn = blockToInline.getFirstInstruction();
                insn.delete();
                inlineBlock.add(insn);
            }
            ArrayList<Phi> phis = new ArrayList<Phi>(blockToInline.getPhis());
            blockToInline.getPhis().clear();
            inlineBlock.getPhis().addAll(phis);
            ArrayList<TryCatchBlock> tryCatches = new ArrayList<TryCatchBlock>(blockToInline.getTryCatchBlocks());
            blockToInline.getTryCatchBlocks().clear();
            inlineBlock.getTryCatchBlocks().addAll(tryCatches);
            inlineBlock.setExceptionVariable(blockToInline.getExceptionVariable());
        }
        BasicBlockMapper blockMapper = new BasicBlockMapper(b -> program.basicBlockAt(b.getIndex() + firstInlineBlock.getIndex()));
        InstructionVariableMapper variableMapper = new InstructionVariableMapper(var -> {
            if (var.getIndex() == 0) {
                return invoke.getInstance();
            }
            if (var.getIndex() <= invoke.getArguments().size()) {
                return invoke.getArguments().get(var.getIndex() - 1);
            }
            return program.variableAt(var.getIndex() + variableOffset);
        });
        ArrayList<Incoming> resultVariables = new ArrayList<Incoming>();
        for (int i = 0; i < inlineProgram.basicBlockCount(); ++i) {
            BasicBlock mappedBlock = program.basicBlockAt(firstInlineBlock.getIndex() + i);
            blockMapper.transform(mappedBlock);
            variableMapper.apply(mappedBlock);
            mappedBlock.getTryCatchBlocks().addAll(ProgramUtils.copyTryCatches(block, program));
            Instruction lastInsn = mappedBlock.getLastInstruction();
            if (!(lastInsn instanceof ExitInstruction)) continue;
            ExitInstruction exit = (ExitInstruction)lastInsn;
            JumpInstruction exitReplacement = new JumpInstruction();
            exitReplacement.setTarget(splitBlock);
            exitReplacement.setLocation(exit.getLocation());
            exit.replace(exitReplacement);
            if (exit.getValueToReturn() == null) continue;
            Incoming resultIncoming = new Incoming();
            resultIncoming.setSource(mappedBlock);
            resultIncoming.setValue(exit.getValueToReturn());
            resultVariables.add(resultIncoming);
        }
        if (!resultVariables.isEmpty() && invoke.getReceiver() != null) {
            if (resultVariables.size() == 1) {
                AssignInstruction resultAssignment = new AssignInstruction();
                resultAssignment.setReceiver(invoke.getReceiver());
                resultAssignment.setAssignee(((Incoming)resultVariables.get(0)).getValue());
                splitBlock.addFirst(resultAssignment);
            } else {
                Phi resultPhi = new Phi();
                resultPhi.setReceiver(invoke.getReceiver());
                resultPhi.getIncomings().addAll(resultVariables);
                splitBlock.getPhis().add(resultPhi);
            }
        }
        InstructionTransitionExtractor transitionExtractor = new InstructionTransitionExtractor();
        Instruction splitLastInsn = splitBlock.getLastInstruction();
        if (splitLastInsn != null) {
            splitLastInsn.acceptVisitor(transitionExtractor);
            if (transitionExtractor.getTargets() != null) {
                List incomings = Arrays.stream(transitionExtractor.getTargets()).flatMap(bb -> bb.getPhis().stream()).flatMap(phi -> phi.getIncomings().stream()).filter(incoming -> incoming.getSource() == block).collect(Collectors.toList());
                for (Incoming incoming2 : incomings) {
                    incoming2.setSource(splitBlock);
                }
            }
        }
        this.execPlan(program, planEntry.innerPlan, firstInlineBlock.getIndex());
    }

    private List<PlanEntry> buildPlan(Program program, ClassReaderSource classSource, int depth) {
        if (depth >= 7) {
            return Collections.emptyList();
        }
        ArrayList<PlanEntry> plan = new ArrayList<PlanEntry>();
        int ownComplexity = this.getComplexity(program);
        int originalDepth = depth;
        for (BasicBlock block : program.getBasicBlocks()) {
            if (!block.getTryCatchBlocks().isEmpty() || originalDepth == 0 && (depth = this.depthsByBlock.get(block.getIndex())) >= 7) continue;
            for (Instruction insn : block) {
                InvokeInstruction invoke;
                if (this.instructionsToSkip.contains(insn) || !(insn instanceof InvokeInstruction) || (invoke = (InvokeInstruction)insn).getType() == InvocationType.VIRTUAL) continue;
                MethodReader invokedMethod = this.getMethod(classSource, invoke.getMethod());
                if (invokedMethod == null || invokedMethod.getProgram() == null || invokedMethod.getProgram().basicBlockCount() == 0) {
                    this.instructionsToSkip.add(insn);
                    continue;
                }
                Program invokedProgram = ProgramUtils.copy(invokedMethod.getProgram());
                int complexityThreshold = 17;
                if (ownComplexity < 17) {
                    complexityThreshold += 17;
                }
                if (this.getComplexity(invokedProgram) > complexityThreshold) {
                    this.instructionsToSkip.add(insn);
                    continue;
                }
                PlanEntry entry = new PlanEntry();
                entry.targetBlock = block.getIndex();
                entry.targetInstruction = insn;
                entry.program = invokedProgram;
                entry.innerPlan.addAll(this.buildPlan(invokedProgram, classSource, depth + 1));
                entry.depth = depth;
                plan.add(entry);
            }
        }
        Collections.reverse(plan);
        return plan;
    }

    private MethodReader getMethod(ClassReaderSource classSource, MethodReference methodRef) {
        ClassReader cls = classSource.get(methodRef.getClassName());
        return cls != null ? cls.getMethod(methodRef.getDescriptor()) : null;
    }

    private int getComplexity(Program program) {
        int complexity = 0;
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            int nopCount = 0;
            int invokeCount = 0;
            for (Instruction insn : block) {
                if (insn instanceof EmptyInstruction) {
                    ++nopCount;
                    continue;
                }
                if (!(insn instanceof InvokeInstruction)) continue;
                InvokeInstruction invoke = (InvokeInstruction)insn;
                invokeCount += invoke.getArguments().size();
                if (invoke.getInstance() == null) continue;
                ++invokeCount;
            }
            complexity += block.instructionCount() - nopCount + invokeCount;
            Instruction lastInsn = block.getLastInstruction();
            if (lastInsn instanceof SwitchInstruction) {
                complexity += 3;
                continue;
            }
            if (!(lastInsn instanceof BinaryBranchingInstruction) && !(lastInsn instanceof BranchingInstruction)) continue;
            complexity += 2;
        }
        return complexity;
    }

    private void devirtualize(Program program, MethodReference method, DependencyInfo dependencyInfo) {
        ClassInference inference = new ClassInference(dependencyInfo);
        inference.infer(program, method);
        for (BasicBlock block : program.getBasicBlocks()) {
            for (Instruction instruction : block) {
                InvokeInstruction invoke;
                if (!(instruction instanceof InvokeInstruction) || (invoke = (InvokeInstruction)instruction).getType() != InvocationType.VIRTUAL) continue;
                HashSet<MethodReference> implementations = new HashSet<MethodReference>();
                for (String className : inference.classesOf(invoke.getInstance().getIndex())) {
                    MethodReference rawMethod = new MethodReference(className, invoke.getMethod().getDescriptor());
                    MethodReader resolvedMethod = dependencyInfo.getClassSource().resolve(rawMethod);
                    if (resolvedMethod == null) continue;
                    implementations.add(resolvedMethod.getReference());
                }
                if (implementations.size() != 1) continue;
                invoke.setType(InvocationType.SPECIAL);
                invoke.setMethod((MethodReference)implementations.iterator().next());
            }
        }
    }

    private class PlanEntry {
        int targetBlock;
        Instruction targetInstruction;
        Program program;
        int depth;
        final List<PlanEntry> innerPlan = new ArrayList<PlanEntry>();

        private PlanEntry() {
        }
    }
}

