/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.lowlevel;

import java.util.HashMap;
import java.util.Map;
import org.teavm.interop.Unmanaged;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;

public class ManagedMethodRepository {
    private ClassReaderSource classSource;
    private Map<MethodReference, Boolean> cache = new HashMap<MethodReference, Boolean>();

    public ManagedMethodRepository(ClassReaderSource classSource) {
        this.classSource = classSource;
    }

    public boolean isManaged(MethodReference methodReference) {
        return this.cache.computeIfAbsent(methodReference, this::computeIsManaged);
    }

    private boolean computeIsManaged(MethodReference methodReference) {
        ClassReader cls = this.classSource.get(methodReference.getClassName());
        if (cls == null) {
            return true;
        }
        if (cls.getAnnotations().get(Unmanaged.class.getName()) != null) {
            return false;
        }
        MethodReader method = cls.getMethod(methodReference.getDescriptor());
        return method.getAnnotations().get(Unmanaged.class.getName()) == null;
    }
}

