/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import org.teavm.common.DefaultDominatorTree;
import org.teavm.common.DominatorTree;
import org.teavm.common.DominatorTreeBuilder;
import org.teavm.common.Graph;
import org.teavm.common.GraphBuilder;
import org.teavm.common.GraphSplittingBackend;
import org.teavm.common.IntegerArray;
import org.teavm.common.IntegerStack;
import org.teavm.common.IrreducibleGraphConverter;

public final class GraphUtils {
    static final byte NONE = 0;
    static final byte VISITING = 1;
    static final byte VISITED = 2;

    private GraphUtils() {
    }

    public static int[] findBackEdges(Graph graph) {
        int sz = graph.size();
        int[] stack = new int[sz * 2];
        int stackSize = 0;
        byte[] state = new byte[sz];
        for (int i = 0; i < sz; ++i) {
            if (graph.incomingEdgesCount(i) != 0) continue;
            stack[stackSize++] = i;
        }
        IntegerArray result = new IntegerArray(2);
        block9: while (stackSize > 0) {
            int node = stack[--stackSize];
            switch (state[node]) {
                case 0: {
                    state[node] = 1;
                    stack[stackSize++] = node;
                    block10: for (int next : graph.outgoingEdges(node)) {
                        switch (state[next]) {
                            case 0: {
                                stack[stackSize++] = next;
                                continue block10;
                            }
                            case 1: {
                                result.add(node);
                                result.add(next);
                            }
                        }
                    }
                    continue block9;
                }
                case 1: {
                    state[node] = 2;
                }
            }
        }
        return result.getAll();
    }

    public static boolean isIrreducible(Graph graph) {
        DominatorTree dom = GraphUtils.buildDominatorTree(graph);
        int[] backEdges = GraphUtils.findBackEdges(graph);
        for (int i = 0; i < backEdges.length; i += 2) {
            if (dom.dominates(backEdges[i + 1], backEdges[i])) continue;
            return true;
        }
        return false;
    }

    public static Graph subgraph(Graph graph, IntPredicate filter) {
        if (graph instanceof FilteredGraph) {
            FilteredGraph filteredGraph = (FilteredGraph)graph;
            IntPredicate oldFilter = filteredGraph.filter;
            IntPredicate newFilter = v -> oldFilter.test(v) && filter.test(v);
            return new FilteredGraph(filteredGraph.innerGraph, newFilter);
        }
        return new FilteredGraph(graph, filter);
    }

    public static int[][] findStronglyConnectedComponents(Graph graph, int[] start) {
        ArrayList<int[]> components = new ArrayList<int[]>();
        int[] visitIndex = new int[graph.size()];
        int[] headerIndex = new int[graph.size()];
        IntegerStack currentComponent = new IntegerStack(1);
        boolean[] inCurrentComponent = new boolean[graph.size()];
        int lastIndex = 1;
        IntegerStack stack = new IntegerStack(graph.size());
        IntegerStack modeStack = new IntegerStack(graph.size());
        int[] expectedMode = new int[graph.size()];
        for (int startNode : start) {
            stack.push(startNode);
            modeStack.push(0);
        }
        while (!stack.isEmpty()) {
            int mode;
            int node = stack.pop();
            if (expectedMode[node] != (mode = modeStack.pop())) continue;
            int n = node;
            expectedMode[n] = expectedMode[n] + 1;
            if (mode == 1) {
                int componentMember;
                expectedMode[node] = 2;
                int hdr = headerIndex[node];
                int[] startNode = graph.outgoingEdges(node);
                int n2 = startNode.length;
                for (int i = 0; i < n2; ++i) {
                    int successor = startNode[i];
                    if (visitIndex[node] < visitIndex[successor]) {
                        hdr = Math.min(hdr, headerIndex[successor]);
                        continue;
                    }
                    if (!inCurrentComponent[successor]) continue;
                    hdr = Math.min(hdr, visitIndex[successor]);
                }
                headerIndex[node] = hdr;
                if (hdr != visitIndex[node]) continue;
                IntegerArray componentMembers = new IntegerArray(graph.size());
                do {
                    componentMember = currentComponent.pop();
                    inCurrentComponent[componentMember] = false;
                    componentMembers.add(componentMember);
                } while (componentMember != node);
                components.add(componentMembers.getAll());
                continue;
            }
            if (mode != 0) continue;
            visitIndex[node] = lastIndex;
            headerIndex[node] = lastIndex++;
            currentComponent.push(node);
            inCurrentComponent[node] = true;
            stack.push(node);
            modeStack.push(1);
            for (int successor : graph.outgoingEdges(node)) {
                stack.push(successor);
                modeStack.push(0);
            }
        }
        return (int[][])components.toArray((T[])new int[0][]);
    }

    public static DominatorTree buildDominatorTree(Graph graph) {
        DominatorTreeBuilder builder = new DominatorTreeBuilder(graph);
        builder.build();
        return new DefaultDominatorTree(builder.dominators, builder.vertices);
    }

    public static Graph buildDominatorGraph(DominatorTree domTree, int sz) {
        GraphBuilder graph = new GraphBuilder(sz);
        for (int i = 0; i < sz; ++i) {
            int idom = domTree.immediateDominatorOf(i);
            if (idom < 0) continue;
            graph.addEdge(idom, i);
        }
        return graph.build();
    }

    public static int[] dfs(Graph graph) {
        int[] result = new int[graph.size()];
        int[] state = new int[graph.size()];
        int[] stack = new int[graph.size() * 2];
        int top = 0;
        stack[top++] = 0;
        int index = graph.size();
        block4: while (top > 0) {
            int node = stack[--top];
            switch (state[node]) {
                case 0: {
                    state[node] = 1;
                    stack[top++] = node;
                    for (int successor : graph.outgoingEdges(node)) {
                        if (state[successor] != 0) continue;
                        stack[top++] = node;
                    }
                    continue block4;
                }
                case 1: {
                    result[node] = --index;
                    state[node] = 2;
                }
            }
        }
        return result;
    }

    public static void splitIrreducibleGraph(Graph graph, int[] weights, GraphSplittingBackend backend) {
        new IrreducibleGraphConverter().convertToReducible(graph, weights, backend);
    }

    public static int[][] findDominanceFrontiers(Graph cfg, DominatorTree domTree) {
        IntegerArray[] tmpFrontiers = new IntegerArray[cfg.size()];
        int[][] domFrontiers = new int[cfg.size()][];
        int[] descCount = new int[cfg.size()];
        for (int i = 0; i < cfg.size(); ++i) {
            int idom = domTree.immediateDominatorOf(i);
            if (idom < 0) continue;
            int n = idom;
            descCount[n] = descCount[n] + 1;
        }
        int[] stack = new int[cfg.size() * 2];
        int head = 0;
        for (int i = 0; i < cfg.size(); ++i) {
            if (descCount[i] != 0) continue;
            stack[head++] = i;
        }
        while (head > 0) {
            int node;
            IntegerArray frontier;
            if ((frontier = tmpFrontiers[node = stack[--head]]) == null) {
                frontier = new IntegerArray(1);
            }
            int idom = domTree.immediateDominatorOf(node);
            for (int successor : cfg.outgoingEdges(node)) {
                if (domTree.immediateDominatorOf(successor) == node) continue;
                frontier.add(successor);
            }
            tmpFrontiers[node] = null;
            int[] frontierSet = GraphUtils.makeSet(frontier);
            domFrontiers[node] = frontierSet;
            if (idom < 0) continue;
            for (int element : frontierSet) {
                if (domTree.immediateDominatorOf(element) == idom) continue;
                IntegerArray idomFrontier = tmpFrontiers[idom];
                if (idomFrontier == null) {
                    tmpFrontiers[idom] = idomFrontier = new IntegerArray(1);
                }
                idomFrontier.add(element);
            }
            int n = idom;
            descCount[n] = descCount[n] - 1;
            if (descCount[n] != 0) continue;
            stack[head++] = idom;
        }
        return domFrontiers;
    }

    private static int[] makeSet(IntegerArray array) {
        int[] items = array.getAll();
        int[] set = new int[items.length];
        int sz = 0;
        int last = -1;
        for (int item : items) {
            if (item == last) continue;
            set[sz++] = item;
            last = item;
        }
        if (sz != set.length) {
            set = Arrays.copyOf(set, sz);
        }
        return set;
    }

    public static String printToDot(Graph graph) {
        StringBuilder sb = new StringBuilder("digraph G {\n");
        for (int i = 0; i < graph.size(); ++i) {
            String successors = Arrays.stream(graph.outgoingEdges(i)).mapToObj(String::valueOf).collect(Collectors.joining(", "));
            sb.append("  ").append(i).append(" -> {").append(successors).append("}\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private static class FilteredGraph
    implements Graph {
        final Graph innerGraph;
        final IntPredicate filter;

        public FilteredGraph(Graph innerGraph, IntPredicate filter) {
            this.innerGraph = innerGraph;
            this.filter = filter;
        }

        @Override
        public int size() {
            return this.innerGraph.size();
        }

        @Override
        public int[] incomingEdges(int node) {
            if (!this.filter.test(node)) {
                return new int[0];
            }
            return this.filterNodes(this.innerGraph.incomingEdges(node));
        }

        private int[] filterNodes(int[] nodes) {
            int j = 0;
            for (int v : nodes) {
                if (!this.filter.test(v)) continue;
                nodes[j++] = v;
            }
            if (j < nodes.length) {
                nodes = Arrays.copyOf(nodes, j);
            }
            return nodes;
        }

        @Override
        public int copyIncomingEdges(int node, int[] target) {
            if (!this.filter.test(node)) {
                return 0;
            }
            int[] result = this.incomingEdges(node);
            System.arraycopy(result, 0, target, 0, result.length);
            return result.length;
        }

        @Override
        public int[] outgoingEdges(int node) {
            if (!this.filter.test(node)) {
                return new int[0];
            }
            return this.filterNodes(this.innerGraph.outgoingEdges(node));
        }

        @Override
        public int copyOutgoingEdges(int node, int[] target) {
            if (!this.filter.test(node)) {
                return 0;
            }
            int[] result = this.outgoingEdges(node);
            System.arraycopy(result, 0, target, 0, result.length);
            return result.length;
        }

        @Override
        public int incomingEdgesCount(int node) {
            return this.incomingEdges(node).length;
        }

        @Override
        public int outgoingEdgesCount(int node) {
            return this.outgoingEdges(node).length;
        }
    }
}

