/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.codegen;

import java.util.HashMap;
import java.util.Map;
import org.teavm.backend.javascript.codegen.AliasProvider;
import org.teavm.backend.javascript.codegen.NamingException;
import org.teavm.backend.javascript.codegen.NamingStrategy;
import org.teavm.model.AccessLevel;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;

public class DefaultNamingStrategy
implements NamingStrategy {
    private final AliasProvider aliasProvider;
    private final ClassReaderSource classSource;
    private final Map<String, String> aliases = new HashMap<String, String>();
    private final Map<String, String> privateAliases = new HashMap<String, String>();
    private final Map<String, String> classAliases = new HashMap<String, String>();
    private final Map<String, String> fieldAliases = new HashMap<String, String>();
    private final Map<String, String> staticFieldAliases = new HashMap<String, String>();
    private final Map<String, String> functionAliases = new HashMap<String, String>();

    public DefaultNamingStrategy(AliasProvider aliasProvider, ClassReaderSource classSource) {
        this.aliasProvider = aliasProvider;
        this.classSource = classSource;
    }

    @Override
    public String getNameFor(String cls) {
        return this.classAliases.computeIfAbsent(cls, key -> this.aliasProvider.getClassAlias(cls));
    }

    @Override
    public String getNameFor(MethodDescriptor method) {
        String key = method.toString();
        String alias = this.aliases.get(key);
        if (alias == null) {
            alias = this.aliasProvider.getMethodAlias(method);
            this.aliases.put(key, alias);
        }
        return alias;
    }

    @Override
    public String getFullNameFor(MethodReference method) throws NamingException {
        return this.getFullNameFor(method, 'M');
    }

    @Override
    public String getNameForInit(MethodReference method) throws NamingException {
        return this.getFullNameFor(method, 'I');
    }

    private String getFullNameFor(MethodReference method, char classifier) throws NamingException {
        MethodReference originalMethod = method;
        if ((method = this.getRealMethod(method)) == null) {
            throw new NamingException("Can't provide name for method as it was not found: " + originalMethod);
        }
        MethodReference resolvedMethod = method;
        return this.privateAliases.computeIfAbsent(classifier + method.toString(), key -> this.aliasProvider.getStaticMethodAlias(resolvedMethod));
    }

    @Override
    public String getNameFor(FieldReference field) {
        String realCls = this.getRealFieldOwner(field.getClassName(), field.getFieldName());
        if (!realCls.equals(field.getClassName())) {
            String alias = this.getNameFor(new FieldReference(realCls, field.getFieldName()));
            this.fieldAliases.put(field.getClassName() + "#" + field, alias);
            return alias;
        }
        return this.fieldAliases.computeIfAbsent(realCls + "#" + field, key -> this.aliasProvider.getFieldAlias(field));
    }

    @Override
    public String getFullNameFor(FieldReference field) throws NamingException {
        String realCls = this.getRealFieldOwner(field.getClassName(), field.getFieldName());
        if (!realCls.equals(field.getClassName())) {
            String alias = this.getNameFor(new FieldReference(realCls, field.getFieldName()));
            this.staticFieldAliases.put(field.getClassName() + "#" + field, alias);
            return alias;
        }
        return this.staticFieldAliases.computeIfAbsent(realCls + "#" + field, key -> this.aliasProvider.getStaticFieldAlias(field));
    }

    @Override
    public String getNameForFunction(String name) throws NamingException {
        return this.functionAliases.computeIfAbsent(name, key -> this.aliasProvider.getFunctionAlias(name));
    }

    private MethodReference getRealMethod(MethodReference methodRef) {
        String className = methodRef.getClassName();
        while (className != null) {
            ClassReader cls = this.classSource.get(className);
            if (cls == null) {
                return null;
            }
            MethodReader method = cls.getMethod(methodRef.getDescriptor());
            if (method != null) {
                if (method.getLevel() == AccessLevel.PRIVATE && !className.equals(methodRef.getClassName())) {
                    return null;
                }
                return new MethodReference(className, method.getDescriptor());
            }
            className = cls.getParent();
        }
        return null;
    }

    private String getRealFieldOwner(String cls, String field) {
        String initialCls = cls;
        while (!this.fieldExists(cls, field)) {
            ClassReader clsHolder = this.classSource.get(cls);
            if ((cls = clsHolder.getParent()) != null) continue;
            throw new NamingException("Can't provide name for field as the field not found: " + initialCls + "." + field);
        }
        return cls;
    }

    private boolean fieldExists(String cls, String field) {
        ClassReader classHolder = this.classSource.get(cls);
        return classHolder.getField(field) != null;
    }
}

