/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.ast.ClassNode;
import org.teavm.ast.cache.EmptyRegularMethodNodeCache;
import org.teavm.ast.cache.MethodNodeCache;
import org.teavm.ast.decompilation.Decompiler;
import org.teavm.backend.javascript.TeaVMJavaScriptHost;
import org.teavm.backend.javascript.codegen.AliasProvider;
import org.teavm.backend.javascript.codegen.DefaultAliasProvider;
import org.teavm.backend.javascript.codegen.DefaultNamingStrategy;
import org.teavm.backend.javascript.codegen.MinifyingAliasProvider;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.codegen.SourceWriterBuilder;
import org.teavm.backend.javascript.rendering.Renderer;
import org.teavm.backend.javascript.rendering.RenderingContext;
import org.teavm.backend.javascript.spi.GeneratedBy;
import org.teavm.backend.javascript.spi.Generator;
import org.teavm.backend.javascript.spi.InjectedBy;
import org.teavm.backend.javascript.spi.Injector;
import org.teavm.debugging.information.DebugInformationEmitter;
import org.teavm.debugging.information.DummyDebugInformationEmitter;
import org.teavm.debugging.information.SourceLocation;
import org.teavm.dependency.DependencyChecker;
import org.teavm.dependency.DependencyListener;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.BasicBlock;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ElementModifier;
import org.teavm.model.ListableClassHolderSource;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.TextLocation;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.RaiseInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.transformation.ClassInitializerInsertionTransformer;
import org.teavm.model.util.AsyncMethodFinder;
import org.teavm.model.util.ProgramUtils;
import org.teavm.vm.BuildTarget;
import org.teavm.vm.RenderingException;
import org.teavm.vm.TeaVMEntryPoint;
import org.teavm.vm.TeaVMTarget;
import org.teavm.vm.TeaVMTargetController;
import org.teavm.vm.spi.RendererListener;
import org.teavm.vm.spi.TeaVMHostExtension;

public class JavaScriptTarget
implements TeaVMTarget,
TeaVMJavaScriptHost {
    private TeaVMTargetController controller;
    private boolean minifying = true;
    private final Map<MethodReference, Generator> methodGenerators = new HashMap<MethodReference, Generator>();
    private final Map<MethodReference, Injector> methodInjectors = new HashMap<MethodReference, Injector>();
    private final List<RendererListener> rendererListeners = new ArrayList<RendererListener>();
    private DebugInformationEmitter debugEmitter;
    private MethodNodeCache astCache = new EmptyRegularMethodNodeCache();
    private final Set<MethodReference> asyncMethods = new HashSet<MethodReference>();
    private final Set<MethodReference> asyncFamilyMethods = new HashSet<MethodReference>();
    private ClassInitializerInsertionTransformer clinitInsertionTransformer;

    @Override
    public List<ClassHolderTransformer> getTransformers() {
        return Collections.emptyList();
    }

    @Override
    public List<DependencyListener> getDependencyListeners() {
        return Collections.emptyList();
    }

    @Override
    public void setController(TeaVMTargetController controller) {
        this.controller = controller;
        this.clinitInsertionTransformer = new ClassInitializerInsertionTransformer(controller.getUnprocessedClassSource());
    }

    @Override
    public void add(RendererListener listener) {
        this.rendererListeners.add(listener);
    }

    @Override
    public void add(MethodReference methodRef, Generator generator) {
        this.methodGenerators.put(methodRef, generator);
    }

    @Override
    public void add(MethodReference methodRef, Injector injector) {
        this.methodInjectors.put(methodRef, injector);
    }

    public boolean isMinifying() {
        return this.minifying;
    }

    public void setMinifying(boolean minifying) {
        this.minifying = minifying;
    }

    public MethodNodeCache getAstCache() {
        return this.astCache;
    }

    public void setAstCache(MethodNodeCache methodAstCache) {
        this.astCache = methodAstCache;
    }

    public DebugInformationEmitter getDebugEmitter() {
        return this.debugEmitter;
    }

    public void setDebugEmitter(DebugInformationEmitter debugEmitter) {
        this.debugEmitter = debugEmitter;
    }

    @Override
    public boolean requiresRegisterAllocation() {
        return true;
    }

    @Override
    public List<TeaVMHostExtension> getHostExtensions() {
        return Collections.singletonList(this);
    }

    @Override
    public void contributeDependencies(DependencyChecker dependencyChecker) {
        dependencyChecker.linkMethod(new MethodReference(Class.class.getName(), "getClass", ValueType.object("org.teavm.platform.PlatformClass"), ValueType.parse(Class.class)), null).use();
        dependencyChecker.linkMethod(new MethodReference(String.class, "<init>", char[].class, Void.TYPE), null).use();
        dependencyChecker.linkMethod(new MethodReference(String.class, "getChars", Integer.TYPE, Integer.TYPE, char[].class, Integer.TYPE, Void.TYPE), null).use();
        MethodDependency internDep = dependencyChecker.linkMethod(new MethodReference(String.class, "intern", String.class), null);
        internDep.getVariable(0).propagate(dependencyChecker.getType("java.lang.String"));
        internDep.use();
        dependencyChecker.linkMethod(new MethodReference(String.class, "length", Integer.TYPE), null).use();
        dependencyChecker.linkMethod(new MethodReference(Object.class, "clone", Object.class), null).use();
        dependencyChecker.linkMethod(new MethodReference(Thread.class, "currentThread", Thread.class), null).use();
        dependencyChecker.linkMethod(new MethodReference(Thread.class, "getMainThread", Thread.class), null).use();
        dependencyChecker.linkMethod(new MethodReference(Thread.class, "setCurrentThread", Thread.class, Void.TYPE), null).use();
        MethodDependency exceptionCons = dependencyChecker.linkMethod(new MethodReference(NoClassDefFoundError.class, "<init>", String.class, Void.TYPE), null);
        exceptionCons.getVariable(0).propagate(dependencyChecker.getType(NoClassDefFoundError.class.getName()));
        exceptionCons.getVariable(1).propagate(dependencyChecker.getType("java.lang.String"));
        exceptionCons = dependencyChecker.linkMethod(new MethodReference(NoSuchFieldError.class, "<init>", String.class, Void.TYPE), null);
        exceptionCons.use();
        exceptionCons.getVariable(0).propagate(dependencyChecker.getType(NoSuchFieldError.class.getName()));
        exceptionCons.getVariable(1).propagate(dependencyChecker.getType("java.lang.String"));
        exceptionCons = dependencyChecker.linkMethod(new MethodReference(NoSuchMethodError.class, "<init>", String.class, Void.TYPE), null);
        exceptionCons.use();
        exceptionCons.getVariable(0).propagate(dependencyChecker.getType(NoSuchMethodError.class.getName()));
        exceptionCons.getVariable(1).propagate(dependencyChecker.getType("java.lang.String"));
    }

    @Override
    public void emit(ListableClassHolderSource classes, BuildTarget target, String outputName) {
        try (OutputStream output = target.createResource(outputName);
             OutputStreamWriter writer = new OutputStreamWriter(output, "UTF-8");){
            this.emit(classes, writer, target);
        }
        catch (IOException e) {
            throw new RenderingException(e);
        }
    }

    @Override
    public void afterOptimizations(Program program, MethodReader method, ListableClassReaderSource classSource) {
        this.clinitInsertionTransformer.apply(method, program);
    }

    private void emit(ListableClassHolderSource classes, Writer writer, BuildTarget target) {
        List<ClassNode> clsNodes = this.modelToAst(classes);
        if (this.controller.wasCancelled()) {
            return;
        }
        AliasProvider aliasProvider = this.minifying ? new MinifyingAliasProvider() : new DefaultAliasProvider();
        DefaultNamingStrategy naming = new DefaultNamingStrategy(aliasProvider, this.controller.getUnprocessedClassSource());
        SourceWriterBuilder builder = new SourceWriterBuilder(naming);
        builder.setMinified(this.minifying);
        SourceWriter sourceWriter = builder.build(writer);
        DebugInformationEmitter debugEmitterToUse = this.debugEmitter;
        if (debugEmitterToUse == null) {
            debugEmitterToUse = new DummyDebugInformationEmitter();
        }
        RenderingContext renderingContext = new RenderingContext(debugEmitterToUse, classes, this.controller.getClassLoader(), this.controller.getServices(), this.controller.getProperties(), naming);
        renderingContext.setMinifying(this.minifying);
        Renderer renderer = new Renderer(sourceWriter, this.asyncMethods, this.asyncFamilyMethods, this.controller.getDiagnostics(), renderingContext);
        renderer.setProperties(this.controller.getProperties());
        renderer.setMinifying(this.minifying);
        if (this.debugEmitter != null) {
            for (String string : classes.getClassNames()) {
                ClassHolder cls = classes.get(string);
                for (MethodHolder method : cls.getMethods()) {
                    if (method.getProgram() == null) continue;
                    this.emitCFG(this.debugEmitter, method.getProgram());
                }
                if (!this.controller.wasCancelled()) continue;
                return;
            }
            renderer.setDebugEmitter(this.debugEmitter);
        }
        renderer.getDebugEmitter().setLocationProvider(sourceWriter);
        for (Map.Entry entry : this.methodInjectors.entrySet()) {
            renderingContext.addInjector((MethodReference)entry.getKey(), (Injector)entry.getValue());
        }
        try {
            for (RendererListener rendererListener : this.rendererListeners) {
                rendererListener.begin(renderer, target);
            }
            sourceWriter.append("\"use strict\";").newLine();
            renderer.renderRuntime();
            renderer.render(clsNodes);
            renderer.renderStringPool();
            renderer.renderStringConstants();
            for (Map.Entry entry : this.controller.getEntryPoints().entrySet()) {
                sourceWriter.append("var ").append((String)entry.getKey()).ws().append("=").ws();
                MethodReference ref = ((TeaVMEntryPoint)entry.getValue()).getReference();
                sourceWriter.append(naming.getFullNameFor(ref));
                sourceWriter.append(";").newLine();
            }
            for (Map.Entry entry : this.controller.getExportedClasses().entrySet()) {
                sourceWriter.append("var ").append((String)entry.getKey()).ws().append("=").ws().appendClass((String)entry.getValue()).append(";").newLine();
            }
            for (RendererListener rendererListener : this.rendererListeners) {
                rendererListener.complete();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO Error occured", e);
        }
    }

    private List<ClassNode> modelToAst(ListableClassHolderSource classes) {
        AsyncMethodFinder asyncFinder = new AsyncMethodFinder(this.controller.getDependencyInfo().getCallGraph(), this.controller.getDiagnostics());
        asyncFinder.find(classes);
        this.asyncMethods.addAll(asyncFinder.getAsyncMethods());
        this.asyncFamilyMethods.addAll(asyncFinder.getAsyncFamilyMethods());
        Decompiler decompiler = new Decompiler(classes, this.controller.getClassLoader(), this.asyncMethods, this.asyncFamilyMethods);
        decompiler.setRegularMethodCache(this.controller.isIncremental() ? this.astCache : null);
        for (Map.Entry<MethodReference, Generator> entry : this.methodGenerators.entrySet()) {
            decompiler.addGenerator(entry.getKey(), entry.getValue());
        }
        for (MethodReference injectedMethod : this.methodInjectors.keySet()) {
            decompiler.addMethodToSkip(injectedMethod);
        }
        List<String> classOrder = decompiler.getClassOrdering(classes.getClassNames());
        ArrayList<ClassNode> classNodes = new ArrayList<ClassNode>();
        for (String className : classOrder) {
            ClassHolder cls = classes.get(className);
            for (MethodHolder method : cls.getMethods()) {
                this.preprocessNativeMethod(method);
                if (!this.controller.wasCancelled()) continue;
                break;
            }
            classNodes.add(decompiler.decompile(cls));
        }
        return classNodes;
    }

    private void preprocessNativeMethod(MethodHolder method) {
        if (!method.getModifiers().contains((Object)ElementModifier.NATIVE) || this.methodGenerators.get(method.getReference()) != null || this.methodInjectors.get(method.getReference()) != null || method.getAnnotations().get(GeneratedBy.class.getName()) != null || method.getAnnotations().get(InjectedBy.class.getName()) != null) {
            return;
        }
        method.getModifiers().remove((Object)ElementModifier.NATIVE);
        Program program = new Program();
        method.setProgram(program);
        for (int i = 0; i <= method.parameterCount(); ++i) {
            program.createVariable();
        }
        BasicBlock block = program.createBasicBlock();
        Variable exceptionVar = program.createVariable();
        ConstructInstruction newExceptionInsn = new ConstructInstruction();
        newExceptionInsn.setType(NoSuchMethodError.class.getName());
        newExceptionInsn.setReceiver(exceptionVar);
        block.add(newExceptionInsn);
        Variable constVar = program.createVariable();
        StringConstantInstruction constInsn = new StringConstantInstruction();
        constInsn.setConstant("Native method implementation not found: " + method.getReference());
        constInsn.setReceiver(constVar);
        block.add(constInsn);
        InvokeInstruction initExceptionInsn = new InvokeInstruction();
        initExceptionInsn.setInstance(exceptionVar);
        initExceptionInsn.setMethod(new MethodReference(NoSuchMethodError.class, "<init>", String.class, Void.TYPE));
        initExceptionInsn.setType(InvocationType.SPECIAL);
        initExceptionInsn.getArguments().add(constVar);
        block.add(initExceptionInsn);
        RaiseInstruction raiseInsn = new RaiseInstruction();
        raiseInsn.setException(exceptionVar);
        block.add(raiseInsn);
        this.controller.getDiagnostics().error(new CallLocation(method.getReference()), "Native method {{m0}} has no implementation", method.getReference());
    }

    private void emitCFG(DebugInformationEmitter emitter, Program program) {
        Map<TextLocation, TextLocation[]> cfg = ProgramUtils.getLocationCFG(program);
        for (Map.Entry<TextLocation, TextLocation[]> entry : cfg.entrySet()) {
            SourceLocation location = JavaScriptTarget.map(entry.getKey());
            SourceLocation[] successors = new SourceLocation[entry.getValue().length];
            for (int i = 0; i < entry.getValue().length; ++i) {
                successors[i] = JavaScriptTarget.map(entry.getValue()[i]);
            }
            emitter.addSuccessors(location, successors);
        }
    }

    private static SourceLocation map(TextLocation location) {
        if (location == null) {
            return null;
        }
        return new SourceLocation(location.getFileName(), location.getLine());
    }
}

