/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.tooling.testing;

import org.teavm.diagnostics.Diagnostics;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.ValueType;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.ValueEmitter;
import org.teavm.tooling.testing.TestEntryPoint;
import org.teavm.vm.spi.TeaVMHost;
import org.teavm.vm.spi.TeaVMPlugin;

class TestEntryPointTransformer
implements ClassHolderTransformer,
TeaVMPlugin {
    private String runnerClassName;
    private MethodReference testMethod;

    public TestEntryPointTransformer(String runnerClassName, MethodReference testMethod) {
        this.runnerClassName = runnerClassName;
        this.testMethod = testMethod;
    }

    @Override
    public void install(TeaVMHost host) {
        host.add(this);
    }

    @Override
    public void transformClass(ClassHolder cls, ClassReaderSource innerSource, Diagnostics diagnostics) {
        if (cls.getName().equals(TestEntryPoint.class.getName())) {
            for (MethodHolder method : cls.getMethods()) {
                if (!method.equals(method)) continue;
                if (method.getName().equals("createRunner")) {
                    method.setProgram(this.generateRunnerProgram(method, innerSource));
                    method.getModifiers().remove((Object)ElementModifier.NATIVE);
                    continue;
                }
                if (!method.getName().equals("launchTest")) continue;
                method.setProgram(this.generateLaunchProgram(method, innerSource));
                method.getModifiers().remove((Object)ElementModifier.NATIVE);
            }
        }
    }

    private Program generateRunnerProgram(MethodHolder method, ClassReaderSource innerSource) {
        ProgramEmitter pe = ProgramEmitter.create(method, innerSource);
        pe.construct(this.runnerClassName, new ValueEmitter[0]).returnValue();
        return pe.getProgram();
    }

    private Program generateLaunchProgram(MethodHolder method, ClassReaderSource innerSource) {
        ProgramEmitter pe = ProgramEmitter.create(method, innerSource);
        ValueEmitter testCaseVar = pe.getField(TestEntryPoint.class, "testCase", Object.class);
        pe.when(testCaseVar.isNull()).thenDo(() -> pe.setField(TestEntryPoint.class, "testCase", pe.construct(this.testMethod.getClassName(), new ValueEmitter[0]).cast(Object.class)));
        pe.getField(TestEntryPoint.class, "testCase", Object.class).cast(ValueType.object(this.testMethod.getClassName())).invokeSpecial(this.testMethod, new ValueEmitter[0]);
        pe.exit();
        return pe.getProgram();
    }
}

