/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.tooling.testing;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.teavm.common.FiniteExecutor;
import org.teavm.common.SimpleFiniteExecutor;
import org.teavm.common.ThreadPoolFiniteExecutor;
import org.teavm.debugging.information.DebugInformation;
import org.teavm.debugging.information.DebugInformationBuilder;
import org.teavm.javascript.EmptyRegularMethodNodeCache;
import org.teavm.javascript.InMemoryRegularMethodNodeCache;
import org.teavm.javascript.MethodNodeCache;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.CopyClassHolderSource;
import org.teavm.model.InMemoryProgramCache;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.PreOptimizingClassHolderSource;
import org.teavm.model.ProgramCache;
import org.teavm.parsing.ClasspathClassHolderSource;
import org.teavm.testing.JUnitTestAdapter;
import org.teavm.testing.TestAdapter;
import org.teavm.tooling.BaseTeaVMTool;
import org.teavm.tooling.EmptyTeaVMToolLog;
import org.teavm.tooling.TeaVMProblemRenderer;
import org.teavm.tooling.TeaVMToolException;
import org.teavm.tooling.TeaVMToolLog;
import org.teavm.tooling.sources.SourceFileProvider;
import org.teavm.tooling.sources.SourceFilesCopier;
import org.teavm.tooling.testing.ExceptionHelper;
import org.teavm.tooling.testing.TestCase;
import org.teavm.tooling.testing.TestClassBuilder;
import org.teavm.tooling.testing.TestEntryPoint;
import org.teavm.tooling.testing.TestEntryPointTransformer;
import org.teavm.tooling.testing.TestExceptionPlugin;
import org.teavm.tooling.testing.TestGroup;
import org.teavm.tooling.testing.TestMethodBuilder;
import org.teavm.tooling.testing.TestPlan;
import org.teavm.vm.DirectoryBuildTarget;
import org.teavm.vm.TeaVM;
import org.teavm.vm.TeaVMBuilder;

public class TeaVMTestTool
implements BaseTeaVMTool {
    private File outputDir = new File(".");
    private boolean minifying = true;
    private int numThreads = 1;
    private TestAdapter adapter = new JUnitTestAdapter();
    private List<ClassHolderTransformer> transformers = new ArrayList<ClassHolderTransformer>();
    private List<String> additionalScripts = new ArrayList<String>();
    private List<String> additionalScriptLocalPaths = new ArrayList<String>();
    private Properties properties = new Properties();
    private List<String> testClasses = new ArrayList<String>();
    private ClassLoader classLoader = TeaVMTestTool.class.getClassLoader();
    private TeaVMToolLog log = new EmptyTeaVMToolLog();
    private boolean debugInformationGenerated;
    private boolean sourceMapsFileGenerated;
    private boolean sourceFilesCopied;
    private boolean incremental;
    private List<SourceFileProvider> sourceFileProviders = new ArrayList<SourceFileProvider>();
    private MethodNodeCache astCache;
    private ProgramCache programCache;
    private SourceFilesCopier sourceFilesCopier;
    private List<TestClassBuilder> testPlan = new ArrayList<TestClassBuilder>();
    private int fileIndexGenerator;
    private long startTime;
    private int testCount;
    private AtomicInteger testsBuilt = new AtomicInteger();

    public File getOutputDir() {
        return this.outputDir;
    }

    @Override
    public void setTargetDirectory(File outputDir) {
        this.outputDir = outputDir;
    }

    public boolean isMinifying() {
        return this.minifying;
    }

    @Override
    public void setMinifying(boolean minifying) {
        this.minifying = minifying;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public TestAdapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(TestAdapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public List<ClassHolderTransformer> getTransformers() {
        return this.transformers;
    }

    public List<String> getAdditionalScripts() {
        return this.additionalScripts;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public List<String> getTestClasses() {
        return this.testClasses;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public TeaVMToolLog getLog() {
        return this.log;
    }

    @Override
    public void setLog(TeaVMToolLog log) {
        this.log = log;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    @Override
    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    public boolean isDebugInformationGenerated() {
        return this.debugInformationGenerated;
    }

    @Override
    public void setDebugInformationGenerated(boolean debugInformationGenerated) {
        this.debugInformationGenerated = debugInformationGenerated;
    }

    public boolean isSourceMapsFileGenerated() {
        return this.sourceMapsFileGenerated;
    }

    @Override
    public void setSourceMapsFileGenerated(boolean sourceMapsFileGenerated) {
        this.sourceMapsFileGenerated = sourceMapsFileGenerated;
    }

    public boolean isSourceFilesCopied() {
        return this.sourceFilesCopied;
    }

    @Override
    public void setSourceFilesCopied(boolean sourceFilesCopied) {
        this.sourceFilesCopied = sourceFilesCopied;
    }

    @Override
    public void addSourceFileProvider(SourceFileProvider sourceFileProvider) {
        this.sourceFileProviders.add(sourceFileProvider);
    }

    public TestPlan generate() throws TeaVMToolException {
        this.testsBuilt.set(0);
        Runnable finalizer = null;
        try {
            new File(this.outputDir, "tests").mkdirs();
            new File(this.outputDir, "res").mkdirs();
            this.resourceToFile("org/teavm/javascript/runtime.js", "res/runtime.js");
            String prefix = "org/teavm/tooling/test";
            this.resourceToFile(prefix + "/res/junit-support.js", "res/junit-support.js");
            this.resourceToFile(prefix + "/res/junit-client.js", "res/junit-client.js");
            this.resourceToFile(prefix + "/res/junit.css", "res/junit.css");
            this.resourceToFile(prefix + "/res/class_obj.png", "res/class_obj.png");
            this.resourceToFile(prefix + "/res/control-000-small.png", "res/control-000-small.png");
            this.resourceToFile(prefix + "/res/methpub_obj.png", "res/methpub_obj.png");
            this.resourceToFile(prefix + "/res/package_obj.png", "res/package_obj.png");
            this.resourceToFile(prefix + "/res/tick-small-red.png", "res/tick-small-red.png");
            this.resourceToFile(prefix + "/res/tick-small.png", "res/tick-small.png");
            this.resourceToFile(prefix + "/res/toggle-small-expand.png", "res/toggle-small-expand.png");
            this.resourceToFile(prefix + "/res/toggle-small.png", "res/toggle-small.png");
            this.resourceToFile(prefix + "/junit.html", "junit.html");
            this.resourceToFile(prefix + "/junit-client.html", "junit-client.html");
            ClassHolderSource classSource = new ClasspathClassHolderSource(this.classLoader);
            if (this.incremental) {
                classSource = new PreOptimizingClassHolderSource(classSource);
            }
            ArrayList<TestGroup> groups = new ArrayList<TestGroup>();
            for (String testClass : this.testClasses) {
                ClassHolder classHolder = classSource.get(testClass);
                if (classHolder == null) {
                    throw new TeaVMToolException("Could not find class " + testClass);
                }
                TestGroup group = this.findTests(classHolder);
                if (group == null) continue;
                groups.add(group);
            }
            this.includeAdditionalScripts(this.classLoader);
            this.astCache = new EmptyRegularMethodNodeCache();
            if (this.incremental) {
                this.astCache = new InMemoryRegularMethodNodeCache();
                this.programCache = new InMemoryProgramCache();
            }
            this.writeMetadata();
            FiniteExecutor executor = new SimpleFiniteExecutor();
            if (this.numThreads != 1) {
                int threads = this.numThreads != 0 ? this.numThreads : Runtime.getRuntime().availableProcessors();
                ThreadPoolFiniteExecutor threadedExecutor = new ThreadPoolFiniteExecutor(threads);
                finalizer = () -> threadedExecutor.stop();
                executor = threadedExecutor;
            }
            this.startTime = System.currentTimeMillis();
            int methodsGenerated = this.writeMethods(executor, classSource);
            if (this.sourceFilesCopied) {
                this.sourceFilesCopier.copy(new File(new File(this.outputDir, "tests"), "src"));
            }
            long timeSpent = System.currentTimeMillis() - this.startTime;
            this.log.info("Test files successfully generated for " + methodsGenerated + " method(s) in " + (double)timeSpent / 1000.0 + " seconds.");
            TestPlan testPlan = new TestPlan("res/runtime.js", groups);
            return testPlan;
        }
        catch (IOException e) {
            throw new TeaVMToolException("IO error occured generating JavaScript files", e);
        }
        finally {
            if (finalizer != null) {
                finalizer.run();
            }
        }
    }

    private void writeMetadata() throws IOException {
        File allTestsFile = new File(this.outputDir, "tests/all.js");
        try (OutputStreamWriter allTestsWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(allTestsFile), "UTF-8");){
            allTestsWriter.write("prepare = function() {\n");
            allTestsWriter.write("    return new JUnitServer(document.body).readTests([");
            boolean first = true;
            for (TestClassBuilder testClass : this.testPlan) {
                if (!first) {
                    ((Writer)allTestsWriter).append(",");
                }
                first = false;
                ((Writer)allTestsWriter).append("\n        { name : \"").append(testClass.getClassName()).append("\", methods : [");
                boolean firstMethod = true;
                for (TestMethodBuilder testMethod : testClass.getMethods()) {
                    String scriptName = testMethod.getFileName();
                    if (!firstMethod) {
                        ((Writer)allTestsWriter).append(",");
                    }
                    firstMethod = false;
                    ((Writer)allTestsWriter).append("\n            { name : \"" + testMethod.getMethod().getName() + "\", script : \"" + scriptName + "\", expected : [");
                    boolean firstException = true;
                    for (String exception : testMethod.getExpectedExceptions()) {
                        if (!firstException) {
                            ((Writer)allTestsWriter).append(", ");
                        }
                        firstException = false;
                        ((Writer)allTestsWriter).append("\"" + exception + "\"");
                    }
                    ((Writer)allTestsWriter).append("], additionalScripts : [");
                    for (int i = 0; i < this.additionalScriptLocalPaths.size(); ++i) {
                        if (i > 0) {
                            ((Writer)allTestsWriter).append(", ");
                        }
                        this.escapeString(this.additionalScriptLocalPaths.get(i), allTestsWriter);
                    }
                    ((Writer)allTestsWriter).append("] }");
                }
                ((Writer)allTestsWriter).append("] }");
            }
            allTestsWriter.write("], function() {}); }");
        }
    }

    private int writeMethods(FiniteExecutor executor, ClassHolderSource classSource) {
        int methodsGenerated = 0;
        this.log.info("Generating test files");
        this.sourceFilesCopier = new SourceFilesCopier(this.sourceFileProviders);
        this.sourceFilesCopier.setLog(this.log);
        for (TestClassBuilder testClass : this.testPlan) {
            for (TestMethodBuilder testMethod : testClass.getMethods()) {
                executor.execute(() -> {
                    this.log.debug("Building test for " + testMethod.getMethod());
                    try {
                        this.decompileClassesForTest(this.classLoader, new CopyClassHolderSource(classSource), testMethod);
                    }
                    catch (IOException e) {
                        this.log.error("Error generating JavaScript", e);
                    }
                });
                ++methodsGenerated;
            }
        }
        executor.complete();
        return methodsGenerated;
    }

    private void resourceToFile(String resource, String fileName) throws IOException {
        try (InputStream input = TeaVMTestTool.class.getClassLoader().getResourceAsStream(resource);
             FileOutputStream output = new FileOutputStream(new File(this.outputDir, fileName));){
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
    }

    private TestGroup findTests(ClassHolder cls) {
        ArrayList<TestCase> cases = new ArrayList<TestCase>();
        TestClassBuilder testClass = new TestClassBuilder(cls.getName());
        for (MethodHolder method : cls.getMethods()) {
            if (!this.adapter.acceptMethod(method)) continue;
            MethodReference ref = new MethodReference(cls.getName(), method.getDescriptor());
            String fileName = "tests/" + this.fileIndexGenerator++ + ".js";
            ArrayList<String> exceptions = new ArrayList<String>();
            for (String exception : this.adapter.getExpectedExceptions(method)) {
                exceptions.add(exception);
            }
            String runner = this.adapter.getRunner(method).getName();
            TestMethodBuilder testMethod = new TestMethodBuilder(ref, fileName, exceptions, runner);
            testClass.getMethods().add(testMethod);
            String debugTable = this.debugInformationGenerated ? testMethod.getFileName() + ".teavmdbg" : null;
            cases.add(new TestCase(ref.toString(), testMethod.getFileName(), debugTable, testMethod.getExpectedExceptions(), runner));
            ++this.testCount;
        }
        if (!testClass.getMethods().isEmpty()) {
            this.testPlan.add(testClass);
            return new TestGroup(cls.getName(), cases);
        }
        return null;
    }

    private void includeAdditionalScripts(ClassLoader classLoader) throws TeaVMToolException {
        if (this.additionalScripts == null) {
            return;
        }
        for (String script : this.additionalScripts) {
            String simpleName = script.substring(script.lastIndexOf(47) + 1);
            this.additionalScriptLocalPaths.add("tests/" + simpleName);
            if (classLoader.getResource(script) == null) {
                throw new TeaVMToolException("Additional script " + script + " was not found");
            }
            File file = new File(this.outputDir, "tests/" + simpleName);
            try {
                InputStream in = classLoader.getResourceAsStream(script);
                Throwable throwable = null;
                try {
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    FileOutputStream out = new FileOutputStream(file);
                    Throwable throwable2 = null;
                    try {
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((OutputStream)out).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (IOException e) {
                throw new TeaVMToolException("Error copying additional script " + script, e);
            }
        }
    }

    private void decompileClassesForTest(ClassLoader classLoader, ClassHolderSource classSource, TestMethodBuilder testMethod) throws IOException {
        Throwable throwable;
        DebugInformation debugInfo;
        String targetName = testMethod.getFileName();
        TeaVM vm = new TeaVMBuilder().setClassLoader(classLoader).setClassSource(classSource).build();
        vm.setIncremental(this.incremental);
        vm.setAstCache(this.astCache);
        vm.setProgramCache(this.programCache);
        vm.setProperties(this.properties);
        vm.setMinifying(this.minifying);
        vm.installPlugins();
        new TestExceptionPlugin().install(vm);
        new TestEntryPointTransformer(testMethod.getRunner(), testMethod.getMethod()).install(vm);
        for (ClassHolderTransformer transformer : this.transformers) {
            vm.add(transformer);
        }
        File file = new File(this.outputDir, testMethod.getFileName());
        DebugInformationBuilder debugInfoBuilder = this.sourceMapsFileGenerated || this.debugInformationGenerated ? new DebugInformationBuilder() : null;
        MethodReference methodRef = testMethod.getMethod();
        try (OutputStreamWriter innerWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
            MethodReference exceptionMsg = new MethodReference(ExceptionHelper.class, "showException", Throwable.class, String.class);
            vm.entryPoint("runTest", new MethodReference(TestEntryPoint.class, "run", Void.TYPE)).async();
            vm.entryPoint("extractException", exceptionMsg);
            vm.setDebugEmitter(debugInfoBuilder);
            vm.build(innerWriter, new DirectoryBuildTarget(this.outputDir));
            ((Writer)innerWriter).append("\n");
            ((Writer)innerWriter).append("\nJUnitClient.run();");
            if (this.sourceMapsFileGenerated) {
                String sourceMapsFileName = targetName.substring(targetName.lastIndexOf(47) + 1) + ".map";
                ((Writer)innerWriter).append("\n//# sourceMappingURL=").append(sourceMapsFileName);
            }
            if (!vm.getProblemProvider().getProblems().isEmpty()) {
                if (vm.getProblemProvider().getSevereProblems().isEmpty()) {
                    this.log.warning("Test built with warnings: " + methodRef);
                    TeaVMProblemRenderer.describeProblems(vm, this.log);
                } else {
                    this.log.warning("Test built with errors: " + methodRef);
                    TeaVMProblemRenderer.describeProblems(vm, this.log);
                }
            }
        }
        if (this.debugInformationGenerated) {
            debugInfo = debugInfoBuilder.getDebugInformation();
            File debugTableFile = new File(this.outputDir, targetName + ".teavmdbg");
            throwable = null;
            try (FileOutputStream debugInfoOut = new FileOutputStream(debugTableFile);){
                debugInfo.write(debugInfoOut);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        if (this.sourceMapsFileGenerated) {
            debugInfo = debugInfoBuilder.getDebugInformation();
            String sourceMapsFileName = targetName + ".map";
            throwable = null;
            try (OutputStreamWriter sourceMapsOut = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.outputDir, sourceMapsFileName)), "UTF-8");){
                debugInfo.writeAsSourceMaps(sourceMapsOut, "src", targetName);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        if (this.sourceFilesCopied && vm.getWrittenClasses() != null) {
            this.sourceFilesCopier.addClasses(vm.getWrittenClasses());
        }
        this.incrementCounter();
    }

    private void incrementCounter() {
        int count = this.testsBuilt.incrementAndGet();
        if (count % 10 != 0) {
            return;
        }
        long timeSpent = System.currentTimeMillis() - this.startTime;
        this.getLog().info(count + " of " + this.testCount + " tests built in " + (double)timeSpent / 1000.0 + " seconds (" + String.format("%.2f", (double)count / (double)timeSpent * 1000.0) + " tests per second avg.)");
    }

    private void escapeString(String string, Writer writer) throws IOException {
        writer.append('\"');
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    writer.append("\\\"");
                    continue block7;
                }
                case '\\': {
                    writer.append("\\\\");
                    continue block7;
                }
                case '\n': {
                    writer.append("\\n");
                    continue block7;
                }
                case '\r': {
                    writer.append("\\r");
                    continue block7;
                }
                case '\t': {
                    writer.append("\\t");
                    continue block7;
                }
                default: {
                    writer.append(c);
                }
            }
        }
        writer.append('\"');
    }
}

